/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model.remote.monitors;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.alerting.model.Input;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lorg/opensearch/commons/alerting/model/remote/monitors/RemoteMonitorInput;", "Lorg/opensearch/commons/alerting/model/Input;", "input", "Lorg/opensearch/core/common/bytes/BytesReference;", "<init>", "(Lorg/opensearch/core/common/bytes/BytesReference;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getInput", "()Lorg/opensearch/core/common/bytes/BytesReference;", "asTemplateArg", "", "", "", "name", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "common-utils"})
public final class RemoteMonitorInput
implements Input {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BytesReference input;
    @NotNull
    public static final String INPUT_FIELD = "input";
    @NotNull
    public static final String INPUT_SIZE = "size";
    @NotNull
    public static final String REMOTE_MONITOR_INPUT_FIELD = "remote_monitor_input";

    public RemoteMonitorInput(@NotNull BytesReference input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)INPUT_FIELD);
        this.input = input;
    }

    @NotNull
    public final BytesReference getInput() {
        return this.input;
    }

    public RemoteMonitorInput(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        BytesReference bytesReference = sin.readBytesReference();
        Intrinsics.checkNotNullExpressionValue((Object)bytesReference, (String)"readBytesReference(...)");
        this(bytesReference);
    }

    @Override
    @NotNull
    public Map<String, Object> asTemplateArg() {
        byte[] bytes = this.input.toBytesRef().bytes;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)INPUT_SIZE, (Object)bytes.length), TuplesKt.to((Object)INPUT_FIELD, (Object)bytes)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public String name() {
        return REMOTE_MONITOR_INPUT_FIELD;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeBytesReference(this.input);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        byte[] bytes = this.input.toBytesRef().bytes;
        XContentBuilder xContentBuilder = builder.startObject().startObject(REMOTE_MONITOR_INPUT_FIELD).field(INPUT_SIZE, bytes.length).field(INPUT_FIELD, bytes).endObject().endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
        return xContentBuilder;
    }

    @NotNull
    public final BytesReference component1() {
        return this.input;
    }

    @NotNull
    public final RemoteMonitorInput copy(@NotNull BytesReference input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)INPUT_FIELD);
        return new RemoteMonitorInput(input);
    }

    public static /* synthetic */ RemoteMonitorInput copy$default(RemoteMonitorInput remoteMonitorInput, BytesReference bytesReference, int n, Object object) {
        if ((n & 1) != 0) {
            bytesReference = remoteMonitorInput.input;
        }
        return remoteMonitorInput.copy(bytesReference);
    }

    @NotNull
    public String toString() {
        return "RemoteMonitorInput(input=" + this.input + ")";
    }

    public int hashCode() {
        return this.input.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RemoteMonitorInput)) {
            return false;
        }
        RemoteMonitorInput remoteMonitorInput = (RemoteMonitorInput)other;
        return Intrinsics.areEqual((Object)this.input, (Object)remoteMonitorInput.input);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/opensearch/commons/alerting/model/remote/monitors/RemoteMonitorInput$Companion;", "", "<init>", "()V", "INPUT_FIELD", "", "INPUT_SIZE", "REMOTE_MONITOR_INPUT_FIELD", "parse", "Lorg/opensearch/commons/alerting/model/remote/monitors/RemoteMonitorInput;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RemoteMonitorInput parse(@NotNull XContentParser xcp) {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            byte[] bytes = null;
            int size = 0;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string = fieldName;
                if (Intrinsics.areEqual((Object)string, (Object)RemoteMonitorInput.INPUT_FIELD)) {
                    bytes = xcp.binaryValue();
                    continue;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)RemoteMonitorInput.INPUT_SIZE)) continue;
                size = xcp.intValue();
            }
            BytesReference input = BytesReference.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(bytes, 0, size));
            Intrinsics.checkNotNull((Object)input);
            return new RemoteMonitorInput(input);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

