/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.shape;

import java.awt.Graphics2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UShape;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.geom.BezierUtils;
import net.sourceforge.plantuml.klimt.geom.EnsureVisible;
import net.sourceforge.plantuml.klimt.geom.MinFinder;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.Moveable;
import net.sourceforge.plantuml.klimt.geom.PointAndAngle;
import net.sourceforge.plantuml.klimt.geom.RectangleArea;
import net.sourceforge.plantuml.klimt.geom.USegmentType;
import net.sourceforge.plantuml.klimt.geom.XCubicCurve2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;

public class DotPath
implements UShape,
Moveable {
    private final List<XCubicCurve2D> beziers = new ArrayList<XCubicCurve2D>();
    private String comment;
    private String codeLine;

    public DotPath copy() {
        DotPath result = new DotPath();
        for (XCubicCurve2D c : this.beziers) {
            result.beziers.add(new XCubicCurve2D(c.x1, c.y1, c.ctrlx1, c.ctrly1, c.ctrlx2, c.ctrly2, c.x2, c.y2));
        }
        return result;
    }

    public static DotPath fromBeziers(List<XCubicCurve2D> beziers) {
        DotPath result = new DotPath();
        result.beziers.addAll((Collection<XCubicCurve2D>)Objects.requireNonNull(beziers));
        return result;
    }

    public DotPath addCurve(XPoint2D pt1, XPoint2D pt2, XPoint2D pt3, XPoint2D pt4) {
        ArrayList<XCubicCurve2D> beziersNew = new ArrayList<XCubicCurve2D>(this.beziers);
        beziersNew.add(new XCubicCurve2D(pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY(), pt3.getX(), pt3.getY(), pt4.getX(), pt4.getY()));
        return DotPath.fromBeziers(beziersNew);
    }

    public DotPath addCurve(XPoint2D pt2, XPoint2D pt3, XPoint2D pt4) {
        XCubicCurve2D last = this.beziers.get(this.beziers.size() - 1);
        XPoint2D p1 = last.getP2();
        return this.addCurve(p1, pt2, pt3, pt4);
    }

    public XPoint2D getStartPoint() {
        return this.beziers.get(0).getP1();
    }

    public Set<XPoint2D> sample() {
        HashSet<XPoint2D> result = new HashSet<XPoint2D>();
        for (XCubicCurve2D bez : this.beziers) {
            DotPath.sample(bez, result);
        }
        return Collections.unmodifiableSet(result);
    }

    private static void sample(XCubicCurve2D bez, Set<XPoint2D> result) {
        XPoint2D p1 = bez.getCtrlP1();
        XPoint2D p2 = bez.getCtrlP2();
        if (bez.getFlatnessSq() > 0.5 || p1.distance(p2) > 4.0) {
            XCubicCurve2D left = XCubicCurve2D.none();
            XCubicCurve2D right = XCubicCurve2D.none();
            bez.subdivide(left, right);
            DotPath.sample(left, result);
            DotPath.sample(right, result);
        } else {
            result.add(p1);
            result.add(p2);
        }
    }

    public PointAndAngle getMiddle() {
        XPoint2D result = null;
        double angle = 0.0;
        for (XCubicCurve2D bez : this.beziers) {
            XCubicCurve2D left = XCubicCurve2D.none();
            XCubicCurve2D right = XCubicCurve2D.none();
            bez.subdivide(left, right);
            XPoint2D p1 = left.getP1();
            XPoint2D p2 = left.getP2();
            XPoint2D p3 = right.getP1();
            XPoint2D p4 = right.getP2();
            if (result == null || this.getCost(p1) < this.getCost(result)) {
                result = p1;
                angle = BezierUtils.getStartingAngle(left);
            }
            if (this.getCost(p2) < this.getCost(result)) {
                result = p2;
                angle = BezierUtils.getEndingAngle(left);
            }
            if (this.getCost(p3) < this.getCost(result)) {
                result = p3;
                angle = BezierUtils.getStartingAngle(right);
            }
            if (!(this.getCost(p4) < this.getCost(result))) continue;
            result = p4;
            angle = BezierUtils.getEndingAngle(right);
        }
        return new PointAndAngle(result, angle);
    }

    private double getCost(XPoint2D pt) {
        XPoint2D start = this.getStartPoint();
        XPoint2D end = this.getEndPoint();
        return pt.distanceSq(start) + pt.distanceSq(end);
    }

    public void moveStartPoint(UTranslate move) {
        this.moveStartPoint(move.getDx(), move.getDy());
    }

    public void moveEndPoint(UTranslate move) {
        this.moveEndPoint(move.getDx(), move.getDy());
    }

    public void moveStartPoint(double dx, double dy) {
        if (this.beziers.size() > 1 && Math.sqrt(dx * dx + dy * dy) >= this.beziers.get(0).getLength()) {
            dx -= this.beziers.get((int)1).x1 - this.beziers.get((int)0).x1;
            dy -= this.beziers.get((int)1).y1 - this.beziers.get((int)0).y1;
            this.beziers.remove(0);
        }
        this.beziers.get((int)0).x1 += dx;
        this.beziers.get((int)0).y1 += dy;
        this.beziers.get((int)0).ctrlx1 += dx;
        this.beziers.get((int)0).ctrly1 += dy;
    }

    public XPoint2D getEndPoint() {
        return this.beziers.get(this.beziers.size() - 1).getP2();
    }

    public void moveEndPoint(double dx, double dy) {
        this.beziers.get((int)(this.beziers.size() - 1)).x2 += dx;
        this.beziers.get((int)(this.beziers.size() - 1)).y2 += dy;
        this.beziers.get((int)(this.beziers.size() - 1)).ctrlx2 += dx;
        this.beziers.get((int)(this.beziers.size() - 1)).ctrly2 += dy;
    }

    public MinFinder getMinFinder() {
        MinFinder result = new MinFinder();
        for (XCubicCurve2D c : this.beziers) {
            result.manage(c.x1, c.y1);
            result.manage(c.x2, c.y2);
            result.manage(c.ctrlx1, c.ctrly1);
            result.manage(c.ctrlx2, c.ctrly2);
        }
        return result;
    }

    public MinMax getMinMax() {
        MinMax result = MinMax.getEmpty(false);
        for (XCubicCurve2D c : this.beziers) {
            result = result.addPoint(c.x1, c.y1);
            result = result.addPoint(c.x2, c.y2);
            result = result.addPoint(c.ctrlx1, c.ctrly1);
            result = result.addPoint(c.ctrlx2, c.ctrly2);
        }
        return result;
    }

    public double getMinDist(XPoint2D ref) {
        double result = Double.MAX_VALUE;
        for (XCubicCurve2D c : this.beziers) {
            double d4;
            double d3;
            double d2;
            double d1 = ref.distance(c.x1, c.y1);
            if (d1 < result) {
                result = d1;
            }
            if ((d2 = ref.distance(c.x2, c.y2)) < result) {
                result = d2;
            }
            if ((d3 = ref.distance(c.ctrlx1, c.ctrly1)) < result) {
                result = d3;
            }
            if (!((d4 = ref.distance(c.ctrlx2, c.ctrly2)) < result)) continue;
            result = d4;
        }
        return result;
    }

    public Line2D getEndTangeante() {
        XCubicCurve2D last = this.beziers.get(this.beziers.size() - 1);
        double dx = last.x2 - last.ctrlx2;
        double dy = last.y2 - last.ctrly2;
        if (dx == 0.0 && dy == 0.0) {
            dx = last.x2 - last.x1;
            dy = last.y2 - last.y1;
        }
        return new Line2D.Double(last.x2, last.y2, last.x2 + dx, last.y2 + dy);
    }

    public double getEndAngle() {
        Line2D tan = this.getEndTangeante();
        double theta1 = Math.atan2(tan.getY2() - tan.getY1(), tan.getX2() - tan.getX1());
        return theta1;
    }

    public double getStartAngle() {
        Line2D tan = this.getStartTangeante();
        double theta1 = Math.atan2(tan.getY2() - tan.getY1(), tan.getX2() - tan.getX1());
        return theta1;
    }

    public Line2D getStartTangeante() {
        XCubicCurve2D first = this.beziers.get(0);
        double dx = first.ctrlx1 - first.x1;
        double dy = first.ctrly1 - first.y1;
        if (dx == 0.0 && dy == 0.0) {
            dx = first.x2 - first.x1;
            dy = first.y2 - first.y1;
        }
        return new Line2D.Double(first.x1, first.y1, first.x1 + dx, first.y1 + dy);
    }

    public DotPath addBefore(XCubicCurve2D before) {
        ArrayList<XCubicCurve2D> copy = new ArrayList<XCubicCurve2D>(this.beziers);
        copy.add(0, before);
        return DotPath.fromBeziers(copy);
    }

    private DotPath addBefore(DotPath other) {
        ArrayList<XCubicCurve2D> copy = new ArrayList<XCubicCurve2D>(this.beziers);
        copy.addAll(0, other.beziers);
        return DotPath.fromBeziers(copy);
    }

    public DotPath addAfter(XCubicCurve2D after) {
        ArrayList<XCubicCurve2D> copy = new ArrayList<XCubicCurve2D>(this.beziers);
        copy.add(after);
        return DotPath.fromBeziers(copy);
    }

    public DotPath addAfter(DotPath other) {
        ArrayList<XCubicCurve2D> copy = new ArrayList<XCubicCurve2D>(this.beziers);
        copy.addAll(other.beziers);
        return DotPath.fromBeziers(copy);
    }

    public void draw(Graphics2D g2d, double x, double y) {
        GeneralPath p = new GeneralPath();
        for (XCubicCurve2D bez : this.beziers) {
            CubicCurve2D.Double bez2 = new CubicCurve2D.Double(x + bez.x1, y + bez.y1, x + bez.ctrlx1, y + bez.ctrly1, x + bez.ctrlx2, y + bez.ctrly2, x + bez.x2, y + bez.y2);
            p.append(bez2, true);
        }
        g2d.draw(p);
    }

    public void manageEnsureVisible(double x, double y, EnsureVisible visible) {
        for (XCubicCurve2D bez : this.beziers) {
            visible.ensureVisible(x + bez.x1, y + bez.y1);
            visible.ensureVisible(x + bez.x2, y + bez.y2);
        }
    }

    public UPath toUPath() {
        UPath result = new UPath(this.comment, this.codeLine);
        boolean start = true;
        for (XCubicCurve2D bez : this.beziers) {
            if (start) {
                result.add(new double[]{bez.x1, bez.y1}, USegmentType.SEG_MOVETO);
                start = false;
            }
            result.add(new double[]{bez.ctrlx1, bez.ctrly1, bez.ctrlx2, bez.ctrly2, bez.x2, bez.y2}, USegmentType.SEG_CUBICTO);
        }
        return result;
    }

    public static String toString(XCubicCurve2D c) {
        return "(" + c.x1 + "," + c.y1 + ") (" + c.ctrlx1 + "," + c.ctrly1 + ") (" + c.ctrlx2 + "," + c.ctrly2 + ") (" + c.x2 + "," + c.y2 + ") ";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (XCubicCurve2D c : this.beziers) {
            sb.append(DotPath.toString(c));
            sb.append(" - ");
        }
        return sb.toString();
    }

    public static XCubicCurve2D reverse(XCubicCurve2D curv) {
        return new XCubicCurve2D(curv.getX2(), curv.getY2(), curv.getCtrlX2(), curv.getCtrlY2(), curv.getCtrlX1(), curv.getCtrlY1(), curv.getX1(), curv.getY1());
    }

    public DotPath reverse() {
        ArrayList<XCubicCurve2D> reverse = new ArrayList<XCubicCurve2D>(this.beziers);
        Collections.reverse(reverse);
        ArrayList<XCubicCurve2D> copy = new ArrayList<XCubicCurve2D>();
        for (XCubicCurve2D cub : reverse) {
            copy.add(DotPath.reverse(cub));
        }
        return DotPath.fromBeziers(copy);
    }

    @Override
    public void moveDelta(double deltaX, double deltaY) {
        for (int i = 0; i < this.beziers.size(); ++i) {
            XCubicCurve2D c = this.beziers.get(i);
            this.beziers.set(i, new XCubicCurve2D(c.x1 + deltaX, c.y1 + deltaY, c.ctrlx1 + deltaX, c.ctrly1 + deltaY, c.ctrlx2 + deltaX, c.ctrly2 + deltaY, c.x2 + deltaX, c.y2 + deltaY));
        }
    }

    public final List<XCubicCurve2D> getBeziers() {
        return Collections.unmodifiableList(this.beziers);
    }

    public DotPath simulateCompound(RectangleArea head, RectangleArea tail) {
        XCubicCurve2D part2;
        XCubicCurve2D part1;
        int k;
        DotPath result;
        if (head == null && tail == null) {
            return this;
        }
        DotPath me = this;
        if (tail != null && tail.contains(this.getStartPoint())) {
            result = new DotPath();
            int idx = 0;
            while (idx + 1 < this.beziers.size() && tail.contains(this.beziers.get(idx).getP2())) {
                if (!tail.contains(this.beziers.get(idx).getP1())) {
                    throw new IllegalStateException();
                }
                ++idx;
            }
            if (!tail.contains(this.beziers.get(idx).getP2())) {
                assert (tail.contains(this.beziers.get(idx).getP1()));
                assert (!tail.contains(this.beziers.get(idx).getP2()));
                XCubicCurve2D current = this.beziers.get(idx);
                for (k = 0; k < 8; ++k) {
                    part1 = XCubicCurve2D.none();
                    part2 = XCubicCurve2D.none();
                    current.subdivide(part1, part2);
                    assert (part1.getP2().equals(part2.getP1()));
                    if (tail.contains(part1.getP2())) {
                        current = part2;
                        continue;
                    }
                    result.beziers.add(0, part2);
                    current = part1;
                }
                for (int i = idx + 1; i < this.beziers.size(); ++i) {
                    result.beziers.add(this.beziers.get(i));
                }
                me = result;
            }
        }
        if (head != null) {
            result = new DotPath();
            if (head.contains(this.getEndPoint())) {
                for (XCubicCurve2D current : me.beziers) {
                    if (!head.contains(current.getP2())) {
                        result.beziers.add(current);
                        continue;
                    }
                    if (head.contains(current.getP1())) {
                        return me;
                    }
                    assert (!head.contains(current.getP1()));
                    assert (head.contains(current.getP2()));
                    for (k = 0; k < 8; ++k) {
                        part1 = XCubicCurve2D.none();
                        part2 = XCubicCurve2D.none();
                        current.subdivide(part1, part2);
                        assert (part1.getP2().equals(part2.getP1()));
                        if (head.contains(part1.getP2())) {
                            current = part1;
                            continue;
                        }
                        result.beziers.add(part1);
                        current = part2;
                    }
                    return result;
                }
            }
        }
        return me;
    }

    public boolean isLine() {
        for (XCubicCurve2D curve : this.beziers) {
            if (!(curve.getFlatnessSq() > 0.001)) continue;
            return false;
        }
        return true;
    }

    public void setCommentAndCodeLine(String comment, String codeLine) {
        this.comment = comment;
        this.codeLine = codeLine;
    }

    public void muteToRoundOrthogonalPaths(double radius) {
        if (radius <= 0.0 || this.beziers.size() < 2) {
            return;
        }
        if (!this.isOrthogonalPathInternal()) {
            return;
        }
        ArrayList<XPoint2D> points = new ArrayList<XPoint2D>();
        if (this.beziers.size() > 0) {
            points.add(this.beziers.get(0).getP1());
            for (XCubicCurve2D bez : this.beziers) {
                points.add(bez.getP2());
            }
        }
        if (points.size() < 3) {
            return;
        }
        List<Integer> corners = this.detectCorners(points);
        if (corners.isEmpty()) {
            return;
        }
        List<XPoint2D> newPoints = this.buildRoundedPath(points, corners, radius);
        List<XCubicCurve2D> newBeziers = this.buildBeziersFromPoints(newPoints, points, corners);
        this.beziers.clear();
        this.beziers.addAll(newBeziers);
    }

    private List<Integer> detectCorners(List<XPoint2D> points) {
        ArrayList<Integer> corners = new ArrayList<Integer>();
        for (int i = 1; i < points.size() - 1; ++i) {
            double dotProduct;
            XPoint2D prev = points.get(i - 1);
            XPoint2D curr = points.get(i);
            XPoint2D next = points.get(i + 1);
            double dx1 = curr.getX() - prev.getX();
            double dy1 = curr.getY() - prev.getY();
            double dx2 = next.getX() - curr.getX();
            double dy2 = next.getY() - curr.getY();
            double len1 = Math.sqrt(dx1 * dx1 + dy1 * dy1);
            double len2 = Math.sqrt(dx2 * dx2 + dy2 * dy2);
            if (len1 < 0.01 || len2 < 0.01 || !(Math.abs(dotProduct = (dx1 /= len1) * (dx2 /= len2) + (dy1 /= len1) * (dy2 /= len2)) < 0.1)) continue;
            corners.add(i);
        }
        return corners;
    }

    private List<XPoint2D> buildRoundedPath(List<XPoint2D> points, List<Integer> corners, double radius) {
        ArrayList<XPoint2D> newPoints = new ArrayList<XPoint2D>();
        newPoints.add(points.get(0));
        for (int i = 1; i < points.size() - 1; ++i) {
            if (corners.contains(i)) {
                XPoint2D prev = points.get(i - 1);
                XPoint2D curr = points.get(i);
                XPoint2D next = points.get(i + 1);
                double dx1 = curr.getX() - prev.getX();
                double dy1 = curr.getY() - prev.getY();
                double dx2 = next.getX() - curr.getX();
                double dy2 = next.getY() - curr.getY();
                double len1 = Math.sqrt(dx1 * dx1 + dy1 * dy1);
                double len2 = Math.sqrt(dx2 * dx2 + dy2 * dy2);
                dx1 /= len1;
                dy1 /= len1;
                dx2 /= len2;
                dy2 /= len2;
                double truncDist1 = Math.min(radius, len1 / 2.0);
                double truncDist2 = Math.min(radius, len2 / 2.0);
                double beforeX = curr.getX() - dx1 * truncDist1;
                double beforeY = curr.getY() - dy1 * truncDist1;
                newPoints.add(new XPoint2D(beforeX, beforeY));
                newPoints.add(curr);
                double afterX = curr.getX() + dx2 * truncDist2;
                double afterY = curr.getY() + dy2 * truncDist2;
                newPoints.add(new XPoint2D(afterX, afterY));
                continue;
            }
            newPoints.add(points.get(i));
        }
        newPoints.add(points.get(points.size() - 1));
        return newPoints;
    }

    private List<XCubicCurve2D> buildBeziersFromPoints(List<XPoint2D> newPoints, List<XPoint2D> originalPoints, List<Integer> corners) {
        ArrayList<XCubicCurve2D> newBeziers = new ArrayList<XCubicCurve2D>();
        for (int i = 0; i < newPoints.size() - 1; ++i) {
            XPoint2D p1 = newPoints.get(i);
            XPoint2D p2 = newPoints.get(i + 1);
            if (i + 2 < newPoints.size()) {
                XPoint2D p3 = newPoints.get(i + 2);
                boolean isCornerControl = false;
                for (int cornerIdx : corners) {
                    if (!originalPoints.get(cornerIdx).equals(p2)) continue;
                    isCornerControl = true;
                    break;
                }
                if (isCornerControl) {
                    double dx1 = p2.getX() - p1.getX();
                    double dy1 = p2.getY() - p1.getY();
                    double dx2 = p3.getX() - p2.getX();
                    double dy2 = p3.getY() - p2.getY();
                    double len1 = Math.sqrt(dx1 * dx1 + dy1 * dy1);
                    double len2 = Math.sqrt(dx2 * dx2 + dy2 * dy2);
                    double controlDist = Math.min(len1, len2) * 0.55228;
                    double ctrl1X = p1.getX() + dx1 / len1 * controlDist;
                    double ctrl1Y = p1.getY() + dy1 / len1 * controlDist;
                    double ctrl2X = p3.getX() - dx2 / len2 * controlDist;
                    double ctrl2Y = p3.getY() - dy2 / len2 * controlDist;
                    newBeziers.add(new XCubicCurve2D(p1.getX(), p1.getY(), ctrl1X, ctrl1Y, ctrl2X, ctrl2Y, p3.getX(), p3.getY()));
                    ++i;
                    continue;
                }
            }
            newBeziers.add(new XCubicCurve2D(p1.getX(), p1.getY(), p1.getX(), p1.getY(), p2.getX(), p2.getY(), p2.getX(), p2.getY()));
        }
        return newBeziers;
    }

    private boolean isOrthogonalPathInternal() {
        for (XCubicCurve2D curve : this.beziers) {
            double dx = Math.abs(curve.x2 - curve.x1);
            double dy = Math.abs(curve.y2 - curve.y1);
            if (!(dx > 0.1) || !(dy > 0.1)) continue;
            return false;
        }
        return true;
    }

    public static class TriPoints {
        public final double x1;
        public final double y1;
        public final double x2;
        public final double y2;
        public final double x;
        public final double y;

        public TriPoints(XPoint2D p1, XPoint2D p2, XPoint2D p) {
            this.x1 = p1.getX();
            this.y1 = p1.getY();
            this.x2 = p2.getX();
            this.y2 = p2.getY();
            this.x = p.getX();
            this.y = p.getY();
        }
    }
}

