/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstCompoundStatement;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstNamedElementContainer;
import com.jetbrains.python.ast.PyAstStatementList;
import com.jetbrains.python.ast.PyAstStatementListContainer;
import com.jetbrains.python.ast.PyAstWithItem;
import com.jetbrains.python.ast.impl.PyUtilCore;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public interface PyAstWithStatement
extends PyAstCompoundStatement,
PyAstNamedElementContainer,
PyAstStatementListContainer {
    public static final TokenSet WITH_ITEM;

    @Override
    @NotNull
    default public List<PsiNamedElement> getNamedElements() {
        PyAstWithItem[] items = (PyAstWithItem[])PsiTreeUtil.getChildrenOfType((PsiElement)this, PyAstWithItem.class);
        ArrayList<PsiNamedElement> result2 = new ArrayList<PsiNamedElement>();
        if (items != null) {
            for (PyAstWithItem item : items) {
                PyAstExpression targetExpression = item.getTarget();
                List<PyAstExpression> expressions = PyUtilCore.flattenedParensAndTuples(targetExpression);
                for (PyAstExpression expression : expressions) {
                    if (!(expression instanceof PsiNamedElement)) continue;
                    result2.add((PsiNamedElement)expression);
                }
            }
        }
        ArrayList<PsiNamedElement> arrayList = result2;
        if (arrayList == null) {
            PyAstWithStatement.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    default public PyAstWithItem[] getWithItems() {
        return (PyAstWithItem[])this.childrenToPsi(WITH_ITEM, PyAstWithItem.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    default public PyAstStatementList getStatementList() {
        PyAstStatementList statementList = (PyAstStatementList)this.childToPsi(PyElementTypes.STATEMENT_LIST);
        if (!1.$assertionsDisabled && statementList == null) {
            throw new AssertionError((Object)("Statement list missing for with statement " + this.getText()));
        }
        PyAstStatementList pyAstStatementList = statementList;
        if (pyAstStatementList == null) {
            PyAstWithStatement.$$$reportNull$$$0(1);
        }
        return pyAstStatementList;
    }

    default public boolean isAsync() {
        return this.getNode().findChildByType((IElementType)PyTokenTypes.ASYNC_KEYWORD) != null;
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPyWithStatement(this);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        WITH_ITEM = TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.WITH_ITEM});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/python/ast/PyAstWithStatement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementList";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

