/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.inspections.AddIntermediateCastQuickFix;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyInvalidCastInspectionKt;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/PyInvalidCastInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "intellij.python.psi.impl"})
public final class PyInvalidCastInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        return new PyInspectionVisitor(holder, typeEvalContext){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void visitPyCallExpression(PyCallExpression callExpression) {
                PyType actualType;
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
                List<PyCallable> list = callExpression.multiResolveCalleeFunction(this.getResolveContext());
                Intrinsics.checkNotNullExpressionValue(list, (String)"multiResolveCalleeFunction(...)");
                List<PyCallable> callees = list;
                Iterable $this$any$iv = callees;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return;
                }
                Iterator<T> iterator = $this$any$iv.iterator();
                do {
                    block9: {
                        block8: {
                            if (!iterator.hasNext()) return;
                            T element$iv = iterator.next();
                            PyCallable it = (PyCallable)element$iv;
                            boolean bl2 = false;
                            PyFunction pyFunction = it instanceof PyFunction ? (PyFunction)it : null;
                            if (Intrinsics.areEqual((Object)(pyFunction != null ? pyFunction.getQualifiedName() : null), (Object)"typing.cast")) break block8;
                            PyFunction pyFunction2 = it instanceof PyFunction ? (PyFunction)it : null;
                            if (!Intrinsics.areEqual((Object)(pyFunction2 != null ? pyFunction2.getQualifiedName() : null), (Object)"typing_extensions.cast")) break block9;
                        }
                        bl = true;
                        continue;
                    }
                    bl = false;
                } while (!bl);
                boolean bl3 = true;
                boolean isCastCall = bl3;
                if (!isCastCall) {
                    return;
                }
                PyExpression[] pyExpressionArray = callExpression.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getArguments(...)");
                PyExpression[] args = pyExpressionArray;
                if (args.length != 2) {
                    return;
                }
                Ref<PyType> targetTypeRef = PyTypingTypeProvider.getType(args[0], this.myTypeEvalContext);
                PyType targetType = (PyType)Ref.deref(targetTypeRef);
                if (PyTypeChecker.overlappingTypes(targetType, actualType = this.myTypeEvalContext.getType(args[1]), this.myTypeEvalContext)) {
                    return;
                }
                String string = PythonDocumentationProvider.getTypeName(actualType, this.myTypeEvalContext);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypeName(...)");
                String fromName = string;
                String string2 = PythonDocumentationProvider.getVerboseTypeName(targetType, this.myTypeEvalContext);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getVerboseTypeName(...)");
                String toName = string2;
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                String suggestedName = PyInvalidCastInspectionKt.access$computeSuggestedIntermediateTypeName(targetType, actualType, typeEvalContext);
                Object[] objectArray = new Object[]{fromName, toName, suggestedName};
                String string3 = PyPsiBundle.message("INSP.invalid.cast.message", objectArray);
                objectArray = new LocalQuickFix[]{new AddIntermediateCastQuickFix(suggestedName)};
                this.registerProblem((PsiElement)callExpression, string3, (LocalQuickFix[])objectArray);
            }
        };
    }
}

