/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.SyntaxTreeBuilder;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.ICompositeElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.TriConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.lexer.PythonIndentingLexerForLazyElements;
import com.jetbrains.python.parsing.PyLazyParser;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyReparseableElementType;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyStatementListImpl;
import org.jetbrains.annotations.NotNull;

public class PyStatementListElementType
extends PyReparseableElementType
implements ICompositeElementType {
    private static final Logger LOG = Logger.getInstance(PyReparseableElementType.class);
    public static final Key<LanguageLevel> LANGUAGE_LEVEL_KEY = Key.create((String)"LANGUAGE_LEVEL_FOR_REPARSEABLE_ELEMENT");
    public static final Key<Integer> BASE_INDENT_KEY = Key.create((String)"FIRST_LINE_INDENT_FOR_REPARSEABLE_ELEMENT");

    public PyStatementListElementType() {
        super("PyStatementList");
    }

    public boolean isReparseable(@NotNull ASTNode currentNode, @NotNull CharSequence newText, @NotNull Language fileLanguage, @NotNull Project project) {
        boolean parentContainsErrors;
        if (currentNode == null) {
            PyStatementListElementType.$$$reportNull$$$0(0);
        }
        if (newText == null) {
            PyStatementListElementType.$$$reportNull$$$0(1);
        }
        if (fileLanguage == null) {
            PyStatementListElementType.$$$reportNull$$$0(2);
        }
        if (project == null) {
            PyStatementListElementType.$$$reportNull$$$0(3);
        }
        if (!Registry.is((String)"python.statement.lists.incremental.reparse")) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempting to reparse lazy element of type " + String.valueOf((Object)this) + "\nparent: " + String.valueOf(currentNode.getTreeParent()) + "\nold text: \n" + currentNode.getText() + "\n\nnew text: \n" + String.valueOf(newText));
        }
        if (newText.isEmpty() || !fileLanguage.is((Language)PythonLanguage.INSTANCE)) {
            return false;
        }
        boolean bl = parentContainsErrors = ContainerUtil.findInstance((Object[])((PyStatementListImpl)currentNode).getChildren(), PsiErrorElement.class) != null;
        if (parentContainsErrors) {
            LOG.debug("Previous node contains PsiErrorElement, reparse is declined");
            return false;
        }
        boolean isAfterColonOnSameLine = PyStatementListElementType.isAfterColonOnSameLine((PsiElement)((PyStatementListImpl)currentNode));
        String firstLineIndent = isAfterColonOnSameLine ? "" : PyIndentUtil.getElementIndent(currentNode.getPsi());
        PythonIndentingLexerForLazyElements lexer = new PythonIndentingLexerForLazyElements(firstLineIndent.length());
        return PyStatementListElementType.checkIndentDedentBalanceWithLexer(newText, (Lexer)lexer, isAfterColonOnSameLine);
    }

    private static boolean isAfterColonOnSameLine(PsiElement currentNode) {
        PsiElement prevSibling = PyPsiUtils.getPrevNonWhitespaceSiblingOnSameLine(currentNode);
        return prevSibling != null && prevSibling.getNode().getElementType() == PyTokenTypes.COLON;
    }

    public static boolean checkIndentDedentBalanceWithLexer(@NotNull CharSequence text, @NotNull Lexer lexer, boolean isOnTheSameLine) {
        int balance;
        if (text == null) {
            PyStatementListElementType.$$$reportNull$$$0(4);
        }
        if (lexer == null) {
            PyStatementListElementType.$$$reportNull$$$0(5);
        }
        lexer.start(text);
        int n = balance = isOnTheSameLine ? 0 : -1;
        while (lexer.getTokenType() != null) {
            if (lexer.getTokenType() == PyTokenTypes.INDENT) {
                ++balance;
            } else if (lexer.getTokenType() == PyTokenTypes.DEDENT) {
                --balance;
            }
            if (balance < 0) {
                LOG.debug("Indent/Dedent balance is negative, incremental reparse declined");
                return false;
            }
            lexer.advance();
        }
        return true;
    }

    public boolean isValidReparse(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
        String firstLineIndent;
        if (oldNode == null) {
            PyStatementListElementType.$$$reportNull$$$0(6);
        }
        if (newNode == null) {
            PyStatementListElementType.$$$reportNull$$$0(7);
        }
        PsiFile file = oldNode.getPsi().getContainingFile();
        String string = firstLineIndent = PyStatementListElementType.isAfterColonOnSameLine(oldNode.getPsi()) ? "" : PyIndentUtil.getElementIndent(oldNode.getPsi());
        if (!(file instanceof PyFile)) {
            return false;
        }
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)file);
        newNode.putUserData(LANGUAGE_LEVEL_KEY, (Object)languageLevel);
        newNode.putUserData(BASE_INDENT_KEY, (Object)firstLineIndent.length());
        ASTNode tmp = newNode.getFirstChildNode();
        if (tmp == null) {
            return false;
        }
        LOG.debug("Element of type " + String.valueOf((Object)this) + " reparsed successfully");
        return true;
    }

    protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement psi) {
        if (chameleon == null) {
            PyStatementListElementType.$$$reportNull$$$0(8);
        }
        if (psi == null) {
            PyStatementListElementType.$$$reportNull$$$0(9);
        }
        PsiElement parentPsiElement = chameleon.getTreeParent().getPsi();
        assert (parentPsiElement != null) : "parent psi is null: " + String.valueOf(chameleon);
        Integer indent = (Integer)chameleon.getUserData(BASE_INDENT_KEY);
        assert (indent != null);
        LanguageLevel languageLevel = (LanguageLevel)((Object)chameleon.getUserData(LANGUAGE_LEVEL_KEY));
        if (languageLevel == null) {
            languageLevel = LanguageLevel.getDefault();
        }
        PythonIndentingLexerForLazyElements lexer = new PythonIndentingLexerForLazyElements(indent);
        LOG.debug("Performing lazy reparse for element of type " + String.valueOf((Object)this));
        PsiBuilder builder = PyStatementListElementType.createBuilder(parentPsiElement, chameleon, (Lexer)lexer);
        PyLazyParser parser = new PyLazyParser();
        parser.setLanguageLevel(languageLevel);
        return parser.parseLazyElement((IElementType)this, builder, languageLevel, (TriConsumer<? super IElementType, ? super SyntaxTreeBuilder, ? super LanguageLevel>)((TriConsumer)PyLazyParser::parseStatementList));
    }

    @NotNull
    private static PsiBuilder createBuilder(@NotNull PsiElement parentPsi, @NotNull ASTNode chameleon, @NotNull Lexer lexer) {
        if (parentPsi == null) {
            PyStatementListElementType.$$$reportNull$$$0(10);
        }
        if (chameleon == null) {
            PyStatementListElementType.$$$reportNull$$$0(11);
        }
        if (lexer == null) {
            PyStatementListElementType.$$$reportNull$$$0(12);
        }
        PythonLanguage languageForParser = PythonLanguage.INSTANCE;
        PsiBuilder psiBuilder = PsiBuilderFactory.getInstance().createBuilder(parentPsi.getProject(), chameleon, lexer, (Language)languageForParser, chameleon.getChars());
        if (psiBuilder == null) {
            PyStatementListElementType.$$$reportNull$$$0(13);
        }
        return psiBuilder;
    }

    public ASTNode createNode(CharSequence text) {
        return new PyStatementListImpl(text);
    }

    @NotNull
    public ASTNode createCompositeNode() {
        return new PyStatementListImpl((IElementType)this, null);
    }

    public String toString() {
        return "PyStatementList";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileLanguage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNode";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chameleon";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPsi";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyStatementListElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyStatementListElementType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isReparseable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkIndentDedentBalanceWithLexer";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isValidReparse";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doParseContents";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }
}

