/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyNeverType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeVisitor;
import com.jetbrains.python.psi.types.PyTypeVisitorExt;
import com.jetbrains.python.psi.types.PyUnsafeUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUnionType
implements PyType {
    private final @NotNull LinkedHashSet<@Nullable PyType> myMembers;

    @ApiStatus.Internal
    public static boolean isStrictSemanticsEnabled() {
        return Registry.is((String)"python.typing.strict.unions", (boolean)true);
    }

    PyUnionType(@NotNull LinkedHashSet<@Nullable PyType> members) {
        if (members == null) {
            PyUnionType.$$$reportNull$$$0(0);
        }
        this.myMembers = new LinkedHashSet<PyType>(members);
    }

    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name == null) {
            PyUnionType.$$$reportNull$$$0(1);
        }
        if (direction == null) {
            PyUnionType.$$$reportNull$$$0(2);
        }
        if (resolveContext == null) {
            PyUnionType.$$$reportNull$$$0(3);
        }
        SmartList ret = new SmartList();
        boolean allNulls = true;
        for (PyType member : this.myMembers) {
            List result;
            if (member == null || (result = member.resolveMember(name, location, direction, resolveContext)) == null) continue;
            allNulls = false;
            ret.addAll((Collection)result);
        }
        return allNulls ? null : ret;
    }

    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        HashSet variants = new HashSet();
        for (PyType member : this.myMembers) {
            if (member == null) continue;
            Collections.addAll(variants, member.getCompletionVariants(completionPrefix, location, context));
        }
        return ArrayUtil.toObjectArray(variants);
    }

    public String getName() {
        return StringUtil.join(this.myMembers, t -> t == null ? "Any" : t.getName(), (String)" | ");
    }

    public boolean isBuiltin() {
        for (PyType one : this.myMembers) {
            if (one != null && one.isBuiltin()) continue;
            return false;
        }
        return true;
    }

    public void assertValid(String message) {
        for (PyType member : this.myMembers) {
            if (member == null) continue;
            member.assertValid(message);
        }
    }

    @Nullable
    public static PyType union(@Nullable PyType type1, @Nullable PyType type2) {
        return PyUnionType.union(Arrays.asList(type1, type2));
    }

    @Nullable
    public static PyType union(@NotNull Collection<@Nullable PyType> members) {
        if (members == null) {
            PyUnionType.$$$reportNull$$$0(4);
        }
        return PyUnionType.unionOrDefault(members, null);
    }

    @Nullable
    public static PyType unionOrNever(@NotNull Collection<@Nullable PyType> members) {
        if (members == null) {
            PyUnionType.$$$reportNull$$$0(5);
        }
        return PyUnionType.unionOrDefault(members, (PyType)PyNeverType.NEVER);
    }

    @Nullable
    private static PyType unionOrDefault(@NotNull Collection<@Nullable PyType> members, @Nullable PyType defaultResult) {
        if (members == null) {
            PyUnionType.$$$reportNull$$$0(6);
        }
        LinkedHashSet<PyType> newMembers = new LinkedHashSet<PyType>();
        for (PyType member : members) {
            if (member instanceof PyNeverType) {
                defaultResult = PyNeverType.NEVER;
                continue;
            }
            if (member instanceof PyUnionType) {
                PyUnionType unionType = (PyUnionType)member;
                newMembers.addAll(unionType.getMembers());
                continue;
            }
            newMembers.add(member);
        }
        return newMembers.size() < 2 ? (PyType)ContainerUtil.getFirstItem(newMembers, (Object)defaultResult) : new PyUnionType(newMembers);
    }

    @Nullable
    public static PyType createWeakType(@Nullable PyType type) {
        PyUnionType unionType;
        if (type == null) {
            return null;
        }
        if (type instanceof PyUnionType && (unionType = (PyUnionType)type).isWeak()) {
            return unionType;
        }
        if (PyUnionType.isStrictSemanticsEnabled()) {
            return PyUnsafeUnionType.unsafeUnion(type, null);
        }
        return PyUnionType.union(type, null);
    }

    @Nullable
    public static PyType toNonWeakType(@Nullable PyType type) {
        if (PyUnionType.isStrictSemanticsEnabled()) {
            if (type instanceof PyUnsafeUnionType) {
                PyUnsafeUnionType unsafeUnionType = (PyUnsafeUnionType)type;
                return PyUnsafeUnionType.unsafeUnion(ContainerUtil.skipNulls(unsafeUnionType.getMembers()));
            }
        } else if (type instanceof PyUnionType) {
            PyUnionType unionType = (PyUnionType)type;
            return unionType.excludeNull();
        }
        return type;
    }

    @Deprecated
    public boolean isWeak() {
        return !PyUnionType.isStrictSemanticsEnabled() && this.myMembers.contains(null);
    }

    public @NotNull Collection<@Nullable PyType> getMembers() {
        Collection<PyType> collection = Collections.unmodifiableCollection(this.myMembers);
        if (collection == null) {
            PyUnionType.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @Nullable
    public PyType map(@NotNull Function<@Nullable PyType, @Nullable PyType> mapper) {
        if (mapper == null) {
            PyUnionType.$$$reportNull$$$0(8);
        }
        return PyUnionType.union(ContainerUtil.map(this.getMembers(), t -> (PyType)mapper.apply((PyType)t)));
    }

    @Nullable
    public PyType exclude(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyUnionType.$$$reportNull$$$0(9);
        }
        if (type == null) {
            return this.excludeNull();
        }
        ArrayList<PyType> members = new ArrayList<PyType>();
        for (PyType m : this.getMembers()) {
            if (PyTypeChecker.match(type, m, context)) continue;
            members.add(m);
        }
        return PyUnionType.union(members);
    }

    @Nullable
    public PyType excludeNull() {
        if (!PyUnionType.isStrictSemanticsEnabled()) {
            return !this.isWeak() ? this : PyUnionType.union(ContainerUtil.skipNulls(this.getMembers()));
        }
        return PyUnionType.union(ContainerUtil.skipNulls(this.getMembers()));
    }

    public boolean equals(Object other) {
        if (other instanceof PyUnionType) {
            PyUnionType otherType = (PyUnionType)other;
            return this.myMembers.equals(otherType.myMembers);
        }
        return false;
    }

    public int hashCode() {
        return this.myMembers.hashCode();
    }

    public String toString() {
        return "PyUnionType: " + this.getName();
    }

    public <T> T acceptTypeVisitor(@NotNull PyTypeVisitor<T> visitor) {
        if (visitor == null) {
            PyUnionType.$$$reportNull$$$0(10);
        }
        if (visitor instanceof PyTypeVisitorExt) {
            PyTypeVisitorExt visitorExt = (PyTypeVisitorExt)visitor;
            return visitorExt.visitPyUnionType(this);
        }
        return (T)visitor.visitPyType((PyType)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyUnionType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyUnionType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unionOrNever";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unionOrDefault";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "exclude";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "acceptTypeVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

