\name{BinShrinkImageFilter}
\alias{BinShrinkImageFilter}
\title{BinShrinkImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Reduce the size of an image by an integer factor in each dimension
while performing averaging of an input neighborhood.
BinShrinkImageFilter}
\details{
The output image size in each dimension is given by:
outputSize[j] = max( std::floor(inputSize[j]/shrinkFactor[j]), 1 );
The algorithm implemented can be describe with the following equation
for 2D: \deqn{ \mathsf{I}_{out}(x_o,x_1) = \frac{\sum_{i=0}^{f_0}\sum_{j=0}^{f_1}\mathsf{I}_{in}(f_0 x_o+i,f_1 x_1+j)}{f_0 f_1} }
This filter is implemented so that the starting extent of the first
pixel of the output matches that of the input.
The change in image geometry from a 5x5 image binned by a factor of
2x2.
This code was contributed in the Insight Journal paper: "BinShrink: A
multi-resolution filter with cache efficient averaging" by Lowekamp
B., Chen D. https://www.insight-journal.org/browse/publication/912
See:
BinShrink for the procedural interface
itk::BinShrinkImageFilter for the Doxygen on the original ITK class.
BinShrinkImageFilter}
%C++ includes: sitkBinShrinkImageFilter.h
\section{Methods}{
\describe{
\item{ BinShrinkImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetShrinkFactors() const:}{
Get the shrink factors.
}
\item{Self SetShrinkFactor(unsigned int s):}{
Custom public declarations
}
\item{Self SetShrinkFactors(std::vector< unsigned int > ShrinkFactors):}{
Set the shrink factors. Values are clamped to a minimum value of 1.
Default is 1 for all dimensions.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~BinShrinkImageFilter():}{
Destructor
}
}
}
