/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.DataContext;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.Strong;
import org.apache.calcite.plan.VisitorDataContext;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexExecutable;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexExecutorImpl;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.runtime.PairList;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.trace.CalciteLogger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.LoggerFactory;

public class RexImplicationChecker {
    private static final CalciteLogger LOGGER = new CalciteLogger(LoggerFactory.getLogger(RexImplicationChecker.class));
    final RexBuilder builder;
    final RexExecutor executor;
    final RelDataType rowType;

    public RexImplicationChecker(RexBuilder builder, RexExecutor executor, RelDataType rowType) {
        this.builder = Objects.requireNonNull(builder, "builder");
        this.executor = Objects.requireNonNull(executor, "executor");
        this.rowType = Objects.requireNonNull(rowType, "rowType");
    }

    public boolean implies(RexNode first, RexNode second) {
        if (!RexImplicationChecker.validate(first, second)) {
            return false;
        }
        LOGGER.debug("Checking if {} => {}", (Object)first.toString(), (Object)second.toString());
        RexNode firstDnf = RexUtil.toDnf(this.builder, first);
        RexNode secondDnf = RexUtil.toDnf(this.builder, second);
        if (firstDnf.isAlwaysFalse() || secondDnf.isAlwaysTrue()) {
            return true;
        }
        List<RexNode> firsts = RelOptUtil.disjunctions(firstDnf);
        List<RexNode> seconds = RelOptUtil.disjunctions(secondDnf);
        for (RexNode f : firsts) {
            if (this.impliesAny(f, seconds)) continue;
            LOGGER.debug("{} does not imply {}", (Object)first, (Object)second);
            return false;
        }
        LOGGER.debug("{} implies {}", (Object)first, (Object)second);
        return true;
    }

    private boolean impliesAny(RexNode first, List<RexNode> seconds) {
        for (RexNode second : seconds) {
            if (!this.impliesConjunction(first, second)) continue;
            return true;
        }
        return false;
    }

    private boolean impliesConjunction(RexNode first, RexNode second) {
        if (this.implies2(first, second)) {
            return true;
        }
        switch (first.getKind()) {
            case AND: {
                for (RexNode f : RelOptUtil.conjunctions(first)) {
                    if (!this.implies2(f, second)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private boolean implies2(RexNode first, RexNode second) {
        if (second.isAlwaysFalse()) {
            return false;
        }
        if (first.equals(second)) {
            return true;
        }
        switch (second.getKind()) {
            case IS_NOT_NULL: {
                final RexNode operand = ((RexCall)second).getOperands().get(0);
                Strong strong = new Strong(){

                    @Override
                    public boolean isNull(RexNode node) {
                        return node.equals(operand) || super.isNull(node);
                    }
                };
                if (!strong.isNull(first)) break;
                return true;
            }
        }
        InputUsageFinder firstUsageFinder = new InputUsageFinder();
        InputUsageFinder secondUsageFinder = new InputUsageFinder();
        RexUtil.apply((RexVisitor<Void>)firstUsageFinder, (List<? extends RexNode>)ImmutableList.of(), first);
        RexUtil.apply((RexVisitor<Void>)secondUsageFinder, (List<? extends RexNode>)ImmutableList.of(), second);
        if (!RexImplicationChecker.checkSupport(firstUsageFinder, secondUsageFinder)) {
            LOGGER.warn("Support for checking {} => {} is not there", (Object)first, (Object)second);
            return false;
        }
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable ImmutableList.Builder usagesBuilder = ImmutableList.builder();
        for (Map.Entry<RexInputRef, InputRefUsage<SqlOperator, RexNode>> entry : firstUsageFinder.usageMap.entrySet()) {
            // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable ImmutableSet.Builder usageBuilder = ImmutableSet.builder();
            if (((InputRefUsage)entry.getValue()).usageList.size() <= 0) continue;
            ((InputRefUsage)entry.getValue()).usageList.rightList().forEach(v -> usageBuilder.add(Pair.of(entry.getKey(), v)));
            usagesBuilder.add((Object)usageBuilder.build());
        }
        @Nullable Set usages = Sets.cartesianProduct((List)usagesBuilder.build());
        for (List usageList : usages) {
            DataContext dataValues = VisitorDataContext.of(this.rowType, usageList);
            if (this.isSatisfiable(second, dataValues)) continue;
            return false;
        }
        return true;
    }

    private boolean isSatisfiable(RexNode second, @Nullable DataContext dataValues) {
        Object[] result;
        if (dataValues == null) {
            return false;
        }
        ImmutableList constExps = ImmutableList.of((Object)second);
        RexExecutable exec = RexExecutorImpl.getExecutable(this.builder, (List<RexNode>)constExps, this.rowType);
        exec.setDataContext(dataValues);
        try {
            result = exec.execute();
        }
        catch (Exception e) {
            LOGGER.warn("Exception thrown while checking if => {}: {}", (Object)second, (Object)e.getMessage());
            return false;
        }
        return result != null && result.length == 1 && result[0] instanceof Boolean && (Boolean)result[0] != false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static boolean checkSupport(InputUsageFinder firstUsageFinder, InputUsageFinder secondUsageFinder) {
        Map<RexInputRef, InputRefUsage<SqlOperator, @Nullable RexNode>> firstUsageMap = firstUsageFinder.usageMap;
        Map<RexInputRef, InputRefUsage<SqlOperator, @Nullable RexNode>> secondUsageMap = secondUsageFinder.usageMap;
        for (Map.Entry<RexInputRef, InputRefUsage<SqlOperator, RexNode>> entry : secondUsageMap.entrySet()) {
            SqlKind sKind2;
            InputRefUsage<SqlOperator, @Nullable RexNode> secondUsage = entry.getValue();
            @Nullable PairList secondUsageList = ((InputRefUsage)secondUsage).usageList;
            int secondLen = secondUsageList.size();
            if (((InputRefUsage)secondUsage).usageCount != secondLen || secondLen > 2) {
                return false;
            }
            InputRefUsage<SqlOperator, @Nullable RexNode> firstUsage = firstUsageMap.get(entry.getKey());
            if (firstUsage == null || ((InputRefUsage)firstUsage).usageList.size() != ((InputRefUsage)firstUsage).usageCount || ((InputRefUsage)firstUsage).usageCount > 2) {
                return false;
            }
            @Nullable PairList firstUsageList = ((InputRefUsage)firstUsage).usageList;
            int firstLen = firstUsageList.size();
            SqlKind fKind = ((SqlOperator)((Map.Entry)firstUsageList.get(0)).getKey()).getKind();
            SqlKind sKind = ((SqlOperator)((Map.Entry)secondUsageList.get(0)).getKey()).getKind();
            SqlKind fKind2 = firstLen == 2 ? ((SqlOperator)((Map.Entry)firstUsageList.get(1)).getKey()).getKind() : null;
            SqlKind sqlKind = sKind2 = secondLen == 2 ? ((SqlOperator)((Map.Entry)secondUsageList.get(1)).getKey()).getKind() : null;
            if (!(firstLen != 2 || secondLen != 2 || fKind2 == null || sKind2 == null || RexImplicationChecker.isEquivalentOp(fKind, sKind) && RexImplicationChecker.isEquivalentOp(fKind2, sKind2) || RexImplicationChecker.isEquivalentOp(fKind, sKind2) && RexImplicationChecker.isEquivalentOp(fKind2, sKind))) {
                return false;
            }
            if (firstLen == 1 && secondLen == 1 && fKind != SqlKind.EQUALS && !RexImplicationChecker.isSupportedUnaryOperators(sKind) && !RexImplicationChecker.isEquivalentOp(fKind, sKind)) {
                return false;
            }
            if (firstLen == 1 && secondLen == 2 && fKind != SqlKind.EQUALS) {
                return false;
            }
            if (firstLen != 2 || secondLen != 1 || fKind2 == null || RexImplicationChecker.isOppositeOp(fKind, fKind2) || RexImplicationChecker.isSupportedUnaryOperators(sKind) || RexImplicationChecker.isEquivalentOp(fKind, fKind2) && RexImplicationChecker.isEquivalentOp(fKind, sKind)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSupportedUnaryOperators(SqlKind kind) {
        switch (kind) {
            case IS_NOT_NULL: 
            case IS_NULL: {
                return true;
            }
        }
        return false;
    }

    private static boolean isEquivalentOp(@Nullable SqlKind fKind, SqlKind sKind) {
        switch (sKind) {
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                if (fKind == SqlKind.GREATER_THAN || fKind == SqlKind.GREATER_THAN_OR_EQUAL) break;
                return false;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                if (fKind == SqlKind.LESS_THAN || fKind == SqlKind.LESS_THAN_OR_EQUAL) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static boolean isOppositeOp(SqlKind fKind, SqlKind sKind) {
        switch (sKind) {
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                if (fKind == SqlKind.LESS_THAN || fKind == SqlKind.LESS_THAN_OR_EQUAL) break;
                return false;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                if (fKind == SqlKind.GREATER_THAN || fKind == SqlKind.GREATER_THAN_OR_EQUAL) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static boolean validate(RexNode first, RexNode second) {
        return first instanceof RexCall && second instanceof RexCall;
    }

    private static class InputRefUsage<T1, T2> {
        private final PairList<T1, T2> usageList = PairList.of();
        private int usageCount = 0;

        private InputRefUsage() {
        }
    }

    private static class InputUsageFinder
    extends RexVisitorImpl<Void> {
        final Map<RexInputRef, InputRefUsage<SqlOperator, @Nullable RexNode>> usageMap = new HashMap<RexInputRef, InputRefUsage<SqlOperator, RexNode>>();

        InputUsageFinder() {
            super(true);
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            InputRefUsage<SqlOperator, @Nullable RexNode> inputRefUse = this.getUsageMap(inputRef);
            ((InputRefUsage)inputRefUse).usageCount++;
            return null;
        }

        @Override
        public Void visitCall(RexCall call) {
            switch (call.getOperator().getKind()) {
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case EQUALS: 
                case NOT_EQUALS: {
                    this.updateBinaryOpUsage(call);
                    break;
                }
                case IS_NOT_NULL: 
                case IS_NULL: {
                    this.updateUnaryOpUsage(call);
                    break;
                }
            }
            return (Void)super.visitCall(call);
        }

        private void updateUnaryOpUsage(RexCall call) {
            List<RexNode> operands = call.getOperands();
            RexNode first = RexUtil.removeCast(operands.get(0));
            if (first.isA(SqlKind.INPUT_REF)) {
                this.updateUsage(call.getOperator(), (RexInputRef)first, null);
            }
        }

        private void updateBinaryOpUsage(RexCall call) {
            List<RexNode> operands = call.getOperands();
            RexNode first = RexUtil.removeCast(operands.get(0));
            RexNode second = RexUtil.removeCast(operands.get(1));
            if (first.isA(SqlKind.INPUT_REF) && second.isA(SqlKind.LITERAL)) {
                this.updateUsage(call.getOperator(), (RexInputRef)first, second);
            }
            if (first.isA(SqlKind.LITERAL) && second.isA(SqlKind.INPUT_REF)) {
                this.updateUsage(Objects.requireNonNull(call.getOperator().reverse()), (RexInputRef)second, first);
            }
        }

        private void updateUsage(SqlOperator op, RexInputRef inputRef, @Nullable RexNode literal) {
            InputRefUsage<SqlOperator, @Nullable RexNode> inputRefUse = this.getUsageMap(inputRef);
            ((InputRefUsage)inputRefUse).usageList.add(op, literal);
        }

        private InputRefUsage<SqlOperator, @Nullable RexNode> getUsageMap(RexInputRef rex) {
            InputRefUsage<SqlOperator, @Nullable RexNode> inputRefUse = this.usageMap.get(rex);
            if (inputRefUse == null) {
                inputRefUse = new InputRefUsage();
                this.usageMap.put(rex, inputRefUse);
            }
            return inputRefUse;
        }
    }
}

