/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.api.endpoint;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import org.apache.solr.client.api.model.CreateCollectionSnapshotRequestBody;
import org.apache.solr.client.api.model.CreateCollectionSnapshotResponse;
import org.apache.solr.client.api.model.DeleteCollectionSnapshotResponse;
import org.apache.solr.client.api.model.ListCollectionSnapshotsResponse;

public interface CollectionSnapshotApis {

    @Path(value="/collections/{collName}/snapshots")
    public static interface List {
        @GET
        @Operation(summary="List the snapshots available for a specified collection.", tags={"collection-snapshots"})
        public ListCollectionSnapshotsResponse listSnapshots(@Parameter(description="The name of the collection.", required=true) @PathParam(value="collName") String var1) throws Exception;
    }

    @Path(value="/collections/{collName}/snapshots/{snapshotName}")
    public static interface Delete {
        @DELETE
        @Operation(summary="Delete an existing collection-snapshot by name.", tags={"collection-snapshots"})
        public DeleteCollectionSnapshotResponse deleteCollectionSnapshot(@Parameter(description="The name of the collection.", required=true) @PathParam(value="collName") String var1, @Parameter(description="The name of the snapshot to be deleted.", required=true) @PathParam(value="snapshotName") String var2, @Parameter(description="A flag that treats the collName parameter as a collection alias.") @DefaultValue(value="false") @QueryParam(value="followAliases") boolean var3, @QueryParam(value="async") String var4) throws Exception;
    }

    @Path(value="/collections/{collName}/snapshots")
    public static interface Create {
        @POST
        @Path(value="/{snapshotName}")
        @Operation(summary="Creates a new snapshot of the specified collection.", tags={"collection-snapshots"})
        public CreateCollectionSnapshotResponse createCollectionSnapshot(@Parameter(description="The name of the collection.", required=true) @PathParam(value="collName") String var1, @Parameter(description="The name of the snapshot to be created.", required=true) @PathParam(value="snapshotName") String var2, @RequestBody(description="Contains user provided parameters", required=true) CreateCollectionSnapshotRequestBody var3) throws Exception;
    }
}

