/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.auxfile;

import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.auxfile.AuxData;
import com.dickimawbooks.texparserlib.auxfile.CrossRefInfo;
import com.dickimawbooks.texparserlib.auxfile.DivisionInfo;

public class CiteInfo
implements CrossRefInfo {
    protected String label;
    protected TeXObject reference;
    protected DivisionInfo divisionInfo;
    protected TeXObjectList[] params;

    protected CiteInfo(String string) {
        this.label = string;
    }

    public static CiteInfo createCite(AuxData auxData, TeXParser teXParser) {
        String string = auxData.getArg(0).toString(teXParser);
        CiteInfo citeInfo = new CiteInfo(string);
        citeInfo.reference = auxData.getArg(1);
        if (teXParser.isStack(citeInfo.reference) && !citeInfo.reference.isEmpty()) {
            TeXObjectList teXObjectList = (TeXObjectList)citeInfo.reference;
            boolean bl = true;
            for (TeXObject teXObject : teXObjectList) {
                if (teXObject instanceof Group) continue;
                bl = false;
                break;
            }
            if (bl) {
                citeInfo.params = new TeXObjectList[teXObjectList.size()];
                for (int i = 0; i < citeInfo.params.length; ++i) {
                    citeInfo.params[i] = ((Group)teXObjectList.get(i)).toList();
                }
            }
        }
        return citeInfo;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getTarget() {
        return this.label;
    }

    @Override
    public TeXObject getReference() {
        return this.reference;
    }

    @Override
    public void setDivisionInfo(DivisionInfo divisionInfo) {
        this.divisionInfo = divisionInfo;
    }

    @Override
    public DivisionInfo getDivisionInfo() {
        return this.divisionInfo;
    }

    public boolean hasParameters() {
        return this.params != null;
    }

    public int getParameterCount() {
        return this.params == null ? 0 : this.params.length;
    }

    public TeXObjectList getParameter(int n) {
        return this.params[n];
    }

    public String toString() {
        return this.label;
    }
}

