/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.latex3;

import com.dickimawbooks.texparserlib.DoubleParam;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Param;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.latex3.L3Arg;
import java.io.IOException;
import java.util.Arrays;

public class LaTeX3GenericCommand
extends GenericCommand {
    private L3Arg[] argList;
    protected boolean isRobust = true;

    public LaTeX3GenericCommand(String string, L3Arg[] l3ArgArray, TeXObjectList teXObjectList) {
        this(string, true, l3ArgArray, teXObjectList);
    }

    public LaTeX3GenericCommand(String string, boolean bl, L3Arg[] l3ArgArray, TeXObjectList teXObjectList) {
        super(true, string, null, teXObjectList);
        this.isRobust = bl;
        this.argList = l3ArgArray;
    }

    @Override
    public Object clone() {
        return new LaTeX3GenericCommand(this.getName(), this.isRobust, this.argList, (TeXObjectList)this.getDefinition().clone());
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof LaTeX3GenericCommand)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        LaTeX3GenericCommand laTeX3GenericCommand = (LaTeX3GenericCommand)object;
        if (this.isShort != laTeX3GenericCommand.isShort || !this.getDefinition().equals(laTeX3GenericCommand.getDefinition())) {
            return false;
        }
        if (this.argList == null && laTeX3GenericCommand.argList == null) {
            return true;
        }
        if (this.argList == null || laTeX3GenericCommand.argList == null) {
            return false;
        }
        return Arrays.equals(this.argList, laTeX3GenericCommand.argList);
    }

    @Override
    public boolean canExpand() {
        return !this.isRobust;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.isRobust ? null : this.getReplacement(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.isRobust ? null : this.getReplacement(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.isRobust ? null : this.getReplacement(teXParser, teXObjectList).expandfully(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.isRobust ? null : this.getReplacement(teXParser).expandfully(teXParser);
    }

    @Override
    protected TeXObjectList getReplacement(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.argList == null) {
            return (TeXObjectList)this.getDefinition().clone();
        }
        TeXObject[] teXObjectArray = new TeXObject[this.argList.length];
        for (int i = 0; i < this.argList.length; ++i) {
            TeXObject teXObject = null;
            byte by = this.argList[i].getPopStyle();
            int n = this.argList[i].getToken1();
            int n2 = this.argList[i].getToken2();
            switch (this.argList[i].getId()) {
                case 79: 
                case 111: {
                    n = 91;
                    n2 = 93;
                }
                case 68: 
                case 82: 
                case 100: 
                case 114: {
                    teXObject = teXObjectList.popArg(teXParser, by, n, n2);
                    if (teXObject != null || (teXObject = this.argList[i].getDefaultValue()) == null) break;
                    teXObject = (TeXObject)teXObject.clone();
                    break;
                }
                case 109: {
                    teXObject = teXObjectList.popArg(teXParser, by);
                    break;
                }
                case 115: {
                    n = 42;
                }
                case 116: {
                    if (this.popModifier(teXParser, teXObjectList, n) == n) {
                        teXObject = teXParser.getListener().getControlSequence("BooleanTrue");
                        break;
                    }
                    teXObject = teXParser.getListener().getControlSequence("BooleanFalse");
                    break;
                }
                default: {
                    throw new LaTeXSyntaxException(teXParser, "latex.unsupported.xparse_type", this.argList[i], this.toString(teXParser));
                }
            }
            if (teXObject == null) {
                teXObject = L3Arg.createNoValue(teXParser);
            }
            teXObjectArray[i] = teXObject;
        }
        TeXObjectList teXObjectList2 = new TeXObjectList();
        this.addReplacements(teXParser, teXObjectList2, teXObjectArray, this.getDefinition());
        if (teXParser.isDebugMode(32)) {
            teXParser.logMessage("Replacement: " + teXObjectList2);
        }
        if (teXParser.isDebugMode(16)) {
            teXParser.logMessage("Replacement: " + teXObjectList2.toString(teXParser));
        }
        return teXObjectList2;
    }

    @Override
    protected TeXObjectList getReplacement(TeXParser teXParser) throws IOException {
        if (this.argList == null) {
            return (TeXObjectList)this.getDefinition().clone();
        }
        TeXObject[] teXObjectArray = new TeXObject[this.argList.length];
        for (int i = 0; i < this.argList.length; ++i) {
            TeXObject teXObject = null;
            byte by = this.argList[i].getPopStyle();
            int n = this.argList[i].getToken1();
            int n2 = this.argList[i].getToken2();
            switch (this.argList[i].getId()) {
                case 79: 
                case 111: {
                    n = 91;
                    n2 = 93;
                }
                case 68: 
                case 82: 
                case 100: 
                case 114: {
                    teXObject = teXParser.popNextArg(by, n, n2);
                    if (teXObject != null || (teXObject = this.argList[i].getDefaultValue()) == null) break;
                    teXObject = (TeXObject)teXObject.clone();
                    break;
                }
                case 109: {
                    teXObject = teXParser.popNextArg(by);
                    break;
                }
                case 115: {
                    n = 42;
                }
                case 116: {
                    if (this.popModifier(teXParser, teXParser, n) == n) {
                        teXObject = teXParser.getListener().getControlSequence("BooleanTrue");
                        break;
                    }
                    teXObject = teXParser.getListener().getControlSequence("BooleanFalse");
                    break;
                }
                case 118: {
                    teXObject = teXParser.popVerb();
                    break;
                }
                default: {
                    throw new LaTeXSyntaxException(teXParser, "latex.unsupported.xparse_type", this.argList[i], this.toString(teXParser));
                }
            }
            if (teXObject == null) {
                teXObject = L3Arg.createNoValue(teXParser);
            }
            teXObjectArray[i] = teXObject;
        }
        TeXObjectList teXObjectList = new TeXObjectList();
        this.addReplacements(teXParser, teXObjectList, teXObjectArray, this.getDefinition());
        if (teXParser.isDebugMode(32)) {
            teXParser.logMessage("Replacement: " + teXObjectList);
        }
        if (teXParser.isDebugMode(16)) {
            teXParser.logMessage("Replacement: " + teXObjectList.toString(teXParser));
        }
        return teXObjectList;
    }

    protected void addReplacements(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject[] teXObjectArray, TeXObjectList teXObjectList2) throws TeXSyntaxException {
        for (TeXObject teXObject : teXObjectList2) {
            if (teXObject instanceof Param) {
                int n = ((Param)teXObject).getDigit();
                if (teXObjectArray == null || n > teXObjectArray.length) {
                    throw new TeXSyntaxException(teXParser, "tex.error.illegal_param", n, this.toString(teXParser));
                }
                teXObjectList.add((TeXObject)teXObjectArray[--n].clone());
                continue;
            }
            if (teXObject instanceof DoubleParam) {
                teXObjectList.add((TeXObject)((DoubleParam)teXObject).next().clone());
                continue;
            }
            if (teXObject instanceof TeXObjectList) {
                TeXObjectList teXObjectList3 = ((TeXObjectList)teXObject).createList();
                teXObjectList.add(teXObjectList3);
                this.addReplacements(teXParser, teXObjectList3, teXObjectArray, (TeXObjectList)teXObject);
                continue;
            }
            teXObjectList.add((TeXObject)teXObject.clone());
        }
    }

    public String getLaTeXSyntaxString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.argList != null) {
            for (L3Arg l3Arg : this.argList) {
                stringBuilder.append(l3Arg.toString());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return String.format("%s[name=%s,robust=%s,syntax=%s,definition=%s]", this.getClass().getSimpleName(), this.getName(), this.isRobust, this.getLaTeXSyntaxString(), this.getDefinition());
    }
}

