/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.OutStream;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;
import com.tigervnc.rfb.Screen;
import com.tigervnc.rfb.ScreenSet;
import com.tigervnc.rfb.ServerParams;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;

public class CMsgWriter {
    protected ServerParams server;
    protected OutStream os;

    protected CMsgWriter(ServerParams serverParams, OutStream outStream) {
        this.server = serverParams;
        this.os = outStream;
    }

    public synchronized void writeClientInit(boolean bl) {
        this.os.writeU8(bl ? 1 : 0);
        this.endMsg();
    }

    public synchronized void writeSetPixelFormat(PixelFormat pixelFormat) {
        this.startMsg(0);
        this.os.pad(3);
        pixelFormat.write(this.os);
        this.endMsg();
    }

    public synchronized void writeSetEncodings(List<Integer> list) {
        this.startMsg(2);
        this.os.skip(1);
        this.os.writeU16(list.size());
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.os.writeU32(iterator.next());
        }
        this.endMsg();
    }

    public synchronized void writeSetDesktopSize(int n, int n2, ScreenSet screenSet) {
        if (!this.server.supportsSetDesktopSize) {
            throw new Exception("Server does not support SetDesktopSize");
        }
        this.startMsg(251);
        this.os.pad(1);
        this.os.writeU16(n);
        this.os.writeU16(n2);
        this.os.writeU8(screenSet.num_screens());
        this.os.pad(1);
        for (Screen screen : screenSet.screens) {
            this.os.writeU32(screen.id);
            this.os.writeU16(screen.dimensions.tl.x);
            this.os.writeU16(screen.dimensions.tl.y);
            this.os.writeU16(screen.dimensions.width());
            this.os.writeU16(screen.dimensions.height());
            this.os.writeU32(screen.flags);
        }
        this.endMsg();
    }

    public synchronized void writeFramebufferUpdateRequest(Rect rect, boolean bl) {
        this.startMsg(3);
        this.os.writeU8(bl ? 1 : 0);
        this.os.writeU16(rect.tl.x);
        this.os.writeU16(rect.tl.y);
        this.os.writeU16(rect.width());
        this.os.writeU16(rect.height());
        this.endMsg();
    }

    public synchronized void writeEnableContinuousUpdates(boolean bl, int n, int n2, int n3, int n4) {
        if (!this.server.supportsContinuousUpdates) {
            throw new Exception("Server does not support continuous updates");
        }
        this.startMsg(150);
        this.os.writeU8(bl ? 1 : 0);
        this.os.writeU16(n);
        this.os.writeU16(n2);
        this.os.writeU16(n3);
        this.os.writeU16(n4);
        this.endMsg();
    }

    public synchronized void writeFence(int n, int n2, byte[] byArray) {
        if (!this.server.supportsFence) {
            throw new Exception("Server does not support fences");
        }
        if (n2 > 64) {
            throw new Exception("Too large fence payload");
        }
        if ((n & 0x7FFFFFF8) != 0) {
            throw new Exception("Unknown fence flags");
        }
        this.startMsg(248);
        this.os.pad(3);
        this.os.writeU32(n);
        this.os.writeU8(n2);
        this.os.writeBytes(byArray, 0, n2);
        this.endMsg();
    }

    public synchronized void writeKeyEvent(int n, boolean bl) {
        this.startMsg(4);
        this.os.writeU8(bl ? 1 : 0);
        this.os.pad(2);
        this.os.writeU32(n);
        this.endMsg();
    }

    public synchronized void writePointerEvent(Point point, int n) {
        Point point2 = new Point(point.x, point.y);
        if (point2.x < 0) {
            point2.x = 0;
        }
        if (point2.y < 0) {
            point2.y = 0;
        }
        if (point2.x >= this.server.width()) {
            point2.x = this.server.width() - 1;
        }
        if (point2.y >= this.server.height()) {
            point2.y = this.server.height() - 1;
        }
        this.startMsg(5);
        this.os.writeU8(n);
        this.os.writeU16(point2.x);
        this.os.writeU16(point2.y);
        this.endMsg();
    }

    public synchronized void writeClientCutText(String string, int n) {
        this.startMsg(6);
        this.os.pad(3);
        this.os.writeU32(n);
        Charset charset = Charset.forName("ISO-8859-1");
        ByteBuffer byteBuffer = charset.encode(string);
        this.os.writeBytes(byteBuffer.array(), 0, n);
        this.endMsg();
    }

    protected synchronized void startMsg(int n) {
        this.os.writeU8(n);
    }

    protected synchronized void endMsg() {
        this.os.flush();
    }
}

