/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import org.apache.commons.text.StringEscapeUtils;
import org.parosproxy.paros.core.scanner.JsonParamParser;
import org.parosproxy.paros.core.scanner.RPCParameter;
import org.parosproxy.paros.core.scanner.VariantAbstractRPCQuery;

public class VariantJSONQuery
extends VariantAbstractRPCQuery {
    public static final String JSON_RPC_CONTENT_TYPE = "application/json";
    public static final int NAME_SEPARATOR = 58;
    public static final int VALUE_SEPARATOR = 44;
    public static final int BEGIN_ARRAY = 91;
    public static final int QUOTATION_MARK = 34;
    public static final int BEGIN_OBJECT = 123;
    public static final int END_OBJECT = 125;
    public static final int END_ARRAY = 93;
    public static final int BACKSLASH = 92;
    private boolean scanNullValues;
    private static final String SHORT_NAME = "json";

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    public VariantJSONQuery() {
        super(37);
    }

    public void setScanNullValues(boolean scan) {
        this.scanNullValues = scan;
    }

    public boolean isScanNullValues() {
        return this.scanNullValues;
    }

    @Override
    public boolean isValidContentType(String contentType) {
        return contentType.startsWith(JSON_RPC_CONTENT_TYPE);
    }

    @Override
    public void parseContent(String content) {
        JsonParamParser jpp = new JsonParamParser(content, this.scanNullValues);
        jpp.getParameters().forEach(p -> this.addParameter((RPCParameter)p));
    }

    @Override
    public String getEscapedValue(String value, boolean toQuote) {
        String result = StringEscapeUtils.escapeJava((String)value);
        return toQuote ? "\"" + result + "\"" : result;
    }

    @Override
    public String getUnescapedValue(String value) {
        return StringEscapeUtils.unescapeJava((String)value);
    }
}

