/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.SwingWorker;
import org.freeplane.plugin.ai.chat.AIModelCatalog;
import org.freeplane.plugin.ai.chat.AIModelDescriptor;
import org.freeplane.plugin.ai.chat.AIModelSelection;
import org.freeplane.plugin.ai.chat.AIProviderConfiguration;

class AIModelSelectionController {
    private final AIProviderConfiguration configuration;
    private final AIModelCatalog modelCatalog;
    private final JComboBox<AIModelDescriptor> modelSelectionComboBox;
    private boolean isModelSelectionUpdateInProgress;
    private boolean isModelListLoadInProgress;
    private Consumer<AIModelDescriptor> modelSelectionChangeListener;

    AIModelSelectionController(AIProviderConfiguration configuration, AIModelCatalog modelCatalog) {
        this.configuration = configuration;
        this.modelCatalog = modelCatalog;
        this.modelSelectionComboBox = new JComboBox();
        this.modelSelectionComboBox.setRenderer(new ModelSelectionRenderer());
        this.modelSelectionComboBox.addActionListener(event -> this.onModelSelectionChanged());
    }

    JComboBox<AIModelDescriptor> getModelSelectionComboBox() {
        return this.modelSelectionComboBox;
    }

    void setModelSelectionChangeListener(Consumer<AIModelDescriptor> modelSelectionChangeListener) {
        this.modelSelectionChangeListener = modelSelectionChangeListener;
    }

    void loadInitialModelSelectionList() {
        this.updateModelSelectionList(true);
    }

    private void onModelSelectionChanged() {
        if (this.isModelSelectionUpdateInProgress) {
            return;
        }
        Object selectedValue = this.modelSelectionComboBox.getSelectedItem();
        if (!(selectedValue instanceof AIModelDescriptor)) {
            this.configuration.setSelectedModelValue("");
            this.notifyModelSelectionChange(null);
            return;
        }
        AIModelDescriptor selectedModel = (AIModelDescriptor)selectedValue;
        this.configuration.setSelectedModelValue(selectedModel.getSelectionValue());
        this.notifyModelSelectionChange(selectedModel);
    }

    private void updateModelSelectionList(final boolean allowsRefresh) {
        if (this.isModelListLoadInProgress) {
            return;
        }
        this.isModelListLoadInProgress = true;
        this.modelSelectionComboBox.setEnabled(false);
        new SwingWorker<List<AIModelDescriptor>, Void>(){

            @Override
            protected List<AIModelDescriptor> doInBackground() {
                return AIModelSelectionController.this.modelCatalog.getAvailableModels(allowsRefresh);
            }

            @Override
            protected void done() {
                List<AIModelDescriptor> modelDescriptors;
                try {
                    modelDescriptors = (List<AIModelDescriptor>)this.get();
                }
                catch (Exception exception) {
                    modelDescriptors = Collections.emptyList();
                }
                AIModelSelectionController.this.applyModelSelectionList(modelDescriptors);
                AIModelSelectionController.this.isModelListLoadInProgress = false;
            }
        }.execute();
    }

    private void applyModelSelectionList(List<AIModelDescriptor> modelDescriptors) {
        this.isModelSelectionUpdateInProgress = true;
        try {
            DefaultComboBoxModel<AIModelDescriptor> comboBoxModel = new DefaultComboBoxModel<AIModelDescriptor>(modelDescriptors.toArray(new AIModelDescriptor[0]));
            this.modelSelectionComboBox.setModel(comboBoxModel);
            this.modelSelectionComboBox.setSelectedIndex(-1);
            this.applySelectionFromConfiguration(modelDescriptors);
            this.modelSelectionComboBox.setEnabled(this.hasAnyProviderEnabled());
        }
        finally {
            this.isModelSelectionUpdateInProgress = false;
        }
    }

    private void applySelectionFromConfiguration(List<AIModelDescriptor> modelDescriptors) {
        String storedSelectionValue = this.configuration.getStoredSelectedModelValue();
        String selectionValue = this.configuration.getSelectedModelValue();
        AIModelSelection selection = AIModelSelection.fromSelectionValue(selectionValue);
        if (selection == null) {
            return;
        }
        for (AIModelDescriptor modelDescriptor : modelDescriptors) {
            if (!selection.getProviderName().equalsIgnoreCase(modelDescriptor.getProviderName()) || !selection.getModelName().equals(modelDescriptor.getModelName())) continue;
            this.modelSelectionComboBox.setSelectedItem(modelDescriptor);
            if (storedSelectionValue == null || storedSelectionValue.isEmpty()) {
                this.configuration.setSelectedModelValue(modelDescriptor.getSelectionValue());
            }
            this.notifyModelSelectionChange(modelDescriptor);
            return;
        }
        this.configuration.setSelectedModelValue("");
        this.modelSelectionComboBox.setSelectedIndex(-1);
        this.notifyModelSelectionChange(null);
    }

    private boolean hasAnyProviderEnabled() {
        boolean hasOpenrouterKey = this.configuration.getOpenRouterKey() != null && !this.configuration.getOpenRouterKey().isEmpty();
        boolean hasGeminiKey = this.configuration.getGeminiKey() != null && !this.configuration.getGeminiKey().isEmpty();
        return hasOpenrouterKey || hasGeminiKey || this.configuration.isOllamaEnabled();
    }

    private void notifyModelSelectionChange(AIModelDescriptor modelDescriptor) {
        if (this.modelSelectionChangeListener != null) {
            this.modelSelectionChangeListener.accept(modelDescriptor);
        }
    }

    private static class ModelSelectionRenderer
    extends DefaultListCellRenderer {
        private ModelSelectionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof AIModelDescriptor) {
                this.setText(((AIModelDescriptor)value).getDisplayName());
            }
            return component;
        }
    }
}

