/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSEngineUserAgent;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.ListValue;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.URIValue;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import java.util.Locale;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

public class CursorManager
extends AbstractValueManager {
    protected static final StringMap<Value> values = new StringMap(18);

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 21;
    }

    @Override
    public String getPropertyName() {
        return "cursor";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.AUTO_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lunit, CSSEngine engine) throws DOMException {
        switch (lunit.getLexicalUnitType()) {
            case URI: {
                ListValue result = new ListValue();
                return this.addToURLList(lunit, engine, result);
            }
            case IDENT: {
                Value v = this.createIdentValue(lunit);
                if (v == null) {
                    throw this.createInvalidIdentifierDOMException(lunit.getStringValue());
                }
                ListValue result = new ListValue();
                result.append(v);
                LexicalUnit lu = lunit.getNextLexicalUnit();
                if (lu != null) {
                    throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
                }
                return result;
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: 
            case ATTR: {
                return this.createLexicalValue(lunit);
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lunit.getLexicalUnitType());
    }

    /*
     * Unable to fully structure code
     */
    private Value addToURLList(LexicalUnit lunit, CSSEngine engine, ListValue result) {
        block22: {
            lu = lunit;
            do lbl-1000:
            // 3 sources

            {
                type = lu.getLexicalUnitType();
                switch (1.$SwitchMap$io$sf$carte$doc$style$css$nsac$LexicalUnit$LexicalType[type.ordinal()]) {
                    case 1: {
                        v = this.createURIValue(lu, engine);
                        if (v == null) {
                            throw this.createMalformedLexicalUnitDOMException();
                        }
                        if (v.getPrimitiveType() == CSSValue.Type.LEXICAL) {
                            return this.createLexicalValue(lunit);
                        }
                        result.append(v);
                        break;
                    }
                    case 2: {
                        ident = this.createIdentValue(lu);
                        if (ident != null) {
                            result.add(ident);
                        } else {
                            ua = engine.getCSSEngineUserAgent();
                            if (ua != null) {
                                ua.displayMessage("Unknown identifier: " + lu.getStringValue());
                            }
                        }
                        lu = lu.getNextLexicalUnit();
                        if (lu != null) {
                            throw this.createMalformedLexicalUnitDOMException();
                        }
                        break block22;
                    }
                    case 9: {
                        result.add(new FloatValue(0, lu.getIntegerValue()));
                        break;
                    }
                    case 10: {
                        result.add(new FloatValue(0, lu.getFloatValue()));
                        break;
                    }
                    case 11: {
                        unit = lu.getCssUnit();
                        if (CSSUnit.isLengthUnitType((short)unit) || unit == 1) {
                            result.add(new FloatValue(unit, lu.getFloatValue()));
                            break;
                        }
                        throw this.createMalformedLexicalUnitDOMException();
                    }
                    case 12: {
                        calc = this.createCalc(lu);
                        syn = new SyntaxParser().parseSyntax("<number> | <length>");
                        if (calc.matches(syn) == CSSValueSyntax.Match.FALSE) {
                            throw this.createDOMException(calc);
                        }
                        result.append(calc);
                        break;
                    }
                    case 13: {
                        try {
                            v = this.createMathFunction(lu, "<number> | <length>");
                        }
                        catch (Exception e) {
                            ife = this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
                            ife.initCause(e);
                            throw ife;
                        }
                        result.append(v);
                        break;
                    }
                    case 7: 
                    case 8: {
                        return this.createLexicalValue(lunit);
                    }
                    case 14: {
                        if ((lu = lu.getNextLexicalUnit()) != null) ** GOTO lbl-1000
                        throw this.createMalformedLexicalUnitDOMException();
                    }
                    default: {
                        throw this.createInvalidLexicalUnitDOMException(type);
                    }
                }
            } while ((lu = lu.getNextLexicalUnit()) != null);
            throw this.createMalformedLexicalUnitDOMException();
        }
        return result;
    }

    private Value createIdentValue(LexicalUnit lunit) {
        String s = lunit.getStringValue().toLowerCase(Locale.ROOT).intern();
        return values.get(s);
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        if (value.getCssValueType() == CSSValue.CssType.LIST) {
            int len = value.getLength();
            ListValue result = new ListValue(' ');
            for (int i = 0; i < len; ++i) {
                Value v = value.item(i);
                if (v.getPrimitiveType() == CSSValue.Type.URI) {
                    if (sm.isAttrTainted(idx)) {
                        CSSEngineUserAgent ua = engine.getCSSEngineUserAgent();
                        if (ua != null) {
                            ua.warn("attr()-tainted value: " + value.getCssText());
                        }
                        return null;
                    }
                    String uri = v.getURIValue();
                    result.append(new URIValue(uri, uri));
                    continue;
                }
                result.append(v);
            }
            return result;
        }
        return super.computeValue(elt, pseudo, engine, idx, sm, value);
    }

    static {
        values.put("auto", ValueConstants.AUTO_VALUE);
        values.put("crosshair", ValueConstants.CROSSHAIR_VALUE);
        values.put("default", ValueConstants.DEFAULT_VALUE);
        values.put("e-resize", ValueConstants.E_RESIZE_VALUE);
        values.put("help", ValueConstants.HELP_VALUE);
        values.put("move", ValueConstants.MOVE_VALUE);
        values.put("n-resize", ValueConstants.N_RESIZE_VALUE);
        values.put("ne-resize", ValueConstants.NE_RESIZE_VALUE);
        values.put("nw-resize", ValueConstants.NW_RESIZE_VALUE);
        values.put("pointer", ValueConstants.POINTER_VALUE);
        values.put("s-resize", ValueConstants.S_RESIZE_VALUE);
        values.put("se-resize", ValueConstants.SE_RESIZE_VALUE);
        values.put("sw-resize", ValueConstants.SW_RESIZE_VALUE);
        values.put("text", ValueConstants.TEXT_VALUE);
        values.put("w-resize", ValueConstants.W_RESIZE_VALUE);
        values.put("wait", ValueConstants.WAIT_VALUE);
    }
}

