# frozen_string_literal: true

class UpdateVulnerabilityFlagsDescriptionLengthConstraint < Gitlab::Database::Migration[2.3]
  disable_ddl_transaction!
  milestone '18.5'

  def up
    execute "ALTER TABLE vulnerability_flags DROP CONSTRAINT IF EXISTS check_45e743349f"
    execute "ALTER TABLE vulnerability_flags ADD CONSTRAINT check_45e743349f CHECK (char_length(description) <= 10000)"
  end

  def down
    execute "ALTER TABLE vulnerability_flags DROP CONSTRAINT IF EXISTS check_45e743349f"
    execute "ALTER TABLE vulnerability_flags ADD CONSTRAINT check_45e743349f CHECK (char_length(description) <= 1024)"
  end
end
