/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import org.jsampler.view.std.PianoRoll;
import org.jsampler.view.std.PianoRollPainter;

public class BasicPianoRollPainter
implements PianoRollPainter {
    private PianoRoll pianoRoll;
    private Color borderColor = Color.BLACK;
    private Color keyColor = Color.WHITE;
    private Color disabledKeyColor = new Color(0xAAAAAA);
    private Color pressedKeyColor = Color.GREEN;
    private Color keySwitchColor = Color.PINK;
    private Color blackKeyColor = Color.BLACK;

    public BasicPianoRollPainter(PianoRoll pianoRoll) {
        if (pianoRoll == null) {
            throw new IllegalArgumentException("piano roll must be non-null");
        }
        this.pianoRoll = pianoRoll;
    }

    @Override
    public void paint(PianoRoll pianoRoll, Graphics2D graphics2D) {
        RoundRectangle2D.Double double_;
        int n;
        double d = this.getWhiteKeyWidth();
        double d2 = this.getWhiteKeyHeight();
        double d3 = d / 4.0;
        double d4 = d2 / 14.0;
        graphics2D.setPaint(this.keyColor);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        int n2 = 0;
        for (n = pianoRoll.getFirstKey(); n <= pianoRoll.getLastKey(); ++n) {
            if (!PianoRoll.isWhiteKey(n)) continue;
            Color color = this.getKeyColor(n);
            if (graphics2D.getPaint() != color) {
                graphics2D.setPaint(color);
            }
            double_ = new RoundRectangle2D.Double(d * (double)n2 + (double)n2, 0.0, d, d2, d3, d4);
            graphics2D.fill(double_);
            ++n2;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(new BasicStroke(1.5f));
        graphics2D.setPaint(this.borderColor);
        n2 = 0;
        for (n = pianoRoll.getFirstKey(); n <= pianoRoll.getLastKey(); ++n) {
            if (!PianoRoll.isWhiteKey(n)) continue;
            double_ = new RoundRectangle2D.Double(d * (double)n2 + (double)n2, 0.0, d, d2, d3, d4);
            graphics2D.draw(double_);
            ++n2;
        }
        graphics2D.setStroke(new BasicStroke(2.5f));
        double d5 = this.getBlackKeyWidth();
        double d6 = this.getBlackKeyHeight();
        n2 = 0;
        for (int i = pianoRoll.getFirstKey(); i <= pianoRoll.getLastKey(); ++i) {
            boolean bl;
            Color color;
            int n3;
            if (pianoRoll.getOctaveLabelsVisible() && i % 12 == 0) {
                n3 = i / 12 - 2;
                this.paintOctaveLabel(graphics2D, n3, n2);
            }
            if (!PianoRoll.isWhiteKey(i)) continue;
            n3 = (n2 + PianoRoll.getKeyOctaveIndex(pianoRoll.getFirstKey())) % 7;
            if (n3 == 2 || n3 == 6) {
                ++n2;
                continue;
            }
            Color color2 = color = i == pianoRoll.getLastKey() ? this.blackKeyColor : this.getKeyColor(i + 1);
            if (graphics2D.getPaint() != color) {
                graphics2D.setPaint(color);
            }
            double d7 = d5 * (double)(2 * (n2 + 1)) - d5 * 0.5 + (double)n2;
            double_ = new RoundRectangle2D.Double(d7, 0.0, d5, d6, d3, d4);
            boolean bl2 = bl = i == pianoRoll.getLastKey() ? false : pianoRoll.getKey(i + 1).isPressed();
            if (!bl) {
                graphics2D.fill(double_);
            }
            RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double(d7, 0.0, d5, d4, d3, d4 / 1.8);
            graphics2D.fill(double_2);
            graphics2D.setPaint(this.borderColor);
            graphics2D.draw(double_);
            if (bl) {
                GradientPaint gradientPaint = new GradientPaint((float)(d7 + d5 / 2.0), (float)(d6 / 4.0), Color.BLACK, (float)(d7 + d5 / 2.0), (float)d6, new Color(363010));
                graphics2D.setPaint(gradientPaint);
                graphics2D.fill(double_);
            }
            ++n2;
        }
    }

    protected void paintOctaveLabel(Graphics2D graphics2D, int n, int n2) {
        double d = this.pianoRoll.getSize().getHeight();
        double d2 = this.getWhiteKeyWidth();
        graphics2D.setPaint(Color.BLACK);
        int n3 = (int)(d2 / (1.5 + d2 / 50.0));
        if (n3 < 8) {
            n3 = 8;
        }
        graphics2D.setFont(graphics2D.getFont().deriveFont(1, n3));
        float f = (float)(d2 * (double)n2 + (double)n2);
        float f2 = (float)(d - 1.0);
        String string = String.valueOf(n);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n4 = fontMetrics.stringWidth(string);
        f = (double)n4 < d2 ? (float)((double)f + (d2 - (double)n4) / 2.0) : (f += 2.0f);
        f2 = (float)((double)f2 - d / 12.0);
        graphics2D.drawString(string, f, f2);
    }

    private Color getKeyColor(int n) {
        PianoRoll.Key key = this.pianoRoll.getKey(n);
        if (PianoRoll.isWhiteKey(n)) {
            if (key.isPressed()) {
                return this.pressedKeyColor;
            }
            if (key.isKeyswitch()) {
                return this.keySwitchColor;
            }
            if (key.isDisabled()) {
                return this.disabledKeyColor;
            }
            return this.keyColor;
        }
        if (key.isPressed()) {
            return Color.GREEN;
        }
        return this.blackKeyColor;
    }

    private double getWhiteKeyWidth() {
        double d = this.pianoRoll.getSize().getWidth();
        return (d - (double)this.pianoRoll.getWhiteKeyCount()) / (double)this.pianoRoll.getWhiteKeyCount();
    }

    private double getWhiteKeyHeight() {
        return this.pianoRoll.getSize().getHeight() - 3.0;
    }

    private double getBlackKeyWidth() {
        return this.getWhiteKeyWidth() / 2.0;
    }

    private double getBlackKeyHeight() {
        return this.getWhiteKeyHeight() / 1.5;
    }

    @Override
    public int getKeyByPoint(Point point) {
        double d = this.getWhiteKeyWidth() + 1.0;
        if (d == 0.0) {
            return -1;
        }
        int n = (int)(point.getX() / d);
        double d2 = (double)n * d;
        int n2 = this.pianoRoll.getWhiteKeyByNumber(n);
        if (n2 == -1) {
            return -1;
        }
        double d3 = this.getBlackKeyHeight();
        double d4 = d / 4.0;
        if (point.getY() > d3) {
            return n2;
        }
        if (n2 != this.pianoRoll.getFirstKey() && !PianoRoll.isWhiteKey(n2 - 1) && point.getX() <= d2 + d4) {
            return n2 - 1;
        }
        if (n2 != this.pianoRoll.getLastKey() && !PianoRoll.isWhiteKey(n2 + 1) && point.getX() >= d2 + 3.0 * d4 - 3.0) {
            return n2 + 1;
        }
        return n2;
    }

    @Override
    public Rectangle getKeyRectangle(int n) {
        Rectangle rectangle = new Rectangle();
        if (!this.pianoRoll.hasKey(n)) {
            return rectangle;
        }
        int n2 = PianoRoll.getWhiteKeyCount(this.pianoRoll.getFirstKey(), n) - 1;
        if (PianoRoll.isWhiteKey(n)) {
            double d = this.getWhiteKeyWidth();
            double d2 = this.getWhiteKeyHeight();
            double d3 = d * (double)n2 + (double)n2;
            rectangle.setRect(d3, 0.0, d, d2);
        } else {
            double d = this.getBlackKeyWidth();
            double d4 = this.getBlackKeyHeight();
            int n3 = n2;
            double d5 = d * (double)(2 * (n3 + 1)) - d * 0.5 + (double)n3;
            rectangle.setRect(d5, 0.0, d, d4);
        }
        return rectangle;
    }

    @Override
    public int getVelocity(Point point, int n) {
        boolean bl = PianoRoll.isWhiteKey(n);
        double d = bl ? this.getWhiteKeyHeight() : this.getBlackKeyHeight();
        int n2 = (int)(point.getY() / d * 127.0 + 1.0);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 127) {
            n2 = 127;
        }
        return n2;
    }
}

