/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.persister;

import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.ReadShareGroupStateSummaryRequestData;
import org.apache.kafka.server.share.persister.GroupTopicPartitionData;
import org.apache.kafka.server.share.persister.PartitionFactory;
import org.apache.kafka.server.share.persister.PartitionIdLeaderEpochData;
import org.apache.kafka.server.share.persister.PersisterParameters;
import org.apache.kafka.server.share.persister.TopicData;

public class ReadShareGroupStateSummaryParameters
implements PersisterParameters {
    private final GroupTopicPartitionData<PartitionIdLeaderEpochData> groupTopicPartitionData;

    private ReadShareGroupStateSummaryParameters(GroupTopicPartitionData<PartitionIdLeaderEpochData> groupTopicPartitionData) {
        this.groupTopicPartitionData = groupTopicPartitionData;
    }

    public GroupTopicPartitionData<PartitionIdLeaderEpochData> groupTopicPartitionData() {
        return this.groupTopicPartitionData;
    }

    public static ReadShareGroupStateSummaryParameters from(ReadShareGroupStateSummaryRequestData data) {
        return new Builder().setGroupTopicPartitionData(new GroupTopicPartitionData<PartitionIdLeaderEpochData>(data.groupId(), data.topics().stream().map(topicData -> new TopicData(topicData.topicId(), topicData.partitions().stream().map(partitionData -> PartitionFactory.newPartitionIdLeaderEpochData(partitionData.partition(), partitionData.leaderEpoch())).collect(Collectors.toList()))).collect(Collectors.toList()))).build();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadShareGroupStateSummaryParameters that = (ReadShareGroupStateSummaryParameters)o;
        return Objects.equals(this.groupTopicPartitionData, that.groupTopicPartitionData);
    }

    public int hashCode() {
        return Objects.hashCode(this.groupTopicPartitionData);
    }

    public static class Builder {
        private GroupTopicPartitionData<PartitionIdLeaderEpochData> groupTopicPartitionData;

        public Builder setGroupTopicPartitionData(GroupTopicPartitionData<PartitionIdLeaderEpochData> groupTopicPartitionData) {
            this.groupTopicPartitionData = groupTopicPartitionData;
            return this;
        }

        public ReadShareGroupStateSummaryParameters build() {
            return new ReadShareGroupStateSummaryParameters(this.groupTopicPartitionData);
        }
    }
}

