/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.policy.impl;

import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientregistration.policy.AbstractClientRegistrationPolicyFactory;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy;
import org.keycloak.services.clientregistration.policy.impl.RegistrationWebOriginsPolicy;

public class RegistrationWebOriginsPolicyFactory
extends AbstractClientRegistrationPolicyFactory {
    public static final String PROVIDER_ID = "registration-web-origins";
    public static final String WEB_ORIGINS = "web-origins";
    private static final ProviderConfigProperty WEB_ORIGINS_PROPERTY = new ProviderConfigProperty("web-origins", "registration-web-origins.label", "registration-web-origins.tooltip", "MultivaluedString", null);

    public ClientRegistrationPolicy create(KeycloakSession session, ComponentModel model) {
        return new RegistrationWebOriginsPolicy(session, model);
    }

    public String getHelpText() {
        return "Allowed web origins for client registration requests";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return List.of(WEB_ORIGINS_PROPERTY);
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

