/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.DocIdSetBuilder;

public class FacetsCollector
extends SimpleCollector {
    private LeafReaderContext context;
    private Scorable scorer;
    private int totalHits;
    private float[] scores;
    private final boolean keepScores;
    private final List<MatchingDocs> matchingDocs = new ArrayList<MatchingDocs>();
    private DocIdSetBuilder docsBuilder;

    public FacetsCollector() {
        this(false);
    }

    public FacetsCollector(boolean keepScores) {
        this.keepScores = keepScores;
    }

    public final boolean getKeepScores() {
        return this.keepScores;
    }

    public List<MatchingDocs> getMatchingDocs() {
        return this.matchingDocs;
    }

    public void collect(int doc) throws IOException {
        this.docsBuilder.grow(1).add(doc);
        if (this.keepScores) {
            if (doc >= this.scores.length) {
                float[] newScores = new float[ArrayUtil.oversize((int)(doc + 1), (int)4)];
                System.arraycopy(this.scores, 0, newScores, 0, this.scores.length);
                this.scores = newScores;
            }
            this.scores[doc] = this.scorer.score();
        }
        ++this.totalHits;
    }

    public ScoreMode scoreMode() {
        return this.keepScores ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public final void setScorer(Scorable scorer) throws IOException {
        this.scorer = scorer;
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        assert (this.docsBuilder == null);
        this.docsBuilder = new DocIdSetBuilder(context.reader().maxDoc());
        this.totalHits = 0;
        if (this.keepScores) {
            this.scores = new float[64];
        }
        this.context = context;
    }

    public void finish() throws IOException {
        DocIdSet bits;
        if (this.docsBuilder != null) {
            bits = this.docsBuilder.build();
            this.docsBuilder = null;
        } else {
            bits = DocIdSet.EMPTY;
        }
        this.matchingDocs.add(new MatchingDocs(this.context, bits, this.totalHits, this.scores));
        this.scores = null;
        this.context = null;
    }

    public record MatchingDocs(LeafReaderContext context, DocIdSet bits, int totalHits, float[] scores) {
    }
}

