/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.compiler.TruffleCompilationTask;
import com.oracle.truffle.compiler.TruffleCompilerListener;
import com.oracle.truffle.runtime.AbstractCompilationTask;
import com.oracle.truffle.runtime.EngineData;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedDirectCallNode;
import com.oracle.truffle.runtime.TruffleInlining;
import java.util.Map;

public interface OptimizedTruffleRuntimeListener {
    default public void onCompilationSplit(OptimizedDirectCallNode callNode) {
    }

    default public void onCompilationSplitFailed(OptimizedDirectCallNode callNode, CharSequence reason) {
    }

    default public void onCompilationQueued(OptimizedCallTarget target, int tier) {
    }

    default public void onCompilationDequeued(OptimizedCallTarget target, Object source, CharSequence reason, int tier) {
    }

    @Deprecated(since="21.0")
    default public void onCompilationStarted(OptimizedCallTarget target, int tier) {
    }

    @Deprecated(since="23.0")
    default public void onCompilationStarted(OptimizedCallTarget target, TruffleCompilationTask task) {
        this.onCompilationStarted(target, task.tier());
    }

    default public void onCompilationStarted(OptimizedCallTarget target, AbstractCompilationTask task) {
        this.onCompilationStarted(target, (TruffleCompilationTask)task);
    }

    @Deprecated
    default public void onCompilationTruffleTierFinished(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph) {
    }

    default public void onCompilationTruffleTierFinished(OptimizedCallTarget target, AbstractCompilationTask task, TruffleCompilerListener.GraphInfo graph) {
        this.onCompilationTruffleTierFinished(target, task.getInlining(), graph);
    }

    default public void onCompilationGraalTierFinished(OptimizedCallTarget target, TruffleCompilerListener.GraphInfo graph) {
    }

    @Deprecated(since="21.0")
    default public void onCompilationSuccess(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result) {
        this.onCompilationSuccess(target, inliningDecision, graph, result, 0);
    }

    @Deprecated(since="23.0")
    default public void onCompilationSuccess(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result, int tier) {
    }

    default public void onCompilationSuccess(OptimizedCallTarget target, AbstractCompilationTask task, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result) {
        this.onCompilationSuccess(target, task.getInlining(), graph, result);
    }

    @Deprecated(since="21.0")
    default public void onCompilationFailed(OptimizedCallTarget target, String reason, boolean bailout, boolean permanentBailout) {
        this.onCompilationFailed(target, reason, bailout, permanentBailout, 0);
    }

    default public void onCompilationFailed(OptimizedCallTarget target, String reason, boolean bailout, boolean permanentBailout, int tier) {
    }

    default public void onCompilationInvalidated(OptimizedCallTarget target, Object source, CharSequence reason) {
    }

    default public void onCompilationDeoptimized(OptimizedCallTarget target, Frame frame) {
    }

    default public void onShutdown() {
    }

    default public void onEngineClosed(EngineData runtimeData) {
    }

    public static void addASTSizeProperty(OptimizedCallTarget target, Map<String, Object> properties) {
        int nodeCount = target.getNonTrivialNodeCount();
        properties.put("AST", String.format("%4d", nodeCount));
    }

    public static boolean isPermanentFailure(boolean bailout, boolean permanentBailout) {
        return !bailout || permanentBailout;
    }
}

