/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetExternalDatabaseConnectorRequest
extends BmcRequest<Void> {
    private String externalDatabaseConnectorId;
    private String opcRequestId;

    public String getExternalDatabaseConnectorId() {
        return this.externalDatabaseConnectorId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().externalDatabaseConnectorId(this.externalDatabaseConnectorId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",externalDatabaseConnectorId=").append(String.valueOf(this.externalDatabaseConnectorId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetExternalDatabaseConnectorRequest)) {
            return false;
        }
        GetExternalDatabaseConnectorRequest other = (GetExternalDatabaseConnectorRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.externalDatabaseConnectorId, other.externalDatabaseConnectorId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.externalDatabaseConnectorId == null ? 43 : this.externalDatabaseConnectorId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExternalDatabaseConnectorRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String externalDatabaseConnectorId = null;
        private String opcRequestId = null;

        public Builder externalDatabaseConnectorId(String externalDatabaseConnectorId) {
            this.externalDatabaseConnectorId = externalDatabaseConnectorId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExternalDatabaseConnectorRequest o) {
            this.externalDatabaseConnectorId(o.getExternalDatabaseConnectorId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExternalDatabaseConnectorRequest build() {
            GetExternalDatabaseConnectorRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetExternalDatabaseConnectorRequest buildWithoutInvocationCallback() {
            GetExternalDatabaseConnectorRequest request = new GetExternalDatabaseConnectorRequest();
            request.externalDatabaseConnectorId = this.externalDatabaseConnectorId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

