/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.web.servlet.ModelAndView;

public class ViewResultMatchers {
    protected ViewResultMatchers() {
    }

    public ResultMatcher name(Matcher<? super String> matcher) {
        return result -> {
            ModelAndView mav = result.getModelAndView();
            if (mav == null) {
                AssertionErrors.fail("No ModelAndView found");
            }
            MatcherAssert.assertThat((String)"View name", (Object)mav.getViewName(), (Matcher)matcher);
        };
    }

    public ResultMatcher name(String expectedViewName) {
        return result -> {
            ModelAndView mav = result.getModelAndView();
            if (mav == null) {
                AssertionErrors.fail("No ModelAndView found");
            }
            AssertionErrors.assertEquals("View name", expectedViewName, mav.getViewName());
        };
    }
}

