/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.diff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.xml.spi.dom.NodeListImpl;
import org.netbeans.modules.xml.xam.dom.ElementIdentity;
import org.netbeans.modules.xml.xdm.diff.Add;
import org.netbeans.modules.xml.xdm.diff.Change;
import org.netbeans.modules.xml.xdm.diff.DefaultElementIdentity;
import org.netbeans.modules.xml.xdm.diff.Delete;
import org.netbeans.modules.xml.xdm.diff.Difference;
import org.netbeans.modules.xml.xdm.diff.NodeInfo;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Text;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.visitor.PathFromRootVisitor;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class DiffFinder {
    private ElementIdentity eID;
    private ChildInfo cInfo1;
    private ChildInfo cInfo2;
    private Document oldDoc;
    private Document newDoc;

    protected DiffFinder() {
    }

    public DiffFinder(ElementIdentity eID) {
        this.eID = eID;
    }

    public List<Difference> findDiff(Document d1, Document d2) {
        this.oldDoc = d1;
        this.newDoc = d2;
        List<Difference> deList = new ArrayList<Difference>();
        List<Change.Type> changes = this.checkChange(d1, d2, 0, 0);
        if (changes.size() > 0) {
            this.markChange(new ArrayList<Node>(), d1, d2, 0, 0, changes, new ArrayList<Node>(), deList);
        }
        ArrayList<Node> ancestors1 = new ArrayList<Node>();
        ArrayList<Node> ancestors2 = new ArrayList<Node>();
        ancestors1.add(this.oldDoc);
        ancestors2.add(this.newDoc);
        this.compareChildren(ancestors1, ancestors2, deList);
        if (deList.size() > 0) {
            deList = this.findOptimized(deList);
        }
        return deList;
    }

    protected void compareChildren(List<Node> ancestors1, List<Node> ancestors2, List<Difference> deList) {
        Node parent1 = ancestors1.get(0);
        Node parent2 = ancestors2.get(0);
        NodeList p1ChildNodes = parent1.getChildNodes();
        NodeList p2ChildNodes = parent2.getChildNodes();
        if (p1ChildNodes == NodeListImpl.EMPTY && p2ChildNodes == NodeListImpl.EMPTY) {
            return;
        }
        this.cInfo1 = new ChildInfo(parent1);
        this.cInfo2 = new ChildInfo(parent2);
        List<Node> p2ChildList = this.getChildList(parent2);
        ArrayList<int[]> pairList = new ArrayList<int[]>();
        ArrayList<Node> foundList = new ArrayList<Node>();
        if (p1ChildNodes != null) {
            Node p2;
            int[] pair;
            Node child;
            int i;
            int length = p1ChildNodes.getLength();
            for (i = 0; i < length; ++i) {
                child = (Node)p1ChildNodes.item(i);
                Node foundNode = null;
                if (child instanceof org.netbeans.modules.xml.xdm.nodes.Element) {
                    foundNode = this.findMatch((org.netbeans.modules.xml.xdm.nodes.Element)child, p2ChildList, parent1);
                } else if (child instanceof Text) {
                    foundNode = this.findMatch((Text)child, p2ChildList);
                }
                if (foundNode == null) {
                    List<Node> path1 = this.copy(ancestors1);
                    List<Node> path2 = this.copy(ancestors2);
                    this.markDelete(path1, child, i, this.cInfo1.getSiblingBefore(child), path2, deList);
                    continue;
                }
                this.cInfo2.addMatchNode(foundNode, child);
                foundList.add(foundNode);
                p2ChildList.remove(foundNode);
                int[] pair2 = new int[]{i, this.cInfo2.getIndex(foundNode)};
                pairList.add(pair2);
            }
            for (i = 0; i < p2ChildList.size(); ++i) {
                child = p2ChildList.get(i);
                SiblingInfo sInfo = new SiblingInfo(child, p2ChildNodes, foundList);
                Node originalSiblingBefore = null;
                if (sInfo.getNode() != null) {
                    originalSiblingBefore = this.cInfo2.getMatchNode(sInfo.getNode());
                }
                int absolutePos = this.cInfo2.getIndex(child);
                this.markAdd(this.copy(ancestors1), child, absolutePos, sInfo.getPosition(), originalSiblingBefore, this.copy(ancestors2), deList);
            }
            pairList.sort(new PairComparator());
            for (i = 0; i < pairList.size(); ++i) {
                int tp2;
                int tp1;
                pair = (int[])pairList.get(i);
                int px1 = pair[0];
                int px2 = pair[1];
                Node p1 = (Node)parent1.getChildNodes().item(px1);
                List<Change.Type> changes = this.checkChange(p1, p2 = (Node)parent2.getChildNodes().item(px2), tp1 = this.cInfo1.getPosition(p1), tp2 = this.cInfo2.getPosition(p2));
                if (changes.size() <= 0) continue;
                this.markChange(this.copy(ancestors1), p1, p2, px1, px2, changes, this.copy(ancestors2), deList);
            }
            this.cInfo1 = null;
            this.cInfo2 = null;
            for (i = 0; i < pairList.size(); ++i) {
                pair = (int[])pairList.get(i);
                int px1 = pair[0];
                int px2 = pair[1];
                Node p1 = (Node)parent1.getChildNodes().item(px1);
                p2 = (Node)parent2.getChildNodes().item(px2);
                if (!(p1 instanceof org.netbeans.modules.xml.xdm.nodes.Element)) continue;
                ancestors1.add(0, p1);
                ancestors2.add(0, p2);
                this.compareChildren(ancestors1, ancestors2, deList);
                ancestors1.remove(0);
                ancestors2.remove(0);
            }
        }
    }

    private List<Node> copy(List<Node> l) {
        return new ArrayList<Node>(l);
    }

    public static NodeInfo.NodeType getNodeType(Node child) throws DOMException {
        NodeInfo.NodeType nodeType = NodeInfo.NodeType.ELEMENT;
        if (child instanceof Text) {
            nodeType = DiffFinder.isWhiteSpaceOnly((Text)child) ? NodeInfo.NodeType.WHITE_SPACE : NodeInfo.NodeType.TEXT;
        } else if (child instanceof Attribute) {
            nodeType = NodeInfo.NodeType.ATTRIBUTE;
        }
        return nodeType;
    }

    protected List<Change.Type> checkChange(Node n1, Node n2, int p1, int p2) {
        List<Change.Type> changes = this.checkChange(n1, n2);
        if (p1 != p2) {
            changes.add(Change.Type.POSITION);
        }
        return changes;
    }

    protected List<Change.Type> checkChange(Node p1, Node p2) {
        ArrayList<Change.Type> changes = new ArrayList<Change.Type>();
        if (!this.checkTokensEqual(p1, p2)) {
            changes.add(Change.Type.TOKEN);
        }
        if (p1 instanceof org.netbeans.modules.xml.xdm.nodes.Element && p2 instanceof org.netbeans.modules.xml.xdm.nodes.Element) {
            if (!this.checkAttributesEqual((org.netbeans.modules.xml.xdm.nodes.Element)p1, (org.netbeans.modules.xml.xdm.nodes.Element)p2)) {
                changes.add(Change.Type.ATTRIBUTE);
            }
        } else if (!p1.getClass().isAssignableFrom(p2.getClass()) || !p2.getClass().isAssignableFrom(p1.getClass())) {
            changes.add(Change.Type.UNKNOWN);
        }
        return changes;
    }

    protected boolean checkTokensEqual(Node p1, Node p2) {
        if (p1 instanceof NodeImpl && p2 instanceof NodeImpl) {
            List<Token> t1List = ((NodeImpl)p1).getTokens();
            List<Token> t2List = ((NodeImpl)p2).getTokens();
            return this.compareTokenEquals(t1List, t2List);
        }
        return false;
    }

    protected boolean checkAttributesEqual(org.netbeans.modules.xml.xdm.nodes.Element p1, org.netbeans.modules.xml.xdm.nodes.Element p2) {
        if (p1 == null || p2 == null) {
            return false;
        }
        NamedNodeMap nm1 = p1.getAttributes();
        NamedNodeMap nm2 = p2.getAttributes();
        if (nm1.getLength() != nm2.getLength()) {
            return false;
        }
        for (int i = 0; i < nm1.getLength(); ++i) {
            List<Token> t2List;
            Node attr2 = (Node)nm2.getNamedItem(nm1.item(i).getNodeName());
            if (attr2 == null) {
                return false;
            }
            if (nm2.item(i) != attr2) {
                return false;
            }
            List<Token> t1List = ((NodeImpl)nm1.item(i)).getTokens();
            boolean status = this.compareTokenEquals(t1List, t2List = ((NodeImpl)attr2).getTokens());
            if (status) continue;
            return false;
        }
        return true;
    }

    protected boolean compareTokenEquals(List<Token> t1List, List<Token> t2List) {
        if (t1List.size() != t2List.size()) {
            return false;
        }
        for (int i = 0; i < t1List.size(); ++i) {
            Token t1 = t1List.get(i);
            Token t2 = t2List.get(i);
            if (t1.getValue().intern() == t2.getValue().intern()) continue;
            return false;
        }
        return true;
    }

    protected Node findMatch(org.netbeans.modules.xml.xdm.nodes.Element child, List<Node> childNodes, org.w3c.dom.Node parent1) {
        for (Node otherChild : childNodes) {
            if (!(otherChild instanceof org.netbeans.modules.xml.xdm.nodes.Element) || !((DefaultElementIdentity)this.eID).compareElement(child, (org.netbeans.modules.xml.xdm.nodes.Element)otherChild, parent1, this.oldDoc, this.newDoc)) continue;
            return otherChild;
        }
        return null;
    }

    protected Node findMatch(Text child, List<Node> childNodes) {
        for (Node otherChild : childNodes) {
            if (!(otherChild instanceof Text) || !this.compareText(child, (Text)otherChild)) continue;
            return otherChild;
        }
        return null;
    }

    protected Difference createAddEvent(List<Node> ancestors1, Node n, int absolutePos, List<Node> ancestors2) {
        assert (n != null) : "add node null";
        return new Add(DiffFinder.getNodeType(n), ancestors1, ancestors2, n, absolutePos);
    }

    protected Difference createDeleteEvent(List<Node> ancestors1, Node n, int pos, List<Node> ancestors2) {
        assert (n != null) : "delete node null";
        return new Delete(DiffFinder.getNodeType(n), ancestors1, ancestors2, n, pos);
    }

    protected Difference createChangeEvent(List<Node> ancestors1, Node n1, Node n2, int n1Pos, int n2Pos, List<Change.Type> changes, List<Node> ancestors2) {
        assert (n1 != null && n2 != null) : "change nodes null";
        if (n1 instanceof org.netbeans.modules.xml.xdm.nodes.Element) assert (n1.getLocalName().equals(n2.getLocalName()));
        Change de = new Change(DiffFinder.getNodeType(n1), ancestors1, ancestors2, n1, n2, n1Pos, n2Pos, changes);
        if (de.getNewNodeInfo().getNewAncestors().size() > 0) assert (de.getNewNodeInfo().getNode().getId() != de.getNewNodeInfo().getNewAncestors().get(0).getId());
        return de;
    }

    protected void markAdd(List<Node> ancestors1, Node n, int absolutePos, int posFromSibling, Node siblingBefore, List<Node> ancestors2, List<Difference> deList) {
        deList.add(this.createAddEvent(ancestors1, n, absolutePos, ancestors2));
    }

    protected void markDelete(List<Node> ancestors1, Node n, int pos, Node siblingBefore, List<Node> ancestors2, List<Difference> deList) {
        deList.add(this.createDeleteEvent(ancestors1, n, pos, ancestors2));
    }

    protected void markChange(List<Node> ancestors1, Node n1, Node n2, int n1Pos, int n2Pos, List<Change.Type> changes, List<Node> ancestors2, List<Difference> deList) {
        deList.add(this.createChangeEvent(ancestors1, n1, n2, n1Pos, n2Pos, changes, ancestors2));
    }

    public static List<Difference> filterWhitespace(List<Difference> deList) {
        ArrayList<Difference> returnList = new ArrayList<Difference>();
        for (Difference de : deList) {
            NodeInfo.NodeType nodeType = de.getNodeType();
            if (de.getNodeType() == NodeInfo.NodeType.WHITE_SPACE) continue;
            returnList.add(de);
        }
        return returnList;
    }

    public static List<Node> getPathToRoot(Node node) {
        assert (node.getOwnerDocument() != null);
        List<Node> pathToRoot = new PathFromRootVisitor().findPath(node.getOwnerDocument(), (org.w3c.dom.Node)node);
        return pathToRoot;
    }

    public List<Difference> findOptimized(List<Difference> deList) {
        if (deList == null || deList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Difference> optimizedList = new ArrayList<Difference>();
        HashMap<Node, ArrayList<Difference>> deMap = new HashMap<Node, ArrayList<Difference>>();
        ArrayList<Node> parentList = new ArrayList<Node>();
        for (Difference de : deList) {
            Node parent = de.getOldNodeInfo().getParent();
            ArrayList<Difference> childDeList = (ArrayList<Difference>)deMap.get(parent);
            if (childDeList == null) {
                parentList.add(parent);
                childDeList = new ArrayList<Difference>();
                deMap.put(parent, childDeList);
            }
            childDeList.add(de);
        }
        for (Node parent : parentList) {
            Difference de;
            int i;
            List childDeList = (List)deMap.get(parent);
            childDeList.sort(new PairComparator2());
            HashMap<Difference, Integer> oldPosMap = new HashMap<Difference, Integer>();
            for (i = 0; i < childDeList.size(); ++i) {
                de = (Difference)childDeList.get(i);
                this.modifyPositionFromIndex(i + 1, childDeList, de, oldPosMap);
            }
            for (i = 0; i < childDeList.size(); ++i) {
                de = (Difference)childDeList.get(i);
                Integer oldPos = oldPosMap.get(de);
                int px1 = oldPos != null ? oldPos.intValue() : de.getOldNodeInfo().getPosition();
                int px2 = de.getNewNodeInfo().getPosition();
                if (de instanceof Change && ((Change)de).isPositionChanged()) {
                    if (px1 == px2 && px1 != -1) {
                        ((Change)de).setPositionChanged(false);
                    }
                    if (!((Change)de).isValid()) continue;
                    optimizedList.add(de);
                    continue;
                }
                optimizedList.add(de);
            }
        }
        return optimizedList;
    }

    protected void modifyPositionFromIndex(int index, List<Difference> childDeList, Difference de, HashMap<Difference, Integer> oldPosMap) {
        Integer oldx = oldPosMap.get(de);
        int x = oldx != null ? oldx.intValue() : de.getOldNodeInfo().getPosition();
        int y = de.getNewNodeInfo().getPosition();
        for (int i = index; i < childDeList.size(); ++i) {
            Difference cde = childDeList.get(i);
            Integer oldp1 = oldPosMap.get(cde);
            int p1 = oldp1 != null ? oldp1.intValue() : cde.getOldNodeInfo().getPosition();
            int p2 = cde.getNewNodeInfo().getPosition();
            if (de instanceof Add && x == -1 && y >= 0 && y <= p1) {
                oldPosMap.put(cde, p1 + 1);
                continue;
            }
            if (de instanceof Delete && x >= 0 && y == -1 && x <= p1) {
                oldPosMap.put(cde, p1 - 1);
                continue;
            }
            if (!(de instanceof Change) || x == y) continue;
            if (x > p1 && y <= p1) {
                oldPosMap.put(cde, p1 + 1);
                continue;
            }
            if (y <= p1 || x > p1) continue;
            oldPosMap.put(cde, p1 - 1);
        }
    }

    public static boolean isPossibleWhiteSpace(String text) {
        return text.length() > 0 && Character.isWhitespace(text.charAt(0)) && Character.isWhitespace(text.charAt(text.length() - 1));
    }

    public static boolean isWhiteSpaceOnly(Text txt) {
        String tn = "";
        tn = txt.getTokens().size() == 1 ? txt.getTokens().get(0).getValue() : txt.getNodeValue();
        return DiffFinder.isPossibleWhiteSpace(tn) && tn.trim().length() == 0;
    }

    protected boolean compareText(Text n1, Text n2) {
        if (DiffFinder.isWhiteSpaceOnly(n1) && DiffFinder.isWhiteSpaceOnly(n2)) {
            return this.compareWhiteSpaces(n1, n2);
        }
        return this.compareTextByValue(n1, n2);
    }

    protected boolean compareWhiteSpaces(Text n1, Text n2) {
        Node nodeBefore1 = this.cInfo1.getSiblingBefore(n1);
        Node nodeBefore2 = this.cInfo2.getSiblingBefore(n2);
        boolean siblingCompare = false;
        if (nodeBefore1 == null && nodeBefore2 == null) {
            siblingCompare = true;
        } else if (nodeBefore1 instanceof org.netbeans.modules.xml.xdm.nodes.Element && nodeBefore2 instanceof org.netbeans.modules.xml.xdm.nodes.Element) {
            if (this.cInfo2.getMatchNode(nodeBefore2) == nodeBefore1 || this.eID.compareElement((Element)((org.netbeans.modules.xml.xdm.nodes.Element)nodeBefore1), (Element)((org.netbeans.modules.xml.xdm.nodes.Element)nodeBefore2), (org.w3c.dom.Document)this.oldDoc, (org.w3c.dom.Document)this.newDoc)) {
                siblingCompare = true;
            }
        } else if (nodeBefore1 instanceof Text && nodeBefore2 instanceof Text && nodeBefore1.getNodeValue().intern() == nodeBefore2.getNodeValue().intern()) {
            siblingCompare = true;
        }
        if (siblingCompare) {
            return this.compareTextByValue(n1, n2);
        }
        return false;
    }

    protected boolean compareTextByValue(Text n1, Text n2) {
        return n1.getNodeValue().intern() == n2.getNodeValue().intern();
    }

    protected List<Node> getChildList(Node parent) {
        NodeList childs = parent.getChildNodes();
        ArrayList<Node> childList = new ArrayList<Node>(childs.getLength());
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = (Node)childs.item(i);
            childList.add(child);
        }
        return childList;
    }

    static class ChildInfo {
        HashMap<Node, int[]> posMap;
        HashMap<Node, Node> siblingBeforeMap;
        HashMap<Node, Node> compareNodeMap;

        public ChildInfo(Node parent) {
            NodeList childNodes = parent.getChildNodes();
            this.compareNodeMap = new HashMap();
            this.siblingBeforeMap = new HashMap(childNodes.getLength());
            this.posMap = new HashMap(childNodes.getLength());
            HashMap<Class, Integer> posCounter = new HashMap<Class, Integer>(7);
            Node siblingBefore = null;
            int i = 0;
            while (i < childNodes.getLength()) {
                Node child = (Node)childNodes.item(i);
                this.siblingBeforeMap.put(child, siblingBefore);
                siblingBefore = child;
                Class bucket = this.getBucket(child);
                Integer count = (Integer)posCounter.get(bucket);
                if (count == null) {
                    posCounter.put(bucket, -1);
                }
                int newCount = (Integer)posCounter.get(bucket) + 1;
                posCounter.put(bucket, newCount);
                int[] pos = new int[]{i++, newCount};
                this.posMap.put(child, pos);
            }
        }

        private Class getBucket(Node child) {
            return child instanceof Text ? Text.class : child.getClass();
        }

        public Node getSiblingBefore(Node n) {
            return this.siblingBeforeMap.get(n);
        }

        public int getIndex(Node n) {
            return this.posMap.get(n)[0];
        }

        public int getPosition(Node n) {
            return this.posMap.get(n)[1];
        }

        public Node getMatchNode(Node n) {
            return this.compareNodeMap.get(n);
        }

        public void addMatchNode(Node n1, Node n2) {
            this.compareNodeMap.put(n1, n2);
        }

        public void clear() {
            this.compareNodeMap.clear();
            this.siblingBeforeMap.clear();
            this.posMap.clear();
        }
    }

    static class SiblingInfo {
        Node siblingBefore;
        int relativePos = 0;

        public SiblingInfo(Node child, NodeList p2ChildNodes, List<Node> foundList) {
            for (int j = 0; j < p2ChildNodes.getLength(); ++j) {
                Node node = (Node)p2ChildNodes.item(j);
                if (node != child) continue;
                if (j - 1 >= 0) {
                    for (int k = j - 1; k >= 0; --k) {
                        if (!(p2ChildNodes.item(k) instanceof org.netbeans.modules.xml.xdm.nodes.Element) || !foundList.contains(p2ChildNodes.item(k))) continue;
                        this.siblingBefore = (Node)p2ChildNodes.item(k);
                        this.relativePos = j - k;
                        break;
                    }
                }
                if (this.siblingBefore != null) break;
            }
        }

        public Node getNode() {
            return this.siblingBefore;
        }

        public int getPosition() {
            return this.relativePos;
        }
    }

    public class PairComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int[] pair1 = (int[])o1;
            int px2_1 = pair1[1];
            int[] pair2 = (int[])o2;
            int px2_2 = pair2[1];
            if (px2_1 < px2_2) {
                return -1;
            }
            if (px2_1 > px2_2) {
                return 1;
            }
            return 0;
        }
    }

    public class PairComparator2
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int px2_2;
            Difference de1 = (Difference)o1;
            Difference de2 = (Difference)o2;
            int px2_1 = de1.getNewNodeInfo().getPosition();
            if (px2_1 < (px2_2 = de2.getNewNodeInfo().getPosition())) {
                return -1;
            }
            if (px2_1 > px2_2) {
                return 1;
            }
            return 0;
        }
    }
}

