/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.awt.event.ActionEvent;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class UndoRedoSupport {
    private static final Pattern DELIMITER_PATTERN = Pattern.compile("[ ,:;.!?\n\t]");
    private final JTextComponent component;
    private CompoundEdit edit;
    private int lastOffset;
    private int lastLength;
    private final UndoManager um;
    private static final String ACTION_NAME_UNDO = "undo.action";
    private static final String ACTION_NAME_REDO = "redo.action";

    public static UndoRedoSupport register(JTextComponent component) {
        UndoRedoSupport cum = new UndoRedoSupport(component);
        cum.init();
        return cum;
    }

    public void unregister() {
        this.um.discardAllEdits();
        this.component.getDocument().removeUndoableEditListener(this.um);
        this.component.getActionMap().remove(ACTION_NAME_UNDO);
        this.component.getActionMap().remove(ACTION_NAME_REDO);
    }

    private UndoRedoSupport(JTextComponent textComponent) {
        this.component = textComponent;
        this.um = new CompoundUndoManager();
    }

    private void init() {
        this.component.getDocument().addUndoableEditListener(this.um);
        this.component.getInputMap().put(KeyStroke.getKeyStroke(90, 128), ACTION_NAME_UNDO);
        this.component.getInputMap().put(KeyStroke.getKeyStroke(90, 256), ACTION_NAME_UNDO);
        this.component.getInputMap().put(KeyStroke.getKeyStroke(65483, 0), ACTION_NAME_UNDO);
        this.component.getActionMap().put(ACTION_NAME_UNDO, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UndoRedoSupport.this.um.canUndo()) {
                    UndoRedoSupport.this.um.undo();
                }
            }
        });
        this.component.getInputMap().put(KeyStroke.getKeyStroke(89, 128), ACTION_NAME_REDO);
        this.component.getInputMap().put(KeyStroke.getKeyStroke(89, 256), ACTION_NAME_REDO);
        this.component.getInputMap().put(KeyStroke.getKeyStroke(65481, 0), ACTION_NAME_UNDO);
        this.component.getActionMap().put(ACTION_NAME_REDO, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UndoRedoSupport.this.um.canRedo()) {
                    UndoRedoSupport.this.um.redo();
                }
            }
        });
    }

    private class CompoundUndoManager
    extends UndoManager {
        private CompoundUndoManager() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            if (UndoRedoSupport.this.edit == null) {
                this.startNewEdit(e.getEdit());
                this.processDocumentChange();
                return;
            }
            UndoableEdit event = e.getEdit();
            if (event instanceof DocumentEvent && ((DocumentEvent)((Object)event)).getType().equals(DocumentEvent.EventType.CHANGE)) {
                UndoRedoSupport.this.edit.addEdit(e.getEdit());
                return;
            }
            int offsetChange = UndoRedoSupport.this.component.getCaretPosition() - UndoRedoSupport.this.lastOffset;
            int lengthChange = UndoRedoSupport.this.component.getDocument().getLength() - UndoRedoSupport.this.lastLength;
            if (Math.abs(offsetChange) == 1 && Math.abs(lengthChange) == 1) {
                UndoRedoSupport.this.lastOffset = UndoRedoSupport.this.component.getCaretPosition();
                UndoRedoSupport.this.lastLength = UndoRedoSupport.this.component.getDocument().getLength();
                this.addEdit(e.getEdit());
                this.processDocumentChange();
            } else {
                this.startNewEdit(e.getEdit());
            }
        }

        private void startNewEdit(UndoableEdit atomicEdit) {
            if (UndoRedoSupport.this.edit != null) {
                UndoRedoSupport.this.edit.end();
            }
            UndoRedoSupport.this.edit = new MyCompoundEdit();
            UndoRedoSupport.this.edit.addEdit(atomicEdit);
            this.addEdit(UndoRedoSupport.this.edit);
            UndoRedoSupport.this.lastOffset = UndoRedoSupport.this.component.getCaretPosition();
            UndoRedoSupport.this.lastLength = UndoRedoSupport.this.component.getDocument().getLength();
        }

        private void processDocumentChange() {
            boolean endEdit;
            boolean bl = endEdit = UndoRedoSupport.this.lastOffset == 0;
            if (!endEdit) {
                try {
                    String lastChar = UndoRedoSupport.this.component.getDocument().getText(UndoRedoSupport.this.lastOffset - 1, 1);
                    endEdit = DELIMITER_PATTERN.matcher(lastChar).matches();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (endEdit) {
                UndoRedoSupport.this.edit.end();
                UndoRedoSupport.this.edit = null;
            }
        }
    }

    private class MyCompoundEdit
    extends CompoundEdit {
        private MyCompoundEdit() {
        }

        @Override
        public boolean isInProgress() {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (UndoRedoSupport.this.edit != null) {
                UndoRedoSupport.this.edit.end();
            }
            super.undo();
            UndoRedoSupport.this.edit = null;
        }
    }
}

