/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.vault;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.keymanagement.KmsManagementClient;
import com.oracle.bmc.keymanagement.KmsManagementClientBuilder;
import com.oracle.bmc.keymanagement.model.Vault;
import com.oracle.bmc.keymanagement.requests.ListKeysRequest;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.vault.KeyItem;
import org.netbeans.modules.cloud.oracle.vault.VaultItem;
import org.openide.nodes.Children;

public class KeyNode
extends OCINode {
    private static final String KEY_ICON = "org/netbeans/modules/cloud/oracle/resources/key.svg";
    private static final Logger LOG = Logger.getLogger(KeyNode.class.getName());

    public KeyNode(KeyItem key) {
        super((OCIItem)key, Children.LEAF);
        this.setName(key.getName());
        this.setDisplayName(key.getName());
        this.setIconBaseWithExtension(KEY_ICON);
        this.setShortDescription(key.getDescription());
    }

    public static NodeProvider<KeyItem> createNode() {
        return KeyNode::new;
    }

    public static ChildrenProvider.SessionAware<VaultItem, KeyItem> getKeys() {
        return (vault, session) -> {
            Vault v = Vault.builder().compartmentId(vault.getCompartmentId()).id(vault.getKey().getValue()).managementEndpoint(vault.getManagementEndpoint()).build();
            KmsManagementClient client = ((KmsManagementClientBuilder)KmsManagementClient.builder().vault(v)).build((AbstractAuthenticationDetailsProvider)session.getAuthenticationProvider());
            ListKeysRequest listKeysRequest = ListKeysRequest.builder().compartmentId(vault.getCompartmentId()).limit(Integer.valueOf(88)).build();
            String tenancyId = session.getTenancy().isPresent() ? session.getTenancy().get().getKey().getValue() : null;
            String regionCode = session.getRegion().getRegionCode();
            return client.listKeys(listKeysRequest).getItems().stream().map(d -> new KeyItem(OCID.of(d.getId(), "Vault/Key"), d.getCompartmentId(), d.getDisplayName(), vault.getKey().getValue(), tenancyId, regionCode)).collect(Collectors.toList());
        };
    }
}

