/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.project.api.problems;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Parameters;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class PlatformUpdatedCallBackImpl
implements BrokenReferencesSupport.PlatformUpdatedCallBack {
    private static final String[] DEFAULT_PRE_ELEMENTS = new String[]{"name", "minimum-ant-version"};
    private final String nameSpace;
    private final UpdateHelper helper;
    private final boolean setExplicitSourceSupported;
    private final Set<String> precedingElements;

    private PlatformUpdatedCallBackImpl(@NonNull String nameSpace, @NonNull UpdateHelper helper, boolean setExplicitSourceSupported, @NonNull String[] precedingElements) {
        Parameters.notNull((CharSequence)"nameSpace", (Object)nameSpace);
        Parameters.notNull((CharSequence)"helper", (Object)helper);
        Parameters.notNull((CharSequence)"precedingElements", (Object)precedingElements);
        this.nameSpace = nameSpace;
        this.helper = helper;
        this.setExplicitSourceSupported = setExplicitSourceSupported;
        this.precedingElements = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(precedingElements)));
    }

    private boolean updateProjectXml(@NonNull JavaPlatform platform) {
        assert (ProjectManager.mutex().isWriteAccess());
        boolean remove = platform.equals(JavaPlatformManager.getDefault().getDefaultPlatform());
        Element root = this.helper.getPrimaryConfigurationData(true);
        boolean changed = false;
        if (remove) {
            Element platformElement = XMLUtil.findElement((Element)root, (String)"explicit-platform", (String)this.nameSpace);
            if (platformElement != null) {
                root.removeChild(platformElement);
                changed = true;
            }
        } else {
            Node insertBefore = null;
            for (Element e : XMLUtil.findSubElements((Element)root)) {
                String name = e.getNodeName();
                if (this.precedingElements.contains(name)) continue;
                insertBefore = e;
                break;
            }
            Element platformNode = insertBefore.getOwnerDocument().createElementNS(this.nameSpace, "explicit-platform");
            if (this.setExplicitSourceSupported) {
                platformNode.setAttribute("explicit-source-supported", platform.getSpecification().getVersion().compareTo(new SpecificationVersion("1.3")) > 0 ? "true" : "false");
            }
            root.insertBefore(platformNode, insertBefore);
            changed = true;
        }
        if (changed) {
            this.helper.putPrimaryConfigurationData(root, true);
        }
        return changed;
    }

    public void platformPropertyUpdated(JavaPlatform platform) {
        this.updateProjectXml(platform);
    }

    @NonNull
    public static PlatformUpdatedCallBackImpl create(@NonNull String nameSpace, @NonNull UpdateHelper helper) {
        return new PlatformUpdatedCallBackImpl(nameSpace, helper, true, DEFAULT_PRE_ELEMENTS);
    }

    public static PlatformUpdatedCallBackImpl create(@NonNull String nameSpace, @NonNull UpdateHelper helper, boolean setExplicitSourceSupported, @NonNull String[] precedingElements) {
        return new PlatformUpdatedCallBackImpl(nameSpace, helper, setExplicitSourceSupported, precedingElements);
    }
}

