/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class SVNKeywords {
    public static final String LAST_CHANGED_DATE = "LastChangedDate";
    public static final String DATE = "Date";
    public static final String LAST_CHANGED_REVISION = "LastChangedRevision";
    public static final String REV = "Rev";
    public static final String LAST_CHANGED_BY = "LastChangedBy";
    public static final String AUTHOR = "Author";
    public static final String HEAD_URL = "HeadURL";
    public static final String URL = "URL";
    public static final String ID = "Id";
    private boolean lastChangedDate = false;
    private boolean lastChangedRevision = false;
    private boolean lastChangedBy = false;
    private boolean headUrl = false;
    private boolean id = false;

    public SVNKeywords() {
    }

    public SVNKeywords(String keywords) {
        if (keywords == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(keywords, " ");
        while (st.hasMoreTokens()) {
            String keyword = st.nextToken();
            if (keyword.equals(HEAD_URL) || keyword.equals(URL)) {
                this.headUrl = true;
                continue;
            }
            if (keyword.equals(ID)) {
                this.id = true;
                continue;
            }
            if (keyword.equals(LAST_CHANGED_BY) || keyword.equals(AUTHOR)) {
                this.lastChangedBy = true;
                continue;
            }
            if (keyword.equals(LAST_CHANGED_DATE) || keyword.equals(DATE)) {
                this.lastChangedDate = true;
                continue;
            }
            if (!keyword.equals(LAST_CHANGED_REVISION) && !keyword.equals(REV)) continue;
            this.lastChangedRevision = true;
        }
    }

    public SVNKeywords(boolean lastChangedDate, boolean lastChangedRevision, boolean lastChangedBy, boolean headUrl, boolean id) {
        this.lastChangedDate = lastChangedDate;
        this.lastChangedRevision = lastChangedRevision;
        this.lastChangedBy = lastChangedBy;
        this.headUrl = headUrl;
        this.id = id;
    }

    public boolean isHeadUrl() {
        return this.headUrl;
    }

    public boolean isId() {
        return this.id;
    }

    public boolean isLastChangedBy() {
        return this.lastChangedBy;
    }

    public boolean isLastChangedDate() {
        return this.lastChangedDate;
    }

    public boolean isLastChangedRevision() {
        return this.lastChangedRevision;
    }

    public List getKeywordsList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.headUrl) {
            list.add(HEAD_URL);
        }
        if (this.id) {
            list.add(ID);
        }
        if (this.lastChangedBy) {
            list.add(LAST_CHANGED_BY);
        }
        if (this.lastChangedDate) {
            list.add(LAST_CHANGED_DATE);
        }
        if (this.lastChangedRevision) {
            list.add(LAST_CHANGED_REVISION);
        }
        return list;
    }

    public String toString() {
        String result = "";
        Iterator it = this.getKeywordsList().iterator();
        while (it.hasNext()) {
            String keyword = (String)it.next();
            result = result + keyword;
            if (!it.hasNext()) continue;
            result = result + ' ';
        }
        return result;
    }

    public void setHeadUrl(boolean b) {
        this.headUrl = b;
    }

    public void setId(boolean b) {
        this.id = b;
    }

    public void setLastChangedBy(boolean b) {
        this.lastChangedBy = b;
    }

    public void setLastChangedDate(boolean b) {
        this.lastChangedDate = b;
    }

    public void setLastChangedRevision(boolean b) {
        this.lastChangedRevision = b;
    }
}

