/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.netbeans.jemmy.Timeout;

public class Timeouts {
    private static final long DELTA_TIME = 100L;
    private static Timeouts defaults;
    private Hashtable timeouts = new Hashtable();
    private static double timeoutsScale;

    public Timeouts() {
        this.setTimeout("Timeouts.DeltaTimeout", 100L);
        try {
            this.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setDefault(String name, long newValue) {
        defaults.setTimeout(name, newValue);
    }

    public static void initDefault(String name, long newValue) {
        defaults.initTimeout(name, newValue);
    }

    public static long getDefault(String name) {
        return defaults.getTimeout(name);
    }

    public static boolean containsDefault(String name) {
        return defaults.contains(name);
    }

    public void loadDefaults(InputStream stream) throws IOException {
        defaults.load(stream);
    }

    public void loadDefaults(String fileName) throws FileNotFoundException, IOException {
        defaults.load(fileName);
    }

    public void loadDefaults() throws FileNotFoundException, IOException {
        defaults.load();
    }

    public Timeout create(String name) {
        return new Timeout(name, this.getTimeout(name));
    }

    public Timeout createDelta() {
        return this.create("Timeouts.DeltaTimeout");
    }

    public boolean contains(String name) {
        return this.timeouts.containsKey(name);
    }

    public long setTimeout(String name, long newValue) {
        long oldValue = -1L;
        if (this.contains(name)) {
            oldValue = this.getTimeout(name);
            this.timeouts.remove(name);
        }
        this.timeouts.put(name, new Long(newValue));
        return oldValue;
    }

    public long getTimeout(String name) {
        long timeout;
        if (this.contains(name) && this.timeouts.get(name) != null) {
            timeout = (Long)this.timeouts.get(name);
            timeout = (long)((double)timeout * Timeouts.getTimeoutsScale());
        } else {
            timeout = this != defaults ? Timeouts.getDefault(name) : -1L;
        }
        return timeout;
    }

    public long getDeltaTimeout() {
        return this.getTimeout("Timeouts.DeltaTimeout");
    }

    public long initTimeout(String name, long newValue) {
        long result = this.getTimeout(name);
        if (!this.contains(name)) {
            this.setTimeout(name, newValue);
        }
        return result;
    }

    public Timeouts cloneThis() {
        Timeouts t = new Timeouts();
        Enumeration e = this.timeouts.keys();
        String name = "";
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            t.setTimeout(name, this.getTimeout(name));
        }
        return t;
    }

    public void eSleep(String name) throws InterruptedException {
        if (this.contains(name) || defaults.contains(name)) {
            Thread.currentThread();
            Thread.sleep(this.getTimeout(name));
        }
    }

    public void sleep(String name) {
        this.create(name).sleep();
    }

    public void print(PrintWriter pw) {
        Enumeration e = this.timeouts.keys();
        String name = "";
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            pw.println(name + " = " + Long.toString(this.getTimeout(name)));
        }
        pw.println("Default values:");
        e = Timeouts.defaults.timeouts.keys();
        name = "";
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            if (this.contains(name)) continue;
            pw.println(name + " = " + Long.toString(Timeouts.getDefault(name)));
        }
    }

    public void print(PrintStream ps) {
        this.print(new PrintWriter(ps));
    }

    public void load(InputStream stream) throws IOException {
        Properties props = new Properties();
        props.load(stream);
        Enumeration<?> propNames = props.propertyNames();
        long propValue = -1L;
        String propName = null;
        while (propNames.hasMoreElements()) {
            propName = (String)propNames.nextElement();
            propValue = -1L;
            propValue = new Long(props.getProperty(propName));
            this.setTimeout(propName, propValue);
        }
    }

    public void load(String fileName) throws FileNotFoundException, IOException {
        this.load(new FileInputStream(fileName));
    }

    public void load() throws FileNotFoundException, IOException {
        if (System.getProperty("jemmy.timeouts") != null && !System.getProperty("jemmy.timeouts").equals("")) {
            this.load(System.getProperty("jemmy.timeouts"));
        }
    }

    public void loadDebugTimeouts() throws IOException {
        this.load(this.getClass().getClassLoader().getResourceAsStream("org/netbeans/jemmy/debug.timeouts"));
    }

    public static double getTimeoutsScale() {
        if (timeoutsScale == -1.0) {
            String s = System.getProperty("jemmy.timeouts.scale", "1");
            try {
                timeoutsScale = Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                timeoutsScale = 1.0;
            }
        }
        if (timeoutsScale < 0.0) {
            timeoutsScale = 1.0;
        }
        return timeoutsScale;
    }

    static void resetTimeoutScale() {
        timeoutsScale = -1.0;
    }

    static {
        timeoutsScale = -1.0;
        defaults = new Timeouts();
    }
}

