/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.metrics;

import edu.stanford.nlp.international.Languages;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasIndex;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.util.StringUtils;
import java.io.File;
import java.io.PrintWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeafAncestorEval {
    private final String name;
    private static final boolean DEBUG = false;
    private double sentAvg = 0.0;
    private double sentNum = 0.0;
    private int sentExact = 0;
    private double corpusAvg = 0.0;
    private double corpusNum = 0.0;
    private final Map<List<CoreLabel>, Double> catAvg;
    private final Map<List<CoreLabel>, Double> catNum;
    private static StringBuilder usage = new StringBuilder();
    private static final int MIN_ARGS = 2;
    private static boolean VERBOSE;
    private static Languages.Language LANGUAGE;
    private static int MAX_GOLD_YIELD;
    private static int MAX_GUESS_YIELD;
    private static boolean skipGuess;
    private static File guessFile;
    private static File goldFile;
    public static final Map<String, Integer> optionArgDefs;

    public LeafAncestorEval(String str) {
        this.name = str;
        this.catAvg = new HashMap<List<CoreLabel>, Double>();
        this.catNum = new HashMap<List<CoreLabel>, Double>();
    }

    private List<List<CoreLabel>> makeLineages(Tree t) {
        if (t == null) {
            return null;
        }
        ((HasIndex)((Object)t.label())).setIndex(0);
        Stack<Tree> treeStack = new Stack<Tree>();
        treeStack.push(t);
        Stack<CoreLabel> labelStack = new Stack<CoreLabel>();
        CoreLabel rootLabel = new CoreLabel(t.label());
        rootLabel.setIndex(0);
        labelStack.push(rootLabel);
        ArrayList<List<CoreLabel>> lineages = new ArrayList<List<CoreLabel>>();
        while (!treeStack.isEmpty()) {
            Tree node = (Tree)treeStack.pop();
            int nodeDepth = ((HasIndex)((Object)node.label())).index();
            while (!labelStack.isEmpty() && ((CoreLabel)labelStack.peek()).index() != nodeDepth - 1) {
                labelStack.pop();
            }
            if (node.isPreTerminal()) {
                ArrayList<CoreLabel> lin = new ArrayList<CoreLabel>(labelStack);
                lin.add(new CoreLabel(node.label()));
                lineages.add(lin);
                continue;
            }
            for (Tree kid : node.children()) {
                ((HasIndex)((Object)kid.label())).setIndex(nodeDepth + 1);
                treeStack.push(kid);
            }
            CoreLabel nodeLabel = new CoreLabel(node.label());
            nodeLabel.setIndex(nodeDepth);
            labelStack.add(nodeLabel);
        }
        return lineages;
    }

    private void updateCatAverages(List<CoreLabel> lineage, double score) {
        if (this.catAvg.get(lineage) == null) {
            this.catAvg.put(lineage, score);
            this.catNum.put(lineage, 1.0);
        } else {
            double newAvg = this.catAvg.get(lineage) + score;
            this.catAvg.put(lineage, newAvg);
            double newNum = this.catNum.get(lineage) + 1.0;
            this.catNum.put(lineage, newNum);
        }
    }

    public void evaluate(Tree guess, Tree gold, PrintWriter pw) {
        if (gold == null || guess == null) {
            System.err.printf("%s: Cannot compare against a null gold or guess tree!\n", this.getClass().getName());
            return;
        }
        List<List<CoreLabel>> guessLineages = this.makeLineages(guess);
        List<List<CoreLabel>> goldLineages = this.makeLineages(gold);
        if (guessLineages.size() == goldLineages.size()) {
            double localScores = 0.0;
            for (int i = 0; i < guessLineages.size(); ++i) {
                List<CoreLabel> guessLin = guessLineages.get(i);
                List<CoreLabel> goldLin = goldLineages.get(i);
                double levDist = this.editDistance(guessLin, goldLin);
                double la = 1.0 - levDist / (double)(guessLin.size() + goldLin.size());
                localScores += la;
                this.updateCatAverages(goldLin, la);
            }
            this.corpusAvg += localScores;
            this.corpusNum += (double)goldLineages.size();
            double localSentAvg = localScores / (double)goldLineages.size();
            if (localSentAvg == 1.0) {
                ++this.sentExact;
            }
            this.sentAvg += localSentAvg;
            this.sentNum += 1.0;
        } else {
            System.err.printf("%s: Number of guess (%d) gold (%d) don't match!\n", this.getClass().getName(), guessLineages.size(), goldLineages.size());
            System.err.println("Cannot evaluate!");
            System.err.printf("GUESS tree:\n%s\n", guess.toString());
            System.err.printf("GOLD tree:\n%s\n", gold.toString());
        }
    }

    private int editDistance(List<CoreLabel> l1, List<CoreLabel> l2) {
        int i;
        int[][] m = new int[l1.size() + 1][l2.size() + 1];
        for (i = 1; i <= l1.size(); ++i) {
            m[i][0] = i;
        }
        for (int j = 1; j <= l2.size(); ++j) {
            m[0][j] = j;
        }
        for (i = 1; i <= l1.size(); ++i) {
            for (int j = 1; j <= l2.size(); ++j) {
                m[i][j] = Math.min(m[i - 1][j - 1] + (l1.get(i - 1).equals(l2.get(j - 1)) ? 0 : 1), m[i - 1][j] + 1);
                m[i][j] = Math.min(m[i][j], m[i][j - 1] + 1);
            }
        }
        return m[l1.size()][l2.size()];
    }

    private String toString(List<CoreLabel> lineage) {
        StringBuilder sb = new StringBuilder();
        for (CoreLabel cl : lineage) {
            sb.append(cl.value());
            sb.append(" <-- ");
        }
        return sb.toString();
    }

    public void display(boolean verbose, PrintWriter pw) {
        Random rand = new Random();
        double corpusLevel = this.corpusAvg / this.corpusNum;
        double sentLevel = this.sentAvg / this.sentNum;
        double sentEx = 100.0 * (double)this.sentExact / this.sentNum;
        if (verbose) {
            double avg;
            TreeMap<Double, List<CoreLabel>> avgMap = new TreeMap<Double, List<CoreLabel>>();
            for (List<CoreLabel> lineage : this.catAvg.keySet()) {
                avg = this.catAvg.get(lineage) / this.catNum.get(lineage);
                if (new Double(avg).equals(Double.NaN)) {
                    avg = -1.0;
                }
                if (avgMap.containsKey(avg)) {
                    avgMap.put(avg + rand.nextDouble() / 10000.0, lineage);
                    continue;
                }
                avgMap.put(avg, lineage);
            }
            pw.println("============================================================");
            pw.println("Leaf Ancestor Metric(" + this.name + ") -- final statistics");
            pw.println("============================================================");
            pw.println("#Sentences: " + (int)this.sentNum);
            pw.println();
            pw.println("Sentence-level (macro-averaged)");
            pw.printf(" Avg: %.3f%n", sentLevel);
            pw.printf(" Exact: %.2f%%%n", sentEx);
            pw.println();
            pw.println("Corpus-level (micro-averaged)");
            pw.printf(" Avg: %.3f%n", corpusLevel);
            pw.println("============================================================");
            for (List<CoreLabel> lineage : avgMap.values()) {
                if (this.catNum.get(lineage) < 30.0) continue;
                avg = this.catAvg.get(lineage) / this.catNum.get(lineage);
                pw.printf(" %.3f\t%d\t%s\n", avg, (int)this.catNum.get(lineage).doubleValue(), this.toString(lineage));
            }
            pw.println("============================================================");
        } else {
            pw.printf("%s summary: corpus: %.3f sent: %.3f sent-ex: %.2f%n", this.name, corpusLevel, sentLevel, sentEx);
        }
    }

    private static boolean validateCommandLine(String[] args) {
        Map<String, String[]> argsMap = StringUtils.argsToMap(args, optionArgDefs);
        for (Map.Entry<String, String[]> opt : argsMap.entrySet()) {
            String key = opt.getKey();
            if (key == null) continue;
            if (key.equals("-g")) {
                skipGuess = true;
                MAX_GUESS_YIELD = Integer.valueOf(opt.getValue()[0]);
                continue;
            }
            if (key.equals("-y")) {
                MAX_GOLD_YIELD = Integer.valueOf(opt.getValue()[0]);
                continue;
            }
            if (key.equals("-l")) {
                LANGUAGE = Languages.Language.valueOf(opt.getValue()[0]);
                continue;
            }
            if (key.equals("-v")) {
                VERBOSE = true;
                continue;
            }
            return false;
        }
        String[] rest = argsMap.get(null);
        if (rest == null || rest.length != 2) {
            return false;
        }
        goldFile = new File(rest[0]);
        guessFile = new File(rest[1]);
        return true;
    }

    public static void main(String[] args) {
        if (!LeafAncestorEval.validateCommandLine(args)) {
            System.err.println(usage);
            System.exit(-1);
        }
        TreebankLangParserParams tlpp = Languages.getLanguageParams(LANGUAGE);
        PrintWriter pwOut = tlpp.pw();
        DiskTreebank guessTreebank = tlpp.diskTreebank();
        guessTreebank.loadPath(guessFile);
        pwOut.println("GUESS TREEBANK:");
        pwOut.println(guessTreebank.textualSummary());
        DiskTreebank goldTreebank = tlpp.diskTreebank();
        goldTreebank.loadPath(goldFile);
        pwOut.println("GOLD TREEBANK:");
        pwOut.println(goldTreebank.textualSummary());
        LeafAncestorEval depEval = new LeafAncestorEval("Stand Alone");
        TreeTransformer tc = tlpp.collinizer();
        Iterator goldItr = ((AbstractCollection)goldTreebank).iterator();
        int goldLineId = 0;
        int skippedGuessTrees = 0;
        block0: for (Tree guess : guessTreebank) {
            Tree evalGuess = tc.transformTree(guess);
            if (guess.yield().size() > MAX_GUESS_YIELD) {
                ++skippedGuessTrees;
                continue;
            }
            boolean doneEval = false;
            while (goldItr.hasNext() && !doneEval) {
                Tree gold = (Tree)goldItr.next();
                Tree evalGold = tc.transformTree(gold);
                ++goldLineId;
                if (gold.yield().size() > MAX_GOLD_YIELD) continue;
                if (gold.yield().size() != guess.yield().size()) {
                    pwOut.println("Yield mismatch at gold line " + goldLineId);
                    ++skippedGuessTrees;
                    continue block0;
                }
                depEval.evaluate(evalGuess, evalGold, VERBOSE ? pwOut : null);
                doneEval = true;
            }
        }
        pwOut.println("================================================================================");
        if (skippedGuessTrees != 0) {
            pwOut.printf("%s %d guess trees\n", skipGuess ? "Skipped" : "Unable to evaluate", skippedGuessTrees);
        }
        depEval.display(true, pwOut);
        pwOut.close();
    }

    static {
        usage.append(String.format("Usage: java %s [OPTS] goldFile guessFile\n\n", LeafAncestorEval.class.getName()));
        usage.append("Options:\n");
        usage.append("  -l lang   : Language name " + Languages.listOfLanguages() + "\n");
        usage.append("  -y num    : Skip gold trees with yields longer than num.\n");
        usage.append("  -g num    : Skip guess trees with yields longer than num.\n");
        usage.append("  -v        : Verbose output\n");
        VERBOSE = false;
        LANGUAGE = Languages.Language.English;
        MAX_GOLD_YIELD = Integer.MAX_VALUE;
        MAX_GUESS_YIELD = Integer.MAX_VALUE;
        skipGuess = false;
        guessFile = null;
        goldFile = null;
        optionArgDefs = new HashMap<String, Integer>();
        optionArgDefs.put("-g", 1);
        optionArgDefs.put("-y", 1);
        optionArgDefs.put("-l", 1);
        optionArgDefs.put("-v", 0);
    }
}

