/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyIpamResourceCidrRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyIpamResourceCidrRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyIpamResourceCidrRequest.getter(ModifyIpamResourceCidrRequest::dryRun)).setter(ModifyIpamResourceCidrRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ModifyIpamResourceCidrRequest.getter(ModifyIpamResourceCidrRequest::resourceId)).setter(ModifyIpamResourceCidrRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("ResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceCidr").getter(ModifyIpamResourceCidrRequest.getter(ModifyIpamResourceCidrRequest::resourceCidr)).setter(ModifyIpamResourceCidrRequest.setter(Builder::resourceCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCidr").unmarshallLocationName("ResourceCidr").build()}).build();
    private static final SdkField<String> RESOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceRegion").getter(ModifyIpamResourceCidrRequest.getter(ModifyIpamResourceCidrRequest::resourceRegion)).setter(ModifyIpamResourceCidrRequest.setter(Builder::resourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRegion").unmarshallLocationName("ResourceRegion").build()}).build();
    private static final SdkField<String> CURRENT_IPAM_SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentIpamScopeId").getter(ModifyIpamResourceCidrRequest.getter(ModifyIpamResourceCidrRequest::currentIpamScopeId)).setter(ModifyIpamResourceCidrRequest.setter(Builder::currentIpamScopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentIpamScopeId").unmarshallLocationName("CurrentIpamScopeId").build()}).build();
    private static final SdkField<String> DESTINATION_IPAM_SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationIpamScopeId").getter(ModifyIpamResourceCidrRequest.getter(ModifyIpamResourceCidrRequest::destinationIpamScopeId)).setter(ModifyIpamResourceCidrRequest.setter(Builder::destinationIpamScopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIpamScopeId").unmarshallLocationName("DestinationIpamScopeId").build()}).build();
    private static final SdkField<Boolean> MONITORED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Monitored").getter(ModifyIpamResourceCidrRequest.getter(ModifyIpamResourceCidrRequest::monitored)).setter(ModifyIpamResourceCidrRequest.setter(Builder::monitored)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitored").unmarshallLocationName("Monitored").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, RESOURCE_ID_FIELD, RESOURCE_CIDR_FIELD, RESOURCE_REGION_FIELD, CURRENT_IPAM_SCOPE_ID_FIELD, DESTINATION_IPAM_SCOPE_ID_FIELD, MONITORED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyIpamResourceCidrRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String resourceId;
    private final String resourceCidr;
    private final String resourceRegion;
    private final String currentIpamScopeId;
    private final String destinationIpamScopeId;
    private final Boolean monitored;

    private ModifyIpamResourceCidrRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.resourceId = builder.resourceId;
        this.resourceCidr = builder.resourceCidr;
        this.resourceRegion = builder.resourceRegion;
        this.currentIpamScopeId = builder.currentIpamScopeId;
        this.destinationIpamScopeId = builder.destinationIpamScopeId;
        this.monitored = builder.monitored;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceCidr() {
        return this.resourceCidr;
    }

    public final String resourceRegion() {
        return this.resourceRegion;
    }

    public final String currentIpamScopeId() {
        return this.currentIpamScopeId;
    }

    public final String destinationIpamScopeId() {
        return this.destinationIpamScopeId;
    }

    public final Boolean monitored() {
        return this.monitored;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentIpamScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationIpamScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitored());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpamResourceCidrRequest)) {
            return false;
        }
        ModifyIpamResourceCidrRequest other = (ModifyIpamResourceCidrRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceCidr(), other.resourceCidr()) && Objects.equals(this.resourceRegion(), other.resourceRegion()) && Objects.equals(this.currentIpamScopeId(), other.currentIpamScopeId()) && Objects.equals(this.destinationIpamScopeId(), other.destinationIpamScopeId()) && Objects.equals(this.monitored(), other.monitored());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyIpamResourceCidrRequest").add("DryRun", (Object)this.dryRun()).add("ResourceId", (Object)this.resourceId()).add("ResourceCidr", (Object)this.resourceCidr()).add("ResourceRegion", (Object)this.resourceRegion()).add("CurrentIpamScopeId", (Object)this.currentIpamScopeId()).add("DestinationIpamScopeId", (Object)this.destinationIpamScopeId()).add("Monitored", (Object)this.monitored()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceCidr": {
                return Optional.ofNullable(clazz.cast(this.resourceCidr()));
            }
            case "ResourceRegion": {
                return Optional.ofNullable(clazz.cast(this.resourceRegion()));
            }
            case "CurrentIpamScopeId": {
                return Optional.ofNullable(clazz.cast(this.currentIpamScopeId()));
            }
            case "DestinationIpamScopeId": {
                return Optional.ofNullable(clazz.cast(this.destinationIpamScopeId()));
            }
            case "Monitored": {
                return Optional.ofNullable(clazz.cast(this.monitored()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceCidr", RESOURCE_CIDR_FIELD);
        map.put("ResourceRegion", RESOURCE_REGION_FIELD);
        map.put("CurrentIpamScopeId", CURRENT_IPAM_SCOPE_ID_FIELD);
        map.put("DestinationIpamScopeId", DESTINATION_IPAM_SCOPE_ID_FIELD);
        map.put("Monitored", MONITORED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyIpamResourceCidrRequest, T> g) {
        return obj -> g.apply((ModifyIpamResourceCidrRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String resourceId;
        private String resourceCidr;
        private String resourceRegion;
        private String currentIpamScopeId;
        private String destinationIpamScopeId;
        private Boolean monitored;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIpamResourceCidrRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.resourceId(model.resourceId);
            this.resourceCidr(model.resourceCidr);
            this.resourceRegion(model.resourceRegion);
            this.currentIpamScopeId(model.currentIpamScopeId);
            this.destinationIpamScopeId(model.destinationIpamScopeId);
            this.monitored(model.monitored);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceCidr() {
            return this.resourceCidr;
        }

        public final void setResourceCidr(String resourceCidr) {
            this.resourceCidr = resourceCidr;
        }

        @Override
        public final Builder resourceCidr(String resourceCidr) {
            this.resourceCidr = resourceCidr;
            return this;
        }

        public final String getResourceRegion() {
            return this.resourceRegion;
        }

        public final void setResourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
        }

        @Override
        public final Builder resourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
            return this;
        }

        public final String getCurrentIpamScopeId() {
            return this.currentIpamScopeId;
        }

        public final void setCurrentIpamScopeId(String currentIpamScopeId) {
            this.currentIpamScopeId = currentIpamScopeId;
        }

        @Override
        public final Builder currentIpamScopeId(String currentIpamScopeId) {
            this.currentIpamScopeId = currentIpamScopeId;
            return this;
        }

        public final String getDestinationIpamScopeId() {
            return this.destinationIpamScopeId;
        }

        public final void setDestinationIpamScopeId(String destinationIpamScopeId) {
            this.destinationIpamScopeId = destinationIpamScopeId;
        }

        @Override
        public final Builder destinationIpamScopeId(String destinationIpamScopeId) {
            this.destinationIpamScopeId = destinationIpamScopeId;
            return this;
        }

        public final Boolean getMonitored() {
            return this.monitored;
        }

        public final void setMonitored(Boolean monitored) {
            this.monitored = monitored;
        }

        @Override
        public final Builder monitored(Boolean monitored) {
            this.monitored = monitored;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIpamResourceCidrRequest build() {
            return new ModifyIpamResourceCidrRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyIpamResourceCidrRequest> {
        public Builder dryRun(Boolean var1);

        public Builder resourceId(String var1);

        public Builder resourceCidr(String var1);

        public Builder resourceRegion(String var1);

        public Builder currentIpamScopeId(String var1);

        public Builder destinationIpamScopeId(String var1);

        public Builder monitored(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

