/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.ImportedFiles;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.TMemoryGlobal;

public class TimLoader {
    private final TContext context;
    private final TMemory global = new TMemoryGlobal();
    private boolean preprocessorError;
    private List<StringLocated> resultList;
    private PreprocessingArtifact preprocessingArtifact;

    public TimLoader(ImportedFiles importedFiles, Defines defines, Charset charset, DefinitionsContainer definitionsContainer, StringLocated location) {
        this.context = new TContext(importedFiles, defines, charset, definitionsContainer);
        try {
            defines.copyTo(this.global, location);
        }
        catch (EaterException e) {
            Logme.error(e);
        }
    }

    public Set<FileWithSuffix> load(List<StringLocated> list) {
        try {
            this.context.executeLines(this.global, list, null, false);
        }
        catch (EaterException e) {
            this.context.getResultList().add(e.getLocation().withErrorPreprocessor(e.getMessage()));
            this.changeLastLine(this.context.getDebug(), e.getMessage());
            this.preprocessorError = true;
        }
        this.resultList = this.context.getResultList();
        this.preprocessingArtifact = this.context.getPreprocessingArtifact();
        return this.context.getFilesUsedCurrent();
    }

    private void changeLastLine(List<StringLocated> list, String message) {
        int num = list.size() - 1;
        StringLocated last = list.get(num);
        list.set(num, last.withErrorPreprocessor(message));
    }

    public final List<StringLocated> getResultList() {
        return this.resultList;
    }

    public final List<StringLocated> getDebug() {
        return this.context.getDebug();
    }

    public final boolean isPreprocessorError() {
        return this.preprocessorError;
    }

    public PreprocessingArtifact getPreprocessingArtifact() {
        return this.preprocessingArtifact;
    }
}

