/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.cucadiagram.BodyFactory;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.decoration.symbol.USymbols;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.url.Url;

public class EntityImageState2
extends AbstractEntityImage {
    private final Url url;
    private final TextBlock asSmall;

    public EntityImageState2(Entity entity) {
        super(entity);
        Stereotype stereotype = entity.getStereotype();
        USymbol symbol = USymbols.FRAME;
        Fashion ctx = this.getStyle().getSymbolContext(this.getSkinParam().getIHtmlColorSet());
        this.url = entity.getUrl99();
        TextBlock stereo = TextBlockUtils.empty(0.0, 0.0);
        TextBlock desc = BodyFactory.create2(this.getSkinParam().getDefaultTextAlignment(HorizontalAlignment.CENTER), entity.getDisplay(), this.getSkinParam(), stereotype, entity, this.getStyle());
        this.asSmall = symbol.asSmall(null, desc, stereo, ctx, this.getSkinParam().getStereotypeAlignment());
    }

    private Style getStyle() {
        return this.getStyleSignature().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    private StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.getStyleName(), SName.state);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.asSmall.calculateDimension(stringBounder);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        this.asSmall.drawU(ug);
        if (this.url != null) {
            ug.closeUrl();
        }
    }
}

