/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core.snapshots;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.util.NamedList;
import org.noggit.JSONWriter;

public class CollectionSnapshotMetaData
implements JSONWriter.Writable {
    private final String name;
    private final SnapshotStatus status;
    private final Date creationDate;
    private final List<CoreSnapshotMetaData> replicaSnapshots;

    public CollectionSnapshotMetaData(String name) {
        this(name, SnapshotStatus.InProgress, new Date(), Collections.emptyList());
    }

    public CollectionSnapshotMetaData(String name, SnapshotStatus status, Date creationTime, List<CoreSnapshotMetaData> replicaSnapshots) {
        this.name = name;
        this.status = status;
        this.creationDate = creationTime;
        this.replicaSnapshots = replicaSnapshots;
    }

    public CollectionSnapshotMetaData(Map<String, Object> data) {
        this.name = (String)data.get("name");
        this.status = SnapshotStatus.valueOf((String)data.get("status"));
        this.creationDate = new Date((Long)data.get("creationDate"));
        this.replicaSnapshots = new ArrayList<CoreSnapshotMetaData>();
        List r = (List)data.get("replicas");
        for (Object x : r) {
            Map info = (Map)x;
            String coreName = (String)info.get("core");
            String indexDirPath = (String)info.get("indexDirPath");
            long generationNumber = (Long)info.get("generation");
            String shardId = (String)info.get("shard_id");
            boolean leader = (Boolean)info.get("leader");
            Collection files = (Collection)info.get("files");
            this.replicaSnapshots.add(new CoreSnapshotMetaData(coreName, indexDirPath, generationNumber, shardId, leader, files));
        }
    }

    public CollectionSnapshotMetaData(NamedList<?> data) {
        this.name = (String)data.get("name");
        String statusStr = (String)data.get("status");
        this.creationDate = new Date((Long)data.get("creationDate"));
        this.status = SnapshotStatus.valueOf(statusStr);
        this.replicaSnapshots = new ArrayList<CoreSnapshotMetaData>();
        NamedList r = (NamedList)data.get("replicas");
        for (Map.Entry x : r) {
            NamedList info = (NamedList)x.getValue();
            String coreName = (String)info.get("core");
            String indexDirPath = (String)info.get("indexDirPath");
            long generationNumber = (Long)info.get("generation");
            String shardId = (String)info.get("shard_id");
            boolean leader = (Boolean)info.get("leader");
            Collection files = (Collection)info.get("files");
            this.replicaSnapshots.add(new CoreSnapshotMetaData(coreName, indexDirPath, generationNumber, shardId, leader, files));
        }
    }

    public String getName() {
        return this.name;
    }

    public SnapshotStatus getStatus() {
        return this.status;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public List<CoreSnapshotMetaData> getReplicaSnapshots() {
        return this.replicaSnapshots;
    }

    public List<CoreSnapshotMetaData> getReplicaSnapshotsForShard(String shardId) {
        ArrayList<CoreSnapshotMetaData> result = new ArrayList<CoreSnapshotMetaData>();
        for (CoreSnapshotMetaData d : this.replicaSnapshots) {
            if (!d.getShardId().equals(shardId)) continue;
            result.add(d);
        }
        return result;
    }

    public boolean isSnapshotExists(String shardId, Replica r) {
        for (CoreSnapshotMetaData d : this.replicaSnapshots) {
            if (!d.getShardId().equals(shardId) || !d.getCoreName().equals(r.getCoreName())) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getShards() {
        HashSet<String> result = new HashSet<String>();
        for (CoreSnapshotMetaData d : this.replicaSnapshots) {
            result.add(d.getShardId());
        }
        return result;
    }

    public void write(JSONWriter arg0) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.name);
        result.put("status", this.status.toString());
        result.put("creationDate", this.getCreationDate().getTime());
        result.put("replicas", this.replicaSnapshots);
        arg0.write(result);
    }

    public NamedList<Object> toNamedList() {
        NamedList result = new NamedList();
        result.add("name", (Object)this.name);
        result.add("status", (Object)this.status.toString());
        result.add("creationDate", (Object)this.getCreationDate().getTime());
        NamedList replicas = new NamedList();
        for (CoreSnapshotMetaData x : this.replicaSnapshots) {
            replicas.add(x.getCoreName(), x.toNamedList());
        }
        result.add("replicas", (Object)replicas);
        return result;
    }

    public static enum SnapshotStatus {
        Successful,
        InProgress,
        Failed;

    }

    public static class CoreSnapshotMetaData
    implements JSONWriter.Writable {
        private final String coreName;
        private final String indexDirPath;
        private final long generationNumber;
        private final boolean leader;
        private final String shardId;
        private final Collection<String> files;

        public CoreSnapshotMetaData(String coreName, String indexDirPath, long generationNumber, String shardId, boolean leader, Collection<String> files) {
            this.coreName = coreName;
            this.indexDirPath = indexDirPath;
            this.generationNumber = generationNumber;
            this.shardId = shardId;
            this.leader = leader;
            this.files = files;
        }

        public CoreSnapshotMetaData(NamedList<?> resp) {
            this.coreName = (String)resp.get("core");
            this.indexDirPath = (String)resp.get("indexDirPath");
            this.generationNumber = (Long)resp.get("generation");
            this.shardId = (String)resp.get("shard_id");
            this.leader = (Boolean)resp.get("leader");
            this.files = (Collection)resp.get("files");
        }

        public String getCoreName() {
            return this.coreName;
        }

        public String getIndexDirPath() {
            return this.indexDirPath;
        }

        public long getGenerationNumber() {
            return this.generationNumber;
        }

        public Collection<String> getFiles() {
            return this.files;
        }

        public String getShardId() {
            return this.shardId;
        }

        public boolean isLeader() {
            return this.leader;
        }

        public void write(JSONWriter arg0) {
            LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
            info.put("core", this.getCoreName());
            info.put("indexDirPath", this.getIndexDirPath());
            info.put("generation", this.getGenerationNumber());
            info.put("shard_id", this.getShardId());
            info.put("leader", this.isLeader());
            info.put("files", this.getFiles());
            arg0.write(info);
        }

        public NamedList<Object> toNamedList() {
            NamedList result = new NamedList();
            result.add("core", (Object)this.getCoreName());
            result.add("indexDirPath", (Object)this.getIndexDirPath());
            result.add("generation", (Object)this.getGenerationNumber());
            result.add("shard_id", (Object)this.getShardId());
            result.add("leader", (Object)this.isLeader());
            result.add("files", this.getFiles());
            return result;
        }
    }
}

