/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.PointOutsideCoverageException;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.ConvertedGridCoverage;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.FractionalGridCoordinates;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridEvaluator;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridOrientation;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.coverage.grid.ReshapedImage;
import org.apache.sis.image.DataType;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;

public class GridCoverage2D
extends GridCoverage {
    static final int BIDIMENSIONAL = 2;
    private final RenderedImage data;
    private final long gridToImageX;
    private final long gridToImageY;
    private final int xDimension;
    private final int yDimension;
    private final AtomicReference<GridGeometry> gridGeometry2D;

    private GridCoverage2D(GridCoverage2D gridCoverage2D, List<SampleDimension> list, MathTransform1D[] mathTransform1DArray, boolean bl) {
        super(gridCoverage2D.gridGeometry, list);
        DataType dataType = ConvertedGridCoverage.getBandType(list, bl, gridCoverage2D);
        this.data = this.convert(gridCoverage2D.data, dataType, mathTransform1DArray);
        this.gridToImageX = gridCoverage2D.gridToImageX;
        this.gridToImageY = gridCoverage2D.gridToImageY;
        this.xDimension = gridCoverage2D.xDimension;
        this.yDimension = gridCoverage2D.yDimension;
        this.gridGeometry2D = gridCoverage2D.gridGeometry2D;
    }

    GridCoverage2D(GridCoverage gridCoverage, GridGeometry gridGeometry, GridExtent gridExtent, RenderedImage renderedImage) {
        super(gridCoverage, gridGeometry);
        int[] nArray = gridExtent.getSubspaceDimensions(2);
        this.xDimension = nArray[0];
        this.yDimension = nArray[1];
        this.data = renderedImage = GridCoverage2D.unwrapIfSameSize(renderedImage);
        this.gridToImageX = Math.subtractExact((long)renderedImage.getMinX(), gridExtent.getLow(this.xDimension));
        this.gridToImageY = Math.subtractExact((long)renderedImage.getMinY(), gridExtent.getLow(this.yDimension));
        this.gridGeometry2D = new AtomicReference();
    }

    public GridCoverage2D(GridCoverage gridCoverage, RenderedImage renderedImage) {
        super(gridCoverage, gridCoverage.getGridGeometry());
        int[] nArray;
        ArgumentChecks.ensureNonNull("data", renderedImage);
        this.data = renderedImage = GridCoverage2D.unwrapIfSameSize(renderedImage);
        GridExtent gridExtent = this.gridGeometry.getExtent();
        if (gridCoverage instanceof GridCoverage2D) {
            GridCoverage2D gridCoverage2D = (GridCoverage2D)gridCoverage;
            this.xDimension = gridCoverage2D.xDimension;
            this.yDimension = gridCoverage2D.yDimension;
            this.gridToImageX = gridCoverage2D.gridToImageX;
            this.gridToImageY = gridCoverage2D.gridToImageY;
            this.gridGeometry2D = gridCoverage2D.gridGeometry2D;
            nArray = new int[]{this.xDimension, this.yDimension};
        } else {
            nArray = gridExtent.getSubspaceDimensions(2);
            this.xDimension = nArray[0];
            this.yDimension = nArray[1];
            this.gridToImageX = Math.subtractExact((long)renderedImage.getMinX(), gridExtent.getLow(this.xDimension));
            this.gridToImageY = Math.subtractExact((long)renderedImage.getMinY(), gridExtent.getLow(this.yDimension));
            this.gridGeometry2D = new AtomicReference();
        }
        GridCoverage2D.verifyImageSize(gridExtent, renderedImage, nArray);
        GridCoverage2D.verifyBandCount(super.getSampleDimensions(), renderedImage);
    }

    public GridCoverage2D(GridGeometry gridGeometry, List<? extends SampleDimension> list, RenderedImage renderedImage) {
        int[] nArray;
        renderedImage = GridCoverage2D.unwrapIfSameSize(renderedImage);
        gridGeometry = GridCoverage2D.addExtentIfAbsent(gridGeometry, renderedImage);
        super(gridGeometry, GridCoverage2D.defaultIfAbsent(list, renderedImage, ImageUtilities.getNumBands(renderedImage)));
        this.data = renderedImage;
        ArgumentChecks.ensureNonNull("data", renderedImage);
        GridExtent gridExtent = gridGeometry.getExtent();
        try {
            nArray = gridExtent.getSubspaceDimensions(2);
        }
        catch (CannotEvaluateException cannotEvaluateException) {
            throw new IllegalGridGeometryException(cannotEvaluateException.getMessage(), cannotEvaluateException);
        }
        this.xDimension = nArray[0];
        this.yDimension = nArray[1];
        this.gridToImageX = Math.subtractExact((long)renderedImage.getMinX(), gridExtent.getLow(this.xDimension));
        this.gridToImageY = Math.subtractExact((long)renderedImage.getMinY(), gridExtent.getLow(this.yDimension));
        GridCoverage2D.verifyImageSize(gridExtent, renderedImage, nArray);
        GridCoverage2D.verifyBandCount(list, renderedImage);
        this.gridGeometry2D = new AtomicReference();
    }

    private static RenderedImage unwrapIfSameSize(RenderedImage renderedImage) {
        RenderedImage renderedImage2;
        if (renderedImage instanceof ReshapedImage && (renderedImage2 = ((ReshapedImage)renderedImage).source).getWidth() == renderedImage.getWidth() && renderedImage2.getHeight() == renderedImage.getHeight()) {
            renderedImage = renderedImage2;
        }
        return renderedImage;
    }

    static GridGeometry addExtentIfAbsent(GridGeometry gridGeometry, RenderedImage renderedImage) {
        if (renderedImage != null) {
            gridGeometry = GridCoverage2D.addExtentIfAbsent(gridGeometry, ImageUtilities.getBounds(renderedImage));
        }
        return gridGeometry;
    }

    static GridGeometry addExtentIfAbsent(GridGeometry gridGeometry, Rectangle rectangle) {
        int n;
        if (gridGeometry == null) {
            GridExtent gridExtent = new GridExtent(rectangle);
            gridGeometry = new GridGeometry(gridExtent, PixelInCell.CELL_CENTER, null, null);
        } else if (!gridGeometry.isDefined(4) && (n = gridGeometry.getDimension()) >= 2) {
            CoordinateReferenceSystem coordinateReferenceSystem = null;
            if (gridGeometry.isDefined(1)) {
                coordinateReferenceSystem = gridGeometry.getCoordinateReferenceSystem();
            }
            GridExtent gridExtent = GridCoverage2D.createExtent(n, rectangle, coordinateReferenceSystem);
            if (gridGeometry.isDefined(8)) {
                try {
                    gridGeometry = new GridGeometry(gridGeometry, gridExtent, null);
                }
                catch (TransformException transformException) {
                    throw new IllegalGridGeometryException(transformException);
                }
            } else {
                gridGeometry = new GridGeometry(gridExtent, (Envelope)gridGeometry.envelope, GridOrientation.HOMOTHETY);
            }
        }
        return gridGeometry;
    }

    private static GridExtent createExtent(int n, Rectangle rectangle, CoordinateReferenceSystem coordinateReferenceSystem) {
        long[] lArray = new long[n];
        long[] lArray2 = new long[n];
        lArray[0] = rectangle.x;
        lArray[1] = rectangle.y;
        lArray2[0] = (long)rectangle.width + lArray[0] - 1L;
        lArray2[1] = (long)rectangle.height + lArray[1] - 1L;
        Object[] objectArray = GridExtent.typeFromAxes(coordinateReferenceSystem, n);
        if (objectArray == null) {
            objectArray = new DimensionNameType[n];
        }
        if (!ArraysExt.contains(objectArray, DimensionNameType.COLUMN)) {
            objectArray[0] = DimensionNameType.COLUMN;
        }
        if (!ArraysExt.contains(objectArray, DimensionNameType.ROW)) {
            objectArray[1] = DimensionNameType.ROW;
        }
        return new GridExtent((DimensionNameType[])objectArray, lArray, lArray2, true);
    }

    private static void verifyImageSize(GridExtent gridExtent, RenderedImage renderedImage, int[] nArray) {
        for (int i = 0; i < 2; ++i) {
            long l;
            int n = i == 0 ? renderedImage.getWidth() : renderedImage.getHeight();
            if ((long)n == (l = gridExtent.getSize(nArray[i]))) continue;
            throw new IllegalGridGeometryException(Resources.format((short)44, i, n, l));
        }
    }

    static List<? extends SampleDimension> defaultIfAbsent(List<? extends SampleDimension> list, RenderedImage renderedImage, int n) {
        if (list == null) {
            short[] sArray = renderedImage != null ? ImageUtilities.bandNames(renderedImage.getColorModel(), renderedImage.getSampleModel()) : ArraysExt.EMPTY_SHORT;
            SampleDimension[] sampleDimensionArray = new SampleDimension[n];
            NameFactory nameFactory = DefaultFactories.forBuildin(NameFactory.class);
            for (int i = 0; i < n; ++i) {
                short s;
                InternationalString internationalString = i < sArray.length && (s = sArray[i]) != 0 ? Vocabulary.formatInternational(s) : Vocabulary.formatInternational((short)15, (Object)(i + 1));
                sampleDimensionArray[i] = new SampleDimension((GenericName)nameFactory.createLocalName(null, (CharSequence)internationalString), null, Collections.emptyList());
            }
            list = Arrays.asList(sampleDimensionArray);
        }
        return list;
    }

    private static void verifyBandCount(List<? extends SampleDimension> list, RenderedImage renderedImage) {
        int n;
        int n2;
        SampleModel sampleModel;
        if (list != null && (sampleModel = renderedImage.getSampleModel()) != null && (n2 = sampleModel.getNumBands()) != (n = list.size())) {
            throw new IllegalArgumentException(Resources.format((short)40, n2, n));
        }
    }

    @Override
    final DataType getBandType() {
        return DataType.forBands(this.data);
    }

    public GridGeometry getGridGeometry2D() {
        GridGeometry gridGeometry;
        GridGeometry gridGeometry2 = this.gridGeometry2D.get();
        if (gridGeometry2 == null && !this.gridGeometry2D.compareAndSet(null, gridGeometry2 = this.gridGeometry.reduce(this.xDimension, this.yDimension)) && (gridGeometry = this.gridGeometry2D.get()) != null) {
            return gridGeometry;
        }
        return gridGeometry2;
    }

    @Override
    public synchronized GridCoverage forConvertedValues(boolean bl) {
        GridCoverage2D gridCoverage2D = (GridCoverage2D)this.getView(bl);
        if (gridCoverage2D == null) {
            try {
                List<SampleDimension> list = this.getSampleDimensions();
                ArrayList<SampleDimension> arrayList = new ArrayList<SampleDimension>(list.size());
                MathTransform1D[] mathTransform1DArray = ConvertedGridCoverage.converters(list, arrayList, bl);
                if (mathTransform1DArray != null) {
                    gridCoverage2D = new GridCoverage2D(this, arrayList, mathTransform1DArray, bl);
                    gridCoverage2D.setView(!bl, this);
                } else {
                    gridCoverage2D = this;
                }
                this.setView(bl, gridCoverage2D);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new CannotEvaluateException(noninvertibleTransformException.getMessage(), noninvertibleTransformException);
            }
        }
        return gridCoverage2D;
    }

    @Override
    public GridEvaluator evaluator() {
        return new PixelAccessor();
    }

    @Override
    public RenderedImage render(GridExtent gridExtent) throws CannotEvaluateException {
        int n;
        int n2;
        GridExtent gridExtent2 = this.gridGeometry.extent;
        if (gridExtent == null) {
            if (gridExtent2 == null || this.data.getMinX() == 0 && this.data.getMinY() == 0) {
                return this.data;
            }
            gridExtent = gridExtent2;
        } else {
            n2 = this.gridGeometry.getDimension();
            if (n2 != (n = gridExtent.getDimension())) {
                throw new MismatchedDimensionException(Errors.format((short)81, "sliceExtent", n2, n));
            }
        }
        if (gridExtent2 != null) {
            n2 = Math.min(gridExtent.getDimension(), gridExtent2.getDimension());
            for (n = 0; n < n2; ++n) {
                if (gridExtent.getHigh(n) >= gridExtent2.getLow(n) && gridExtent.getLow(n) <= gridExtent2.getHigh(n)) continue;
                throw new DisjointExtentException(gridExtent2, gridExtent, n);
            }
        }
        try {
            RenderedImage renderedImage;
            long l = Math.addExact(gridExtent.getLow(this.xDimension), this.gridToImageX);
            long l2 = Math.addExact(gridExtent.getLow(this.yDimension), this.gridToImageY);
            long l3 = Math.addExact(gridExtent.getHigh(this.xDimension), this.gridToImageX);
            long l4 = Math.addExact(gridExtent.getHigh(this.yDimension), this.gridToImageY);
            if (this.data instanceof BufferedImage) {
                renderedImage = (BufferedImage)this.data;
                long l5 = ((BufferedImage)renderedImage).getMinX();
                long l6 = ((BufferedImage)renderedImage).getMinY();
                if (l >= l5 && l2 >= l6) {
                    int n3 = ((BufferedImage)renderedImage).getWidth();
                    int n4 = ((BufferedImage)renderedImage).getHeight();
                    int n5 = Math.toIntExact(Math.min(l3, l5 + (long)n3 - 1L) - l + 1L);
                    int n6 = Math.toIntExact(Math.min(l4, l6 + (long)n4 - 1L) - l2 + 1L);
                    if ((l | l2) != 0L || n5 != n3 || n6 != n4) {
                        renderedImage = ((BufferedImage)renderedImage).getSubimage(Math.toIntExact(l), Math.toIntExact(l2), n5, n6);
                    }
                    if ((long)((BufferedImage)renderedImage).getTileGridXOffset() == l5 && (long)((BufferedImage)renderedImage).getTileGridYOffset() == l6) {
                        return renderedImage;
                    }
                }
            }
            return ((ReshapedImage)(renderedImage = new ReshapedImage(this.data, l, l2, l3, l4))).isIdentity() ? this.data : renderedImage;
        }
        catch (ArithmeticException arithmeticException) {
            throw new CannotEvaluateException(arithmeticException.getMessage(), arithmeticException);
        }
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    void appendDataLayout(TreeTable.Node node, Vocabulary vocabulary, TableColumn<CharSequence> tableColumn) {
        TreeTable.Node node2 = node.newChild();
        node2.setValue(tableColumn, vocabulary.getString((short)103));
        NumberFormat numberFormat = NumberFormat.getIntegerInstance(vocabulary.getLocale());
        FieldPosition fieldPosition = new FieldPosition(0);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        block8: while (true) {
            block12: {
                try {
                    switch (n) {
                        case 0: {
                            vocabulary.appendLabel((short)154, stringBuffer);
                            numberFormat.format(this.data.getMinX(), stringBuffer.append(' '), fieldPosition);
                            numberFormat.format(this.data.getMinY(), stringBuffer.append(", "), fieldPosition);
                            break;
                        }
                        case 1: {
                            short s = this.data.getTileWidth();
                            int n2 = this.data.getTileHeight();
                            if (s != this.data.getWidth() || n2 != this.data.getHeight()) {
                                vocabulary.appendLabel((short)194, stringBuffer);
                                numberFormat.format(s, stringBuffer.append(' '), fieldPosition);
                                numberFormat.format(n2, stringBuffer.append(" \u00d7 "), fieldPosition);
                                break;
                            }
                            break block12;
                        }
                        case 2: {
                            String string = ImageUtilities.getDataTypeName(this.data.getSampleModel());
                            if (string != null) {
                                vocabulary.appendLabel((short)51, stringBuffer);
                                stringBuffer.append(' ').append(string);
                                break;
                            }
                            break block12;
                        }
                        case 3: {
                            short s = ImageUtilities.getTransparencyDescription(this.data.getColorModel());
                            if (s != 0) {
                                String string = Resources.forLocale(vocabulary.getLocale()).getString(s);
                                node2.newChild().setValue(tableColumn, string);
                            }
                            break block12;
                        }
                        default: {
                            break block8;
                        }
                    }
                    node2.newChild().setValue(tableColumn, stringBuffer.toString());
                    stringBuffer.setLength(0);
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(iOException);
                }
            }
            ++n;
        }
    }

    private final class PixelAccessor
    extends GridEvaluator {
        PixelAccessor() {
            super(GridCoverage2D.this);
        }

        @Override
        public double[] apply(DirectPosition directPosition) throws CannotEvaluateException {
            try {
                FractionalGridCoordinates.Position position = this.toGridPosition(directPosition);
                try {
                    int n = Math.toIntExact(Math.addExact(position.getCoordinateValue(GridCoverage2D.this.xDimension), GridCoverage2D.this.gridToImageX));
                    int n2 = Math.toIntExact(Math.addExact(position.getCoordinateValue(GridCoverage2D.this.yDimension), GridCoverage2D.this.gridToImageY));
                    return this.evaluate(GridCoverage2D.this.data, n, n2);
                }
                catch (ArithmeticException | IndexOutOfBoundsException | DisjointExtentException runtimeException) {
                    if (this.isNullIfOutside()) {
                        return null;
                    }
                    throw (PointOutsideCoverageException)new PointOutsideCoverageException(position.pointOutsideCoverage(GridCoverage2D.this.gridGeometry.extent)).initCause(runtimeException);
                }
            }
            catch (PointOutsideCoverageException pointOutsideCoverageException) {
                throw pointOutsideCoverageException;
            }
            catch (RuntimeException | TransformException throwable) {
                throw new CannotEvaluateException(throwable.getMessage(), throwable);
            }
        }
    }
}

