import { CancellationToken } from 'vscode-languageserver-protocol';
import { WorkspaceSymbol } from 'vscode-languageserver-types';
import { LSConfigManager } from '../../../ls-config';
import { WorkspaceSymbolsProvider } from '../../interfaces';
import { LSAndTSDocResolver } from '../LSAndTSDocResolver';
export declare class WorkspaceSymbolsProviderImpl implements WorkspaceSymbolsProvider {
    constructor(lsAndTsDocResolver: LSAndTSDocResolver, configManager: LSConfigManager);
    private readonly configManager;
    private readonly lsAndTsDocResolver;
    getWorkspaceSymbols(query: string, cancellationToken?: CancellationToken): Promise<WorkspaceSymbol[] | null>;
    private isGeneratedName;
    private mapWorkspaceSymbol;
    /**
     *
     * https://github.com/microsoft/TypeScript/blob/81c951894e93bdc37c6916f18adcd80de76679bc/src/server/session.ts#L2878
     */
    private navigateToItemIsEqualTo;
    /**
     * Don't reuse our symbolKindFromString function, this should the same as the one in vscode
     * so that vscode deduplicate the symbols from svelte and the typescript server.
     * https://github.com/microsoft/vscode/blob/18ed64835ec8f8227dbd8562d2d9fd9fa339abbb/extensions/typescript-language-features/src/languageFeatures/workspaceSymbols.ts#L17
     */
    private convertSymbolKindForWorkspaceSymbol;
    private getLabel;
}
