/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette.customize;

import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.ui.palette.PaletteMessages;
import org.eclipse.gef.ui.palette.customize.DefaultEntryPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DrawerEntryPage
extends DefaultEntryPage {
    private Button openDrawerOption;
    private Button pinDrawerOption;

    private static boolean contains(Object[] array, Object obj) {
        int i = array.length - 1;
        while (i >= 0) {
            if (obj == array[i]) {
                return true;
            }
            --i;
        }
        return false;
    }

    @Override
    public void createControl(Composite parent, PaletteEntry entry) {
        super.createControl(parent, entry);
        this.openDrawerOption = this.createOpenDrawerInitiallyOption(this.getComposite());
        this.pinDrawerOption = this.createPinDrawerInitiallyOption(this.getComposite());
        Object[] oldTablist = this.getComposite().getTabList();
        if (!DrawerEntryPage.contains(oldTablist, this.openDrawerOption)) {
            Control[] newTablist = new Control[oldTablist.length + 2];
            System.arraycopy(oldTablist, 0, newTablist, 0, oldTablist.length);
            newTablist[newTablist.length - 2] = this.openDrawerOption;
            newTablist[newTablist.length - 1] = this.pinDrawerOption;
            this.getComposite().setTabList(newTablist);
        }
    }

    protected Button createOpenDrawerInitiallyOption(Composite panel) {
        Button b = new Button(panel, 32);
        b.setFont(panel.getFont());
        b.setText(PaletteMessages.EXPAND_DRAWER_AT_STARTUP_LABEL);
        b.setSelection(this.getDrawer().isInitiallyOpen());
        if (this.getPermission() >= 7) {
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DrawerEntryPage.this.handleOpenSelected(((Button)e.getSource()).getSelection());
                }
            });
        } else {
            b.setEnabled(false);
        }
        return b;
    }

    protected Button createPinDrawerInitiallyOption(Composite panel) {
        Button pinOption = new Button(panel, 32);
        pinOption.setFont(panel.getFont());
        pinOption.setText(PaletteMessages.DRAWER_PIN_AT_STARTUP);
        GridData data = new GridData();
        data.horizontalIndent = 15;
        pinOption.setLayoutData((Object)data);
        pinOption.setEnabled(this.openDrawerOption.getSelection() && this.openDrawerOption.isEnabled());
        pinOption.setSelection(this.getDrawer().isInitiallyPinned());
        if (this.getPermission() >= 7) {
            pinOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DrawerEntryPage.this.handlePinSelected(((Button)e.getSource()).getSelection());
                }
            });
        }
        return pinOption;
    }

    private Composite getComposite() {
        return (Composite)this.getControl();
    }

    protected PaletteDrawer getDrawer() {
        return (PaletteDrawer)this.getEntry();
    }

    protected Button getOpenDrawerInitiallyButton() {
        return this.openDrawerOption;
    }

    protected Button getPinDrawerInitiallyButton() {
        return this.pinDrawerOption;
    }

    protected void handleOpenSelected(boolean selection) {
        int status = selection ? 0 : 1;
        this.getDrawer().setInitialState(status);
        this.pinDrawerOption.setEnabled(selection);
        if (!selection) {
            this.pinDrawerOption.setSelection(false);
        }
    }

    protected void handlePinSelected(boolean selection) {
        int status = selection ? 2 : 0;
        this.getDrawer().setInitialState(status);
    }
}

