/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.freeplane.core.util.Compat;
import org.freeplane.main.application.CommandLineOptions;

public class CommandLineParser {
    public static CommandLineOptions parse(String ... args) {
        int i;
        CommandLineParserOptions result = new CommandLineParserOptions();
        if (args == null || args.length == 0 || !args[0].startsWith("-")) {
            result.setFilesToOpen(args);
            return result;
        }
        String[] mutableArgs = new String[args.length];
        System.arraycopy(args, 0, mutableArgs, 0, args.length);
        args = mutableArgs;
        for (i = 0; i != args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-S")) {
                result.setStopAfterLaunch(true);
                if (arg.length() <= 2) continue;
                args[i] = "-" + arg.substring(2);
                --i;
                continue;
            }
            if (arg.startsWith("-N")) {
                result.nonInteractive = true;
                if (arg.length() <= 2) continue;
                args[i] = "-" + arg.substring(2);
                --i;
                continue;
            }
            if (arg.startsWith("-X")) {
                if (arg.length() > 2) {
                    result.addMenuItemToExecute(arg.substring(2));
                    continue;
                }
                if (args.length <= i + 1) continue;
                result.addMenuItemToExecute(args[++i]);
                continue;
            }
            if (arg.startsWith("-R")) {
                if (arg.length() > 2) {
                    result.addScriptToExecute(arg.substring(2));
                    continue;
                }
                if (args.length <= i + 1) continue;
                result.addScriptToExecute(args[++i]);
                continue;
            }
            if (arg.startsWith("-U")) {
                String userdir = null;
                if (arg.length() > 2) {
                    userdir = arg.substring(2);
                } else if (args.length > i + 1) {
                    userdir = args[++i];
                } else {
                    System.err.println("option -U<userdir> misses its parameter");
                }
                if (userdir == null) continue;
                System.setProperty("org.freeplane.userfpdir", userdir);
                System.setProperty("org.freeplane.old_userfpdir", userdir);
                continue;
            }
            if (arg.startsWith("-h")) {
                result.setHelpRequested(true);
                if (arg.length() <= 2) continue;
                args[i] = "-" + arg.substring(2);
                --i;
                continue;
            }
            if (!arg.equals("--help")) break;
            result.setHelpRequested(true);
        }
        while (i != args.length) {
            result.addFilesToOpen(args[i]);
            ++i;
        }
        if (result.isHelpRequested()) {
            System.out.println(result.getHelpMessage());
            System.exit(0);
        }
        return result;
    }

    private static class CommandLineParserOptions
    implements CommandLineOptions {
        private static final String HELP_MESSAGE = "\nUsage:\n\tfreeplane.bat [options] [file1 [file2 ...]]\n\n -X<menukey>   : execute menu item with key <menukey> (ignored in non interactive mode).\n                 hint: use devtools add-on to find appropriate menu keys\n -R<file>      : execute script by path <file>.\n -S            : stop after executing menu items and scripts\n -N            : set the 'nonInteractive' system property to 'true'\n -U<userdir>   : set the freeplane user config directory (default: " + Compat.getDefaultFreeplaneUserDirectory() + ")\n -h , --help   : print this help text";
        private List<String> filesToOpen = new ArrayList<String>();
        private List<String> menuItemsToExecute = new ArrayList<String>();
        private List<String> scriptsToExecute = new ArrayList<String>();
        private boolean stopAfterLaunch;
        private boolean nonInteractive;
        private boolean helpRequested = false;

        private CommandLineParserOptions() {
        }

        private void setFilesToOpen(String[] filesToOpen) {
            this.filesToOpen = Arrays.asList(filesToOpen);
        }

        @Override
        public boolean shouldStopAfterLaunch() {
            return this.stopAfterLaunch;
        }

        private void setStopAfterLaunch(boolean stopAfterLaunch) {
            this.stopAfterLaunch = stopAfterLaunch;
        }

        @Override
        public String[] getFilesToOpenAsArray() {
            return this.filesToOpen.toArray(new String[this.filesToOpen.size()]);
        }

        @Override
        public List<String> getMenuItemsToExecute() {
            return this.menuItemsToExecute;
        }

        @Override
        public List<String> getScriptsToExecute() {
            return this.scriptsToExecute;
        }

        @Override
        public boolean hasItemsToExecute() {
            return !this.menuItemsToExecute.isEmpty() || !this.scriptsToExecute.isEmpty();
        }

        private void addFilesToOpen(String file) {
            this.filesToOpen.add(file);
        }

        private void addMenuItemToExecute(String item) {
            this.menuItemsToExecute.add(item);
        }

        private void addScriptToExecute(String item) {
            this.scriptsToExecute.add(item);
        }

        @Override
        public boolean isNonInteractive() {
            return this.nonInteractive;
        }

        private boolean isHelpRequested() {
            return this.helpRequested;
        }

        private void setHelpRequested(boolean helpRequested) {
            this.helpRequested = helpRequested;
        }

        public String toString() {
            return "Options(files: " + this.filesToOpen + ", menuItems: " + this.menuItemsToExecute + ", scripts: " + this.scriptsToExecute + ", stopAfterLaunch: " + this.stopAfterLaunch + ", nonInteractive: " + this.nonInteractive + ")";
        }

        private String getHelpMessage() {
            return HELP_MESSAGE;
        }
    }
}

