/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.FontFace;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.FontFaceRule;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueManager;
import io.sf.carte.echosvg.gvt.font.GVTFontFamily;
import io.sf.carte.echosvg.util.ParsedURL;
import io.sf.carte.echosvg.util.SVGConstants;
import java.util.LinkedList;
import java.util.List;

public class CSSFontFace
extends FontFace
implements SVGConstants {
    GVTFontFamily fontFamily = null;

    public CSSFontFace(List<Object> srcs, String familyName, float unitsPerEm, String fontWeight, String fontStyle, String fontVariant, String fontStretch, float slope, String panose1, float ascent, float descent, float strikethroughPosition, float strikethroughThickness, float underlinePosition, float underlineThickness, float overlinePosition, float overlineThickness) {
        super(srcs, familyName, unitsPerEm, fontWeight, fontStyle, fontVariant, fontStretch, slope, panose1, ascent, descent, strikethroughPosition, strikethroughThickness, underlinePosition, underlineThickness, overlinePosition, overlineThickness);
    }

    protected CSSFontFace(String familyName) {
        super(familyName);
    }

    public static CSSFontFace createCSSFontFace(CSSEngine eng, FontFaceRule ffr) {
        StyleMap sm = ffr.getStyleMap();
        String familyName = CSSFontFace.getStringProp(sm, eng, 20);
        CSSFontFace ret = new CSSFontFace(familyName);
        Value v = sm.getValue(26);
        if (v != null) {
            ret.fontWeight = v.getCssText();
        }
        if ((v = sm.getValue(24)) != null) {
            ret.fontStyle = v.getCssText();
        }
        if ((v = sm.getValue(25)) != null) {
            ret.fontVariant = v.getCssText();
        }
        if ((v = sm.getValue(23)) != null) {
            ret.fontStretch = v.getCssText();
        }
        v = sm.getValue(45);
        ParsedURL base = ffr.getURL();
        if (v != null && !v.isIdentifier("none")) {
            if (v.getCssValueType() == CSSValue.CssType.TYPED) {
                ret.srcs = new LinkedList();
                ret.srcs.add(CSSFontFace.getSrcValue(v, base));
            } else if (v.getCssValueType() == CSSValue.CssType.LIST) {
                ret.srcs = new LinkedList();
                for (int i = 0; i < v.getLength(); ++i) {
                    ret.srcs.add(CSSFontFace.getSrcValue(v.item(i), base));
                }
            }
        }
        return ret;
    }

    public static Object getSrcValue(Value v, ParsedURL base) {
        if (v.getPrimitiveType() == CSSValue.Type.URI) {
            if (base != null) {
                return new ParsedURL(base, v.getURIValue());
            }
            return new ParsedURL(v.getURIValue());
        }
        if (v.getPrimitiveType() == CSSValue.Type.STRING) {
            return v.getStringValue();
        }
        return null;
    }

    public static String getStringProp(StyleMap sm, CSSEngine eng, int pidx) {
        Value v = sm.getValue(pidx);
        ValueManager[] vms = eng.getValueManagers();
        if (v == null) {
            ValueManager vm = vms[pidx];
            v = vm.getDefaultValue();
        }
        while (v.getCssValueType() == CSSValue.CssType.LIST) {
            v = v.item(0);
        }
        return v.getStringValue();
    }

    public static float getFloatProp(StyleMap sm, CSSEngine eng, int pidx) {
        Value v = sm.getValue(pidx);
        ValueManager[] vms = eng.getValueManagers();
        if (v == null) {
            ValueManager vm = vms[pidx];
            v = vm.getDefaultValue();
        }
        while (v.getCssValueType() == CSSValue.CssType.LIST) {
            v = v.item(0);
        }
        return v.getFloatValue();
    }

    @Override
    public GVTFontFamily getFontFamily(BridgeContext ctx) {
        if (this.fontFamily != null) {
            return this.fontFamily;
        }
        this.fontFamily = super.getFontFamily(ctx);
        return this.fontFamily;
    }
}

