/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.lzss;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class LzssCodec {
    public static final int N = 4096;
    public static final int F = 18;
    public static final int THRESHOLD = 2;
    public static final int NIL = 4096;

    static int unsigned(byte b) {
        return b < 0 ? b + 256 : b;
    }

    /*
     * Unable to fully structure code
     */
    public static void decompress(OutputStream dst, InputStream src) throws IOException {
        textBuf = ByteBuffer.allocate(4113);
        for (i = 0; i < 4078; ++i) {
            textBuf.put((byte)32);
        }
        textBuf.position(4078);
        flags = 0;
        block1: while (true) {
            if (((flags >>>= 1) & 256) == 0) {
                c = src.read();
                if (c == -1) break;
                flags = c | 65280;
            }
            if ((flags & 1) != 0) {
                c = src.read();
                if (c == -1) break;
                dst.write(c);
                textBuf.put((byte)c);
                textBuf.position(textBuf.position() & 4095);
                continue;
            }
            i = src.read();
            if (i == -1 || (j = src.read()) == -1) break;
            i |= (j & 240) << 4;
            j = (j & 15) + 2;
            k = 0;
            while (true) {
                if (k <= j) ** break;
                continue block1;
                c = textBuf.get(i + k & 4095);
                dst.write(c);
                textBuf.put(c);
                textBuf.position(textBuf.position() & 4095);
                ++k;
            }
            break;
        }
        dst.flush();
    }

    public static void compress(OutputStream dst, InputStream src) throws IOException {
        int i;
        int b;
        int len;
        ByteBuffer codeBuf = ByteBuffer.allocate(17);
        EncodeState sp = new EncodeState();
        codeBuf.put((byte)0);
        byte mask = 1;
        int s = 0;
        int r = 4078;
        for (len = 0; len < 18 && (b = src.read()) != -1; ++len) {
            sp.textBuf.put(r + len, (byte)b);
        }
        if (len == 0) {
            return;
        }
        for (i = 1; i <= 18; ++i) {
            sp.insertNode(r - i);
        }
        sp.insertNode(r);
        do {
            int c;
            if (sp.matchLength > len) {
                sp.matchLength = len;
            }
            if (sp.matchLength <= 2) {
                sp.matchLength = 1;
                codeBuf.put(0, (byte)(codeBuf.get(0) | mask));
                codeBuf.put(sp.textBuf.get(r));
            } else {
                codeBuf.put((byte)sp.matchPosition);
                codeBuf.put((byte)(sp.matchPosition >> 4 & 0xF0 | sp.matchLength - 3));
            }
            mask = (byte)(mask << 1);
            if (mask == 0) {
                dst.write(codeBuf.array(), 0, codeBuf.position());
                codeBuf.clear();
                codeBuf.put((byte)0);
                mask = 1;
            }
            int lastMatchLength = sp.matchLength;
            for (i = 0; i < lastMatchLength && (c = src.read()) != -1; ++i) {
                sp.deleteNode(s);
                sp.textBuf.put(s, (byte)c);
                if (s < 17) {
                    sp.textBuf.put(s + 4096, (byte)c);
                }
                s = s + 1 & 0xFFF;
                r = r + 1 & 0xFFF;
                sp.insertNode(r);
            }
            while (i++ < lastMatchLength) {
                sp.deleteNode(s);
                s = s + 1 & 0xFFF;
                r = r + 1 & 0xFFF;
                if (--len == 0) continue;
                sp.insertNode(r);
            }
        } while (len > 0);
        if (codeBuf.position() > 1) {
            dst.write(codeBuf.array(), 0, codeBuf.position());
        }
        dst.flush();
    }

    private static class EncodeState {
        int[] lchild = new int[4097];
        int[] rchild = new int[4353];
        int[] parent = new int[4097];
        ByteBuffer textBuf = ByteBuffer.allocate(4113);
        int matchPosition;
        int matchLength;

        public EncodeState() {
            int i;
            for (i = 0; i < 4078; ++i) {
                this.textBuf.put((byte)32);
            }
            for (i = 4097; i <= 4352; ++i) {
                this.rchild[i] = 4096;
            }
            for (i = 0; i < 4096; ++i) {
                this.parent[i] = 4096;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void insertNode(int r) {
            int cmp = 1;
            int p = 4097 + LzssCodec.unsigned(this.textBuf.get(r));
            this.lchild[r] = 4096;
            this.rchild[r] = 4096;
            this.matchLength = 0;
            while (true) {
                int i;
                if (cmp >= 0) {
                    if (this.rchild[p] == 4096) {
                        this.rchild[p] = r;
                        this.parent[r] = p;
                        return;
                    }
                    p = this.rchild[p];
                } else {
                    if (this.lchild[p] == 4096) {
                        this.lchild[p] = r;
                        this.parent[r] = p;
                        return;
                    }
                    p = this.lchild[p];
                }
                for (i = 1; i < 18 && (cmp = LzssCodec.unsigned(this.textBuf.get(r + i)) - LzssCodec.unsigned(this.textBuf.get(p + i))) == 0; ++i) {
                }
                if (i <= this.matchLength) continue;
                this.matchPosition = p;
                this.matchLength = i;
                if (this.matchLength >= 18) break;
            }
            this.parent[r] = this.parent[p];
            this.lchild[r] = this.lchild[p];
            this.rchild[r] = this.rchild[p];
            this.parent[this.lchild[p]] = r;
            this.parent[this.rchild[p]] = r;
            if (this.rchild[this.parent[p]] == p) {
                this.rchild[this.parent[p]] = r;
            } else {
                this.lchild[this.parent[p]] = r;
            }
            this.parent[p] = 4096;
        }

        void deleteNode(int p) {
            int q;
            if (this.parent[p] == 4096) {
                return;
            }
            if (this.rchild[p] == 4096) {
                q = this.lchild[p];
            } else if (this.lchild[p] == 4096) {
                q = this.rchild[p];
            } else {
                q = this.lchild[p];
                if (this.rchild[q] != 4096) {
                    while (this.rchild[q = this.rchild[q]] != 4096) {
                    }
                    this.rchild[this.parent[q]] = this.lchild[q];
                    this.parent[this.lchild[q]] = this.parent[q];
                    this.lchild[q] = this.lchild[p];
                    this.parent[this.lchild[p]] = q;
                }
                this.rchild[q] = this.rchild[p];
                this.parent[this.rchild[p]] = q;
            }
            this.parent[q] = this.parent[p];
            if (this.rchild[this.parent[p]] == p) {
                this.rchild[this.parent[p]] = q;
            } else {
                this.lchild[this.parent[p]] = q;
            }
            this.parent[p] = 4096;
        }
    }
}

