/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer;

import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.catacombae.hfsexplorer.fs.BaseHFSFileSystemView;
import org.catacombae.hfsexplorer.gui.CatalogInfoPanel;
import org.catacombae.hfsexplorer.gui.ExtentsInfoPanel;
import org.catacombae.hfsexplorer.gui.HFSPlusVolumeInfoPanel;
import org.catacombae.hfsexplorer.gui.JournalInfoPanel;
import org.catacombae.hfsexplorer.gui.StructViewPanel;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSVolumeHeader;
import org.catacombae.hfsexplorer.types.hfsplus.JournalInfoBlock;

public class VolumeInfoWindow
extends JFrame {
    public VolumeInfoWindow(BaseHFSFileSystemView fsView) {
        super("File system info");
        JTabbedPane tabs = new JTabbedPane();
        try {
            CommonHFSVolumeHeader volHeader = fsView.getVolumeHeader();
            JPanel volumeInfoPanel = volHeader instanceof CommonHFSVolumeHeader.HFSPlusImplementation ? new HFSPlusVolumeInfoPanel(((CommonHFSVolumeHeader.HFSPlusImplementation)volHeader).getUnderlying()) : new StructViewPanel("Volume header", volHeader.getStructElements());
            JScrollPane volumeInfoPanelScroller = new JScrollPane(volumeInfoPanel, 20, 31);
            tabs.addTab("Volume header", volumeInfoPanelScroller);
            volumeInfoPanelScroller.getVerticalScrollBar().setUnitIncrement(10);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            CatalogInfoPanel catalogInfoPanel = new CatalogInfoPanel(fsView);
            JScrollPane catalogInfoPanelScroller = new JScrollPane(catalogInfoPanel, 20, 31);
            tabs.addTab("Catalog file", catalogInfoPanelScroller);
            catalogInfoPanelScroller.getVerticalScrollBar().setUnitIncrement(10);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ExtentsInfoPanel extentsInfoPanel = new ExtentsInfoPanel(fsView);
            JScrollPane scroller = new JScrollPane(extentsInfoPanel, 20, 31);
            tabs.addTab("Extents overflow file", scroller);
            scroller.getVerticalScrollBar().setUnitIncrement(10);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            JournalInfoBlock jib = fsView.getJournalInfoBlock();
            if (jib != null) {
                JournalInfoPanel journalInfoPanel = new JournalInfoPanel(jib);
                JScrollPane journalInfoPanelScroller = new JScrollPane(journalInfoPanel, 20, 31);
                tabs.addTab("Journal", journalInfoPanelScroller);
                journalInfoPanelScroller.getVerticalScrollBar().setUnitIncrement(10);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.add((Component)tabs, "Center");
        this.setDefaultCloseOperation(2);
        this.pack();
        int width = this.getSize().width;
        int height = this.getSize().height;
        int adjustedHeight = width + width / 2;
        if (adjustedHeight < height) {
            this.setSize(width, adjustedHeight);
        }
        this.setLocationRelativeTo(null);
    }
}

