/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.correlate;

import generic.hash.SimpleCRC32;
import ghidra.program.model.address.Address;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.correlate.Block;
import ghidra.program.model.correlate.DisambiguateStrategy;
import ghidra.program.model.correlate.Hash;
import ghidra.program.model.correlate.HashStore;
import ghidra.program.model.correlate.InstructHash;
import ghidra.util.exception.CancelledException;
import java.util.ArrayList;

public class DisambiguateByParentWithOrder
implements DisambiguateStrategy {
    @Override
    public ArrayList<Hash> calcHashes(InstructHash instHash, int matchSize, HashStore store) throws CancelledException {
        ArrayList<Hash> res = new ArrayList<Hash>();
        Block block = instHash.getBlock();
        CodeBlockReferenceIterator iter = block.origBlock.getSources(store.getMonitor());
        Address startAddr = block.origBlock.getMinAddress();
        while (iter.hasNext()) {
            CodeBlockReference ref = iter.next();
            Block srcBlock = store.getBlock(ref.getSourceAddress());
            if (srcBlock == null || srcBlock.getMatchHash() == 0) continue;
            CodeBlockReferenceIterator srcIter = srcBlock.origBlock.getDestinations(store.getMonitor());
            int totalcount = 0;
            int count = 0;
            while (srcIter.hasNext()) {
                Address addr = srcIter.next().getDestinationAddress();
                ++totalcount;
                if (addr.compareTo(startAddr) >= 0) continue;
                ++count;
            }
            if (totalcount <= 1) continue;
            count = SimpleCRC32.hashOneByte((int)srcBlock.getMatchHash(), (int)count);
            res.add(new Hash(count, 1));
        }
        return res;
    }
}

