/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.gotoquery;

import docking.ComponentProvider;
import ghidra.app.nav.LocationMemento;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigatableRegistry;
import ghidra.app.plugin.core.gotoquery.GoToServicePlugin;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public class DefaultNavigatableLocationMemento
extends LocationMemento {
    private final Map<Navigatable, LocationMemento> mementos = new HashMap<Navigatable, LocationMemento>();
    private Navigatable focusedNavigatable;

    public DefaultNavigatableLocationMemento(Program program, ProgramLocation location, PluginTool tool) {
        super(program, location);
        ComponentProvider activeProvider = tool.getActiveComponentProvider();
        List<Navigatable> navigatables = NavigatableRegistry.getRegisteredNavigatables(tool);
        for (Navigatable navigatable : navigatables) {
            LocationMemento memento;
            if (navigatable instanceof GoToServicePlugin.DefaultNavigatable || !navigatable.isConnected() || !navigatable.isVisible()) continue;
            if (navigatable == activeProvider) {
                this.focusedNavigatable = navigatable;
            }
            if (!(memento = navigatable.getMemento()).isValid()) continue;
            this.mementos.put(navigatable, memento);
        }
    }

    public DefaultNavigatableLocationMemento(SaveState saveState, Program[] programs) {
        super(saveState, programs);
        long navID = saveState.getLong("FOCUSED_NAV", 0L);
        this.focusedNavigatable = NavigatableRegistry.getNavigatable(navID);
        int count = saveState.getInt("NUM_MEMENTOS", 0);
        for (int i = 0; i < count; ++i) {
            Element element = saveState.getXmlElement("MEMENTO" + i);
            if (element == null) continue;
            SaveState navState = new SaveState(element);
            navID = navState.getLong("NAV_ID", 0L);
            Navigatable nav = NavigatableRegistry.getNavigatable(navID);
            LocationMemento memento = LocationMemento.getLocationMemento(navState, programs);
            if (nav == null || memento == null) continue;
            this.mementos.put(nav, memento);
        }
    }

    public Navigatable getFocusedNavigatable() {
        return this.focusedNavigatable;
    }

    public void setMementos() {
        for (Navigatable navigatable : this.mementos.keySet()) {
            if (!navigatable.isVisible()) continue;
            LocationMemento memento = this.mementos.get(navigatable);
            navigatable.setMemento(memento);
        }
    }

    @Override
    public void saveState(SaveState saveState) {
        super.saveState(saveState);
        saveState.putInt("NUM_MEMENTOS", this.mementos.size());
        if (this.focusedNavigatable != null) {
            saveState.putLong("FOCUSED_NAV", this.focusedNavigatable.getInstanceID());
        }
        int index = 0;
        for (Navigatable navigatable : this.mementos.keySet()) {
            LocationMemento memento = this.mementos.get(navigatable);
            SaveState mementoSaveState = new SaveState();
            mementoSaveState.putLong("NAV_ID", navigatable.getInstanceID());
            memento.saveState(mementoSaveState);
            Element element = mementoSaveState.saveToXml();
            saveState.putXmlElement("MEMENTO" + index, element);
            ++index;
        }
    }
}

