/*
 * Decompiled with CFR 0.152.
 */
package git4idea.gpg;

import externalApp.ExternalApp;
import git4idea.gpg.CryptoUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PublicKey;

public final class PinentryApp
implements ExternalApp {
    public static void main(String[] args) throws IOException, URISyntaxException {
        boolean shouldLog = PinentryApp.isLogEnabled(args);
        File logFile = PinentryApp.getCurrentDir().resolve("pinentry-app.log").toFile();
        File exceptionsLogFile = PinentryApp.getCurrentDir().resolve("pinentry-app-exceptions.log").toFile();
        try (FileWriter exceptionsWriter = shouldLog ? new FileWriter(exceptionsLogFile, StandardCharsets.UTF_8) : null;){
            try (FileWriter logWriter = shouldLog ? new FileWriter(logFile, StandardCharsets.UTF_8) : null;
                 BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
                 BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));){
                writer.write("OK Pleased to meet you\n");
                writer.flush();
                String keyDescription = null;
                while (true) {
                    String line = reader.readLine();
                    if (shouldLog) {
                        logWriter.write(line + "\n");
                    }
                    if (line.startsWith("SETDESC")) {
                        keyDescription = line;
                        writer.write("OK\n");
                    } else if (line.startsWith("OPTION") || line.startsWith("GETINFO") || line.startsWith("SET")) {
                        writer.write("OK\n");
                    } else if (line.startsWith("GETPIN")) {
                        try {
                            int port;
                            String host;
                            PublicKey publicKey;
                            String[] pinentryData;
                            String pinentryUserData = System.getenv("PINENTRY_USER_DATA");
                            if (pinentryUserData == null) {
                                pinentryUserData = "";
                            }
                            if ((pinentryData = (pinentryUserData = pinentryUserData.replace("IJ_PINENTRY=", "")).split(":")).length != 3) {
                                if (shouldLog) {
                                    exceptionsWriter.write("Cannot locate address (<public-key>:<host>:<port>) from env variable PINENTRY_USER_DATA. Got " + pinentryUserData + "\n");
                                }
                                throw new Exception();
                            }
                            try {
                                String publicKeyStr = pinentryData[0];
                                publicKey = CryptoUtils.stringToPublicKey(publicKeyStr);
                                host = pinentryData[1];
                                port = Integer.parseInt(pinentryData[2]);
                            }
                            catch (Exception e) {
                                if (shouldLog) {
                                    exceptionsWriter.write("Cannot parse env variable PINENTRY_USER_DATA. Got " + pinentryUserData + "\n");
                                    exceptionsWriter.write(PinentryApp.getStackTrace(e) + "\n");
                                }
                                throw e;
                            }
                            try (Socket clientSocket = new Socket(host, port);
                                 BufferedWriter socketWriter = new BufferedWriter(new OutputStreamWriter(clientSocket.getOutputStream(), StandardCharsets.UTF_8));
                                 BufferedReader socketReader = new BufferedReader(new InputStreamReader(clientSocket.getInputStream(), StandardCharsets.UTF_8));){
                                Object request = keyDescription != null ? "GETPIN " + keyDescription + "\n" : "GETPIN\n";
                                socketWriter.write((String)request);
                                socketWriter.flush();
                                String response = socketReader.readLine();
                                if (response.startsWith("D ")) {
                                    String passphrase = CryptoUtils.decrypt(response.replace("D ", ""), publicKey);
                                    writer.write("D " + passphrase + "\n");
                                    writer.write("OK\n");
                                } else {
                                    writer.write("ERR 83886179 unknown command<" + response + ">\n");
                                }
                            }
                        }
                        catch (Exception e) {
                            if (shouldLog) {
                                exceptionsWriter.write("Exception occurred: \n");
                                exceptionsWriter.write(PinentryApp.getStackTrace(e));
                                exceptionsWriter.flush();
                            }
                            writer.write("ERR 83886180 exception\n");
                        }
                    } else {
                        if (line.startsWith("BYE")) {
                            writer.write("OK closing connection\n");
                            writer.flush();
                            break;
                        }
                        writer.write("ERR 83886181 unknown command <" + line + ">\n");
                    }
                    writer.flush();
                    if (!shouldLog) continue;
                    logWriter.flush();
                    exceptionsWriter.flush();
                }
            }
            catch (IOException e) {
                if (shouldLog) {
                    exceptionsWriter.write("Exception occurred: \n");
                    exceptionsWriter.write(PinentryApp.getStackTrace(e));
                    exceptionsWriter.flush();
                }
            }
        }
    }

    private static boolean isLogEnabled(String[] args) {
        for (String arg : args) {
            if (!arg.equals("--log")) continue;
            return true;
        }
        return false;
    }

    private static Path getCurrentDir() throws URISyntaxException {
        URI jarPath = PinentryApp.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        return Paths.get(jarPath).getParent();
    }

    private static String getStackTrace(Exception e) {
        StringBuilder sb = new StringBuilder(1000);
        StackTraceElement[] st = e.getStackTrace();
        sb.append(e.getClass().getName()).append(": ").append(e.getMessage()).append("\n");
        for (StackTraceElement element : st) {
            sb.append("\t at ").append(element.toString()).append("\n");
        }
        return sb.toString();
    }
}

