/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemTelemetryUtil;
import com.intellij.openapi.externalSystem.util.OutputWrapper;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.JavaVersion;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Function;
import org.gradle.api.logging.LogLevel;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.connection.GradleConnectorService;
import org.jetbrains.plugins.gradle.execution.target.TargetModelBuilder;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.properties.GradleProperties;
import org.jetbrains.plugins.gradle.properties.GradlePropertiesFile;
import org.jetbrains.plugins.gradle.service.execution.GradleCommandLineUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleDaemonJvmHelper;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionContext;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionContextImpl;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleProgressListener;
import org.jetbrains.plugins.gradle.service.execution.SystemPropertiesAdjuster;
import org.jetbrains.plugins.gradle.service.execution.cmd.GradleCommandLineOptionsProvider;
import org.jetbrains.plugins.gradle.service.project.GradleExecutionHelperExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLine;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineOption;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineTask;

@ApiStatus.Internal
public final class GradleExecutionHelper {
    private static final Logger LOG = Logger.getInstance(GradleExecutionHelper.class);

    @Deprecated
    public GradleExecutionHelper() {
    }

    @Deprecated
    @NotNull
    public BuildLauncher getBuildLauncher(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId id, @NotNull List<String> tasksAndArguments, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(0);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(1);
        }
        if (tasksAndArguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(3);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(4);
        }
        BuildLauncher operation = connection.newBuild();
        GradleExecutionHelper.prepare(connection, (LongRunningOperation)operation, id, tasksAndArguments, settings, listener2);
        BuildLauncher buildLauncher = operation;
        if (buildLauncher == null) {
            GradleExecutionHelper.$$$reportNull$$$0(5);
        }
        return buildLauncher;
    }

    @Deprecated
    @NotNull
    public TestLauncher getTestLauncher(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId id, @NotNull List<String> tasksAndArguments, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(6);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(7);
        }
        if (tasksAndArguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(9);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(10);
        }
        TestLauncher operation = connection.newTestLauncher();
        GradleExecutionHelper.prepare(connection, (LongRunningOperation)operation, id, tasksAndArguments, settings, listener2);
        TestLauncher testLauncher = operation;
        if (testLauncher == null) {
            GradleExecutionHelper.$$$reportNull$$$0(11);
        }
        return testLauncher;
    }

    @Deprecated
    private static void prepare(@NotNull ProjectConnection connection, @NotNull LongRunningOperation operation, @NotNull ExternalSystemTaskId id, @NotNull List<String> tasksAndArguments, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(12);
        }
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(13);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(14);
        }
        if (tasksAndArguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(15);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(16);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(17);
        }
        GradleExecutionSettings effectiveSettings = new GradleExecutionSettings(settings);
        effectiveSettings.setTasks(ContainerUtil.concat(effectiveSettings.getTasks(), tasksAndArguments));
        CancellationToken cancellationToken = GradleConnector.newCancellationTokenSource().token();
        GradleExecutionContextImpl context = new GradleExecutionContextImpl("", id, effectiveSettings, listener2, cancellationToken);
        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, context);
        context.setBuildEnvironment(buildEnvironment);
        GradleExecutionHelper.prepareForExecution(operation, context);
    }

    @Deprecated
    @NotNull
    public static BuildEnvironment getBuildEnvironment(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable CancellationToken cancellationToken, @Nullable GradleExecutionSettings settings) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(18);
        }
        if (taskId == null) {
            GradleExecutionHelper.$$$reportNull$$$0(19);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(20);
        }
        GradleExecutionSettings effectiveSettings = (GradleExecutionSettings)((Object)ObjectUtils.notNull((Object)((Object)settings), () -> new GradleExecutionSettings()));
        CancellationToken effectiveCancellationToken = (CancellationToken)ObjectUtils.notNull((Object)cancellationToken, () -> GradleConnector.newCancellationTokenSource().token());
        GradleExecutionContextImpl context = new GradleExecutionContextImpl("", taskId, effectiveSettings, listener2, effectiveCancellationToken);
        return GradleExecutionHelper.getBuildEnvironment(connection, context);
    }

    @Deprecated
    public <T> T execute(@NotNull String projectPath, @Nullable GradleExecutionSettings settings, @NotNull com.intellij.util.Function<? super ProjectConnection, ? extends T> f) {
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(21);
        }
        if (f == null) {
            GradleExecutionHelper.$$$reportNull$$$0(22);
        }
        return GradleExecutionHelper.execute(projectPath, settings, null, null, null, f);
    }

    @Deprecated
    public static <T> T execute(@NotNull String projectPath, @Nullable GradleExecutionSettings settings, @Nullable ExternalSystemTaskId taskId, @Nullable ExternalSystemTaskNotificationListener listener2, @Nullable CancellationToken cancellationToken, @NotNull com.intellij.util.Function<? super ProjectConnection, ? extends T> f) {
        String projectDir;
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(23);
        }
        if (f == null) {
            GradleExecutionHelper.$$$reportNull$$$0(24);
        }
        File projectPathFile = new File(projectPath);
        if (Files.isRegularFile(Path.of(projectPath, new String[0]), new LinkOption[0]) && projectPath.endsWith("gradle") && projectPathFile.getParent() != null) {
            List arguments;
            projectDir = projectPathFile.getParent();
            if (settings != null && !(arguments = settings.getArguments()).contains("-b") && !arguments.contains("--build-file")) {
                settings.withArguments(new String[]{"-b", projectPath});
            }
        } else {
            projectDir = projectPath;
        }
        GradleConnectorService connectorService = GradleConnectorService.getInstance(projectDir, taskId);
        return (T)connectorService.withGradleConnection(projectDir, taskId, settings, listener2, cancellationToken, connection -> {
            try {
                return SystemPropertiesAdjuster.executeAdjusted(projectDir, () -> f.fun(connection));
            }
            catch (ExternalSystemException | ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.warn("Gradle execution error", e);
                Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
                ExternalSystemException externalSystemException = new ExternalSystemException(ExceptionUtil.getMessage((Throwable)rootCause), e, new String[0]);
                externalSystemException.initCause(e);
                throw externalSystemException;
            }
        });
    }

    public static <T> T execute(@NotNull GradleExecutionContextImpl context, @NotNull Function<? super ProjectConnection, ? extends T> action) {
        if (context == null) {
            GradleExecutionHelper.$$$reportNull$$$0(25);
        }
        if (action == null) {
            GradleExecutionHelper.$$$reportNull$$$0(26);
        }
        return GradleExecutionHelper.execute(context.getProjectPath(), context.getSettings(), context.getTaskId(), context.getListener(), context.getCancellationToken(), connection -> {
            BuildEnvironment buildEnvironment = null;
            try {
                buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, context);
                context.setBuildEnvironment(buildEnvironment);
                return action.apply((ProjectConnection)connection);
            }
            catch (CancellationException ce) {
                throw ce;
            }
            catch (Exception ex) {
                throw GradleProjectResolver.createProjectResolverChain().getUserFriendlyError(buildEnvironment, ex, context.getProjectPath(), null);
            }
        });
    }

    public static void prepareForExecution(@NotNull LongRunningOperation operation, @NotNull GradleExecutionContext context) {
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(27);
        }
        if (context == null) {
            GradleExecutionHelper.$$$reportNull$$$0(28);
        }
        ExternalSystemTaskId id = context.getTaskId();
        GradleExecutionSettings settings = context.getSettings();
        ExternalSystemTaskNotificationListener listener2 = context.getListener();
        BuildEnvironment buildEnvironment = context.getBuildEnvironment();
        GradleExecutionHelper.applyIdeaParameters(settings);
        GradleExecutionHelper.setupLogging(settings, buildEnvironment);
        GradleExecutionHelperExtension.EP_NAME.forEachExtensionSafe(proc -> proc.configureSettings(settings, context));
        GradleExecutionHelper.clearSystemProperties(operation);
        GradleExecutionHelper.setupJvmArguments(operation, settings);
        GradleExecutionHelper.setupArguments(operation, settings);
        GradleExecutionHelper.setupEnvironment(operation, settings);
        GradleExecutionHelper.setupJavaHome(operation, settings, id);
        GradleExecutionHelper.setupProgressListeners(operation, settings, id, listener2, buildEnvironment);
        GradleExecutionHelper.setupStandardIO(operation, settings, id, listener2);
        operation.withCancellationToken(context.getCancellationToken());
        GradleExecutionHelperExtension.EP_NAME.forEachExtensionSafe(proc -> proc.configureOperation(operation, context));
    }

    private static void clearSystemProperties(LongRunningOperation operation) {
        operation.withSystemProperties(Collections.emptyMap());
    }

    private static void applyIdeaParameters(@NotNull GradleExecutionSettings settings) {
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(29);
        }
        if (settings.isOfflineWork()) {
            settings.withArgument("--offline");
        }
        settings.withArgument("-Didea.active=true");
        settings.withArgument("-Didea.version=" + GradleExecutionHelper.getIdeaVersion());
        settings.withArgument("-Didea.vendor.name=" + ApplicationInfo.getInstance().getShortCompanyName());
    }

    private static void setupProgressListeners(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable BuildEnvironment buildEnvironment) {
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(30);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(31);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(32);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(33);
        }
        Path buildRootDir = GradleExecutionHelper.getBuildRoot(buildEnvironment);
        GradleProgressListener progressListener = new GradleProgressListener(listener2, id, buildRootDir);
        operation.addProgressListener((org.gradle.tooling.ProgressListener)progressListener);
        operation.addProgressListener((ProgressListener)progressListener, new OperationType[]{OperationType.TASK, OperationType.FILE_DOWNLOAD});
        if (settings.isRunAsTest() && settings.isBuiltInTestEventsUsed()) {
            operation.addProgressListener((ProgressListener)progressListener, new OperationType[]{OperationType.TEST, OperationType.TEST_OUTPUT, OperationType.TASK});
        }
    }

    private static void setupStandardIO(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(34);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(35);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(36);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(37);
        }
        operation.setStandardOutput((OutputStream)new OutputWrapper(listener2, id, true));
        operation.setStandardError((OutputStream)new OutputWrapper(listener2, id, false));
        InputStream inputStream = (InputStream)settings.getUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY);
        if (inputStream != null) {
            operation.setStandardInput(inputStream);
        }
    }

    @VisibleForTesting
    public static void setupJvmArguments(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings) {
        List jvmArgs;
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(38);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(39);
        }
        if (!(jvmArgs = ContainerUtil.filter((Collection)settings.getJvmArguments(), it -> !StringUtil.isEmpty((String)it))).isEmpty()) {
            operation.addJvmArguments(ArrayUtilRt.toStringArray((Collection)jvmArgs));
        }
    }

    private static void setupJavaHome(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskId id) {
        String javaHome;
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(40);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(41);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(42);
        }
        String string = javaHome = GradleDaemonJvmHelper.isExecutingUpdateDaemonJvmTask(settings) ? GradleDaemonJvmHelper.getGradleJvmForUpdateDaemonJvmTask(id) : settings.getJavaHome();
        if (javaHome == null) {
            return;
        }
        Path javaHomePath = Path.of(javaHome, new String[0]);
        if (!Files.isDirectory(javaHomePath, new LinkOption[0])) {
            return;
        }
        if (EelProviderUtil.getEelDescriptor((Path)javaHomePath) == LocalEelDescriptor.INSTANCE) {
            operation.setJavaHome(new File(javaHome));
            LOG.debug("Java home to set for Gradle operation: " + String.valueOf(javaHomePath));
        } else {
            try {
                if (operation instanceof TargetModelBuilder) {
                    ((TargetModelBuilder)operation).patchJavaHome(javaHomePath);
                }
            }
            catch (Exception e) {
                LOG.debug("Unable to set %s as the java home for the operation", new Object[]{javaHomePath});
            }
        }
    }

    private static void setupArguments(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings) {
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(43);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(44);
        }
        GradleCommandLine commandLine = GradleExecutionHelper.fixUpGradleCommandLine(settings.getCommandLine());
        LOG.info("Passing command-line to Gradle Tooling API: " + StringUtil.join(GradleExecutionHelper.obfuscatePasswordParameters(commandLine.getTokens()), (String)" "));
        if (operation instanceof TestLauncher) {
            TestLauncher testLauncher = (TestLauncher)operation;
            GradleExecutionHelper.setupTestLauncherArguments(testLauncher, commandLine);
        } else if (operation instanceof BuildLauncher) {
            BuildLauncher buildLauncher = (BuildLauncher)operation;
            GradleExecutionHelper.setupBuildLauncherArguments(buildLauncher, commandLine, settings);
        } else {
            operation.withArguments(commandLine.getTokens());
        }
    }

    @NotNull
    private static GradleCommandLine fixUpGradleCommandLine(@NotNull GradleCommandLine commandLine) {
        if (commandLine == null) {
            GradleExecutionHelper.$$$reportNull$$$0(45);
        }
        ArrayList<GradleCommandLineTask> tasks2 = new ArrayList<GradleCommandLineTask>();
        for (GradleCommandLineTask task : commandLine.getTasks()) {
            String name = task.getName();
            List options = ContainerUtil.filter((Collection)task.getOptions(), it -> !GradleCommandLineUtil.isWildcardTestPattern(it));
            tasks2.add(new GradleCommandLineTask(name, options));
        }
        return new GradleCommandLine(tasks2, (List<? extends GradleCommandLineOption>)commandLine.getOptions());
    }

    private static void setupTestLauncherArguments(@NotNull TestLauncher testLauncher, @NotNull GradleCommandLine commandLine) {
        if (testLauncher == null) {
            GradleExecutionHelper.$$$reportNull$$$0(46);
        }
        if (commandLine == null) {
            GradleExecutionHelper.$$$reportNull$$$0(47);
        }
        for (GradleCommandLineTask task : commandLine.getTasks()) {
            Set<String> patterns = GradleCommandLineUtil.getTestPatterns(task);
            if (!patterns.isEmpty()) {
                testLauncher.withTestsFor(it -> it.forTaskPath(task.getName()).includePatterns((Collection)patterns));
                continue;
            }
            testLauncher.forTasks(ArrayUtil.toStringArray(task.getTokens()));
        }
        testLauncher.withArguments(commandLine.getOptions().getTokens());
    }

    private static void setupBuildLauncherArguments(@NotNull BuildLauncher buildLauncher, @NotNull GradleCommandLine commandLine, @NotNull GradleExecutionSettings settings) {
        if (buildLauncher == null) {
            GradleExecutionHelper.$$$reportNull$$$0(48);
        }
        if (commandLine == null) {
            GradleExecutionHelper.$$$reportNull$$$0(49);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(50);
        }
        buildLauncher.forTasks(ArrayUtil.toStringArray(commandLine.getTasks().getTokens()));
        buildLauncher.withArguments(commandLine.getOptions().getTokens());
        if (settings.isTestTaskRerun()) {
            Path initScript = GradleInitScriptUtil.createTestInitScript();
            buildLauncher.addArguments(new String[]{"--init-script", initScript.toString()});
        }
    }

    @VisibleForTesting
    public static void setupLogging(@NotNull GradleExecutionSettings settings, @Nullable BuildEnvironment buildEnvironment) {
        GradleProperties properties;
        LogLevel logLevel;
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(51);
        }
        List arguments = settings.getArguments();
        Collection options = GradleCommandLineOptionsProvider.LOGGING_OPTIONS.getOptions();
        List<String> optionsNames = GradleCommandLineOptionsProvider.getAllOptionsNames(options);
        if (ContainerUtil.exists(optionsNames, it -> arguments.contains(it))) {
            return;
        }
        Path buildRoot = GradleExecutionHelper.getBuildRoot(buildEnvironment);
        if (buildRoot != null && (logLevel = (properties = GradlePropertiesFile.getProperties(settings.getServiceDirectory(), buildRoot)).getGradleLogLevel()) != null) {
            switch (logLevel) {
                case DEBUG: {
                    settings.withArgument("-d");
                    break;
                }
                case INFO: {
                    settings.withArgument("-i");
                    break;
                }
                case WARN: {
                    settings.withArgument("-w");
                    break;
                }
                case QUIET: {
                    settings.withArgument("-q");
                }
            }
        }
        if (ContainerUtil.exists(optionsNames, it -> arguments.contains(it))) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application != null && application.isUnitTestMode()) {
            settings.withArgument("--info");
        }
    }

    @Nullable
    private static Path getBuildRoot(@Nullable BuildEnvironment buildEnvironment) {
        if (buildEnvironment == null) {
            return null;
        }
        return buildEnvironment.getBuildIdentifier().getRootDir().toPath();
    }

    private static void setupEnvironment(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings) {
        TargetEnvironmentConfigurationProvider environmentConfigurationProvider;
        TargetEnvironmentConfiguration environmentConfiguration;
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(52);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(53);
        }
        if ((environmentConfiguration = (TargetEnvironmentConfiguration)ObjectUtils.doIfNotNull((Object)(environmentConfigurationProvider = ExternalSystemExecutionAware.getEnvironmentConfigurationProvider((ExternalSystemExecutionSettings)settings)), it -> it.getEnvironmentConfiguration())) != null && !"local".equals(environmentConfiguration.getTypeId())) {
            if (settings.isPassParentEnvs()) {
                LOG.warn("Host system environment variables will not be passed for the target run.");
            }
            operation.setEnvironmentVariables(settings.getEnv());
            return;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withEnvironment(settings.getEnv());
        commandLine.withParentEnvironmentType(settings.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        Map effectiveEnvironment = commandLine.getEffectiveEnvironment();
        operation.setEnvironmentVariables(effectiveEnvironment);
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static BuildEnvironment getBuildEnvironment(@NotNull ProjectConnection connection, @NotNull GradleExecutionContext context) {
        BuildEnvironment buildEnvironment;
        Scope ignore;
        Span span;
        block17: {
            BuildEnvironment buildEnvironment22;
            if (connection == null) {
                GradleExecutionHelper.$$$reportNull$$$0(54);
            }
            if (context == null) {
                GradleExecutionHelper.$$$reportNull$$$0(55);
            }
            span = ExternalSystemTelemetryUtil.getTracer((ProjectSystemId)GradleConstants.SYSTEM_ID).spanBuilder("GetBuildEnvironment").startSpan();
            ignore = span.makeCurrent();
            try {
                ExternalSystemTaskId taskId = context.getTaskId();
                ExternalSystemTaskNotificationListener listener2 = context.getListener();
                ModelBuilder modelBuilder = connection.model(BuildEnvironment.class);
                modelBuilder.withCancellationToken(context.getCancellationToken());
                GradleExecutionHelper.setupJavaHome((LongRunningOperation)modelBuilder, context.getSettings(), taskId);
                GradleProgressListener gradleProgressListener = new GradleProgressListener(listener2, taskId);
                modelBuilder.addProgressListener((org.gradle.tooling.ProgressListener)gradleProgressListener);
                modelBuilder.addProgressListener((ProgressListener)gradleProgressListener);
                modelBuilder.setStandardOutput((OutputStream)new OutputWrapper(listener2, taskId, true));
                modelBuilder.setStandardError((OutputStream)new OutputWrapper(listener2, taskId, false));
                buildEnvironment22 = (BuildEnvironment)modelBuilder.get();
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to obtain build environment from Gradle daemon.", ex);
            }
            GradleExecutionHelper.checkThatGradleBuildEnvironmentIsSupportedByIdea(buildEnvironment22);
            buildEnvironment = buildEnvironment22;
            if (ignore == null) break block17;
            ignore.close();
        }
        BuildEnvironment buildEnvironment3 = buildEnvironment;
        if (buildEnvironment3 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(56);
        }
        return buildEnvironment3;
        {
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CancellationException ce) {
                    throw ce;
                }
                catch (Exception ex) {
                    span.recordException((Throwable)ex);
                    span.setStatus(StatusCode.ERROR);
                    throw ex;
                }
            }
        }
        finally {
            span.end();
        }
    }

    private static void checkThatGradleBuildEnvironmentIsSupportedByIdea(@NotNull BuildEnvironment buildEnvironment) {
        if (buildEnvironment == null) {
            GradleExecutionHelper.$$$reportNull$$$0(57);
        }
        GradleVersion gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        LOG.debug("Gradle version: " + String.valueOf(gradleVersion));
        if (!GradleJvmSupportMatrix.isGradleSupportedByIdea(gradleVersion)) {
            throw new UnsupportedGradleVersionByIdeaException(gradleVersion);
        }
        File javaHome = buildEnvironment.getJava().getJavaHome();
        List jvmArguments = buildEnvironment.getJava().getJvmArguments();
        LOG.debug("Gradle java home: " + String.valueOf(javaHome));
        LOG.debug("Gradle jvm arguments: " + String.valueOf(jvmArguments));
        JavaVersion javaVersion = ExternalSystemJdkUtil.getJavaVersion((String)javaHome.getPath());
        if (javaVersion != null && !GradleJvmSupportMatrix.isJavaSupportedByIdea(javaVersion)) {
            throw new UnsupportedGradleJvmByIdeaException(gradleVersion, javaVersion);
        }
    }

    @VisibleForTesting
    @NotNull
    public static List<String> obfuscatePasswordParameters(@NotNull List<String> commandLineArguments) {
        if (commandLineArguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(58);
        }
        ArrayList<String> replaced = new ArrayList<String>(commandLineArguments.size());
        String PASSWORD_PARAMETER_IDENTIFIER = ".password=";
        for (String option : commandLineArguments) {
            int index = option.indexOf(".password=");
            if (index == -1) {
                replaced.add(option);
                continue;
            }
            replaced.add(option.substring(0, index + ".password=".length()) + "*********");
        }
        ArrayList<String> arrayList = replaced;
        if (arrayList == null) {
            GradleExecutionHelper.$$$reportNull$$$0(59);
        }
        return arrayList;
    }

    private static String getIdeaVersion() {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        return appInfo.getMajorVersion() + "." + appInfo.getMinorVersion();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 11, 56, 59 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: 
            case 7: 
            case 14: 
            case 32: 
            case 36: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksAndArguments";
                break;
            }
            case 3: 
            case 9: 
            case 16: 
            case 29: 
            case 31: 
            case 35: 
            case 39: 
            case 41: 
            case 44: 
            case 50: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 10: 
            case 17: 
            case 20: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 11: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper";
                break;
            }
            case 13: 
            case 27: 
            case 30: 
            case 34: 
            case 38: 
            case 40: 
            case 43: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 25: 
            case 28: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 45: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testLauncher";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildLauncher";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildEnvironment";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildLauncher";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestLauncher";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildEnvironment";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "obfuscatePasswordParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBuildLauncher";
                break;
            }
            case 5: 
            case 11: 
            case 56: 
            case 59: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTestLauncher";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getBuildEnvironment";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "prepareForExecution";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "applyIdeaParameters";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setupProgressListeners";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setupStandardIO";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setupJvmArguments";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setupJavaHome";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setupArguments";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "fixUpGradleCommandLine";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "setupTestLauncherArguments";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "setupBuildLauncherArguments";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "setupLogging";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "setupEnvironment";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "checkThatGradleBuildEnvironmentIsSupportedByIdea";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "obfuscatePasswordParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 11, 56, 59 -> new IllegalStateException(string);
        };
    }

    public static class UnsupportedGradleVersionByIdeaException
    extends RuntimeException {
        @NotNull
        private final GradleVersion myGradleVersion;

        public UnsupportedGradleVersionByIdeaException(@NotNull GradleVersion gradleVersion) {
            if (gradleVersion == null) {
                UnsupportedGradleVersionByIdeaException.$$$reportNull$$$0(0);
            }
            super("Unsupported Gradle version");
            this.myGradleVersion = gradleVersion;
        }

        @NotNull
        public GradleVersion getGradleVersion() {
            GradleVersion gradleVersion = this.myGradleVersion;
            if (gradleVersion == null) {
                UnsupportedGradleVersionByIdeaException.$$$reportNull$$$0(1);
            }
            return gradleVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleVersion";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper$UnsupportedGradleVersionByIdeaException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper$UnsupportedGradleVersionByIdeaException";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGradleVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class UnsupportedGradleJvmByIdeaException
    extends RuntimeException {
        @NotNull
        private final GradleVersion myGradleVersion;
        @Nullable
        private final JavaVersion myJavaVersion;

        public UnsupportedGradleJvmByIdeaException(@NotNull GradleVersion gradleVersion, @Nullable JavaVersion javaVersion) {
            if (gradleVersion == null) {
                UnsupportedGradleJvmByIdeaException.$$$reportNull$$$0(0);
            }
            super("Unsupported Gradle JVM version");
            this.myGradleVersion = gradleVersion;
            this.myJavaVersion = javaVersion;
        }

        @NotNull
        public GradleVersion getGradleVersion() {
            GradleVersion gradleVersion = this.myGradleVersion;
            if (gradleVersion == null) {
                UnsupportedGradleJvmByIdeaException.$$$reportNull$$$0(1);
            }
            return gradleVersion;
        }

        @Nullable
        public JavaVersion getJavaVersion() {
            return this.myJavaVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleVersion";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper$UnsupportedGradleJvmByIdeaException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper$UnsupportedGradleJvmByIdeaException";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGradleVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

