/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.task;

import com.intellij.debugger.engine.AsyncStacksUtils;
import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunnableState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManagerExtension;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/gradle/service/task/JavaGradleTaskManagerExtension;", "Lorg/jetbrains/plugins/gradle/service/task/GradleTaskManagerExtension;", "<init>", "()V", "configureTasks", "", "projectPath", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "configureTestLogger", "configureJvmDebugger", "configureJvmOptions", "Companion", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nJavaGradleTaskManagerExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaGradleTaskManagerExtension.kt\norg/jetbrains/plugins/gradle/service/task/JavaGradleTaskManagerExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n827#2:97\n855#2,2:98\n1563#2:100\n1634#2,3:101\n*S KotlinDebug\n*F\n+ 1 JavaGradleTaskManagerExtension.kt\norg/jetbrains/plugins/gradle/service/task/JavaGradleTaskManagerExtension\n*L\n62#1:97\n62#1:98,2\n82#1:100\n82#1:101,3\n*E\n"})
public final class JavaGradleTaskManagerExtension
implements GradleTaskManagerExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TEST_LOGGER_SCRIPT_NAME = "ijTestLogger";
    @NotNull
    private static final String JVM_DEBUGGER_SCRIPT_NAME = "ijJvmDebugger";
    @NotNull
    private static final String JVM_OPTIONS_SCRIPT_NAME = "ijJvmOptions";
    @NotNull
    private static final Logger LOG;

    public void configureTasks(@NotNull String projectPath, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings, @Nullable GradleVersion gradleVersion) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.configureTestLogger(settings);
        this.configureJvmDebugger(id, settings);
        this.configureJvmOptions(settings);
    }

    private final void configureTestLogger(GradleExecutionSettings settings) {
        if (settings.isRunAsTest()) {
            if (settings.isBuiltInTestEventsUsed()) {
                settings.addInitScript(TEST_LOGGER_SCRIPT_NAME, GradleInitScriptUtil.loadFileComparisonTestLoggerInitScript());
            } else {
                settings.addInitScript(TEST_LOGGER_SCRIPT_NAME, GradleInitScriptUtil.loadIjTestLoggerInitScript());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void configureJvmDebugger(ExternalSystemTaskId id, GradleExecutionSettings settings) {
        Integer debuggerDispatchPort = (Integer)settings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_PORT_KEY);
        String string = (String)settings.getUserData(ExternalSystemRunnableState.DEBUGGER_PARAMETERS_KEY);
        if (string == null) {
            string = "";
        }
        String debuggerParameters = string;
        settings.addInitScript(JVM_DEBUGGER_SCRIPT_NAME, GradleInitScriptUtil.loadJvmDebugInitScript());
        if (debuggerDispatchPort != null) {
            void $this$filterNotTo$iv$iv;
            JavaParameters javaParameters = new JavaParameters();
            AsyncStacksUtils.addDebuggerAgent((JavaParameters)javaParameters, (Project)id.findProject(), (boolean)false);
            List list = javaParameters.getVMParametersList().getList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
            Iterable $this$filterNot$iv = list;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (StringsKt.startsWith$default((String)it, (String)"-agentlib:jdwp=", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List jvmArgs = (List)destination$iv$iv;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"DEBUGGER_ID", (Object)"Gradle JVM"), TuplesKt.to((Object)"PROCESS_PARAMETERS", (Object)debuggerParameters), TuplesKt.to((Object)"PROCESS_OPTIONS", (Object)CollectionsKt.joinToString$default((Iterable)jvmArgs, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null))};
            settings.withEnvironmentVariables(MapsKt.mapOf((Pair[])pairArray));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void configureJvmOptions(GradleExecutionSettings settings) {
        String string = StringKt.nullize$default((String)settings.getJvmParameters(), (boolean)false, (int)1, null);
        if (string == null) {
            return;
        }
        String jvmParameters = string;
        LOG.assertTrue(!StringsKt.contains$default((CharSequence)jvmParameters, (CharSequence)"-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=", (boolean)false, (int)2, null), (Object)"Please use org.jetbrains.plugins.gradle.service.debugger.GradleJvmDebuggerBackend to setup debugger");
        List list = ParametersListUtil.parse((String)jvmParameters);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(...)");
        List jvmArgs = list;
        if (SystemInfo.isWindows) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = jvmArgs;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CommandLineUtil.escapeParameterOnWindows((String)it, (boolean)false));
            }
            jvmArgs = (List)destination$iv$iv;
        }
        List list2 = settings.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTasks(...)");
        settings.addInitScript(JVM_OPTIONS_SCRIPT_NAME, GradleInitScriptUtil.loadJvmOptionsInitScript((List)list2, (List)jvmArgs));
    }

    static {
        Logger logger = Logger.getInstance(JavaGradleTaskManagerExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/gradle/service/task/JavaGradleTaskManagerExtension$Companion;", "", "<init>", "()V", "TEST_LOGGER_SCRIPT_NAME", "", "JVM_DEBUGGER_SCRIPT_NAME", "JVM_OPTIONS_SCRIPT_NAME", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

