/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XRenderDirectFormat;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XRenderPictFormat
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 40;
    }

    @Override
    public int getDataSize() {
        return XRenderPictFormat.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XRenderPictFormat(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XRenderPictFormat() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XRenderPictFormat.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public long get_id() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_id(long l) {
        log.finest("");
        Native.putLong(this.pData + 0L, l);
    }

    public int get_type() {
        log.finest("");
        return Native.getInt(this.pData + 8L);
    }

    public void set_type(int n) {
        log.finest("");
        Native.putInt(this.pData + 8L, n);
    }

    public int get_depth() {
        log.finest("");
        return Native.getInt(this.pData + 12L);
    }

    public void set_depth(int n) {
        log.finest("");
        Native.putInt(this.pData + 12L, n);
    }

    public XRenderDirectFormat get_direct() {
        log.finest("");
        return new XRenderDirectFormat(this.pData + 16L);
    }

    public long get_colormap() {
        log.finest("");
        return Native.getLong(this.pData + 32L);
    }

    public void set_colormap(long l) {
        log.finest("");
        Native.putLong(this.pData + 32L, l);
    }

    @Override
    String getName() {
        return "XRenderPictFormat";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("id = ").append(this.get_id()).append(", ");
        stringBuilder.append("type = ").append(XlibWrapper.eventToString[this.get_type()]).append(", ");
        stringBuilder.append("depth = ").append(this.get_depth()).append(", ");
        stringBuilder.append("direct = ").append(this.get_direct()).append(", ");
        stringBuilder.append("colormap = ").append(this.get_colormap()).append(", ");
        return stringBuilder.toString();
    }
}

