/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.kafka.raft.internals.LogHistory;

public final class TreeMapLogHistory<T>
implements LogHistory<T> {
    private final NavigableMap<Long, T> history = new TreeMap<Long, T>();

    @Override
    public void addAt(long offset, T value) {
        if (offset < -1L) {
            throw new IllegalArgumentException(String.format("Next offset %d must be greater than or equal to -1", offset));
        }
        Map.Entry<Long, T> lastEntry = this.history.lastEntry();
        if (lastEntry != null && offset <= lastEntry.getKey()) {
            throw new IllegalArgumentException(String.format("Next offset %d must be greater than the last offset %d", offset, lastEntry.getKey()));
        }
        this.history.put(offset, value);
    }

    @Override
    public Optional<T> valueAtOrBefore(long offset) {
        return Optional.ofNullable(this.history.floorEntry(offset)).map(Map.Entry::getValue);
    }

    @Override
    public Optional<LogHistory.Entry<T>> lastEntry() {
        return Optional.ofNullable(this.history.lastEntry()).map(entry -> new LogHistory.Entry((Long)entry.getKey(), entry.getValue()));
    }

    @Override
    public void truncateNewEntries(long endOffset) {
        this.history.tailMap(endOffset, true).clear();
    }

    @Override
    public void truncateOldEntries(long startOffset) {
        NavigableMap<Long, T> lesserValues = this.history.headMap(startOffset, true);
        while (lesserValues.size() > 1) {
            lesserValues.pollFirstEntry();
        }
    }

    @Override
    public void clear() {
        this.history.clear();
    }
}

