/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.ConfigValue;
import io.smallrye.config.PropertiesConfigSource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.Picocli;

public final class PersistedConfigSource
extends PropertiesConfigSource {
    public static final String NAME = "PersistedConfigSource";
    public static final String PERSISTED_PROPERTIES = "META-INF/keycloak-persisted.properties";
    private static final PersistedConfigSource INSTANCE = new PersistedConfigSource();
    private static final ThreadLocal<Boolean> ENABLED = ThreadLocal.withInitial(() -> true);

    private PersistedConfigSource() {
        super(PersistedConfigSource.readProperties(), NAME, 200);
    }

    public static PersistedConfigSource getInstance() {
        return INSTANCE;
    }

    public ConfigValue getConfigValue(String propertyName) {
        if (this.isEnabled()) {
            return super.getConfigValue(propertyName);
        }
        return null;
    }

    public Set<String> getPropertyNames() {
        if (this.isEnabled()) {
            return super.getPropertyNames();
        }
        return Set.of();
    }

    private static Map<String, String> readProperties() {
        if (!Environment.isRebuild().booleanValue()) {
            HashMap<String, String> hashMap;
            block11: {
                InputStream fileStream = PersistedConfigSource.loadPersistedConfig();
                if (fileStream == null) {
                    return Collections.emptyMap();
                }
                InputStream inputStream = fileStream;
                try {
                    Properties properties = new Properties();
                    properties.load(fileStream);
                    HashMap<String, String> props = new HashMap<String, String>();
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        props.put(entry.getKey().toString(), entry.getValue().toString());
                    }
                    hashMap = props;
                    if (inputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to load persisted properties.", e);
                    }
                }
                inputStream.close();
            }
            return hashMap;
        }
        return Collections.emptyMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static InputStream loadPersistedConfig() {
        Path homePath = Environment.getHomePath().orElse(null);
        if (homePath == null) {
            return null;
        }
        File configFile = homePath.resolve("lib").resolve("quarkus").resolve("generated-bytecode.jar").toFile();
        if (!configFile.exists()) {
            return null;
        }
        if (!Environment.isWindows()) {
            return PersistedConfigSource.class.getClassLoader().getResourceAsStream(PERSISTED_PROPERTIES);
        }
        try (ZipInputStream is = new ZipInputStream(new FileInputStream(configFile));){
            ZipEntry entry;
            do {
                if ((entry = is.getNextEntry()) == null) return null;
            } while (!entry.getName().equals(PERSISTED_PROPERTIES));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(is.readAllBytes());
            return byteArrayInputStream;
        }
        catch (Exception cause) {
            throw new RuntimeException("Failed to load persisted properties from " + String.valueOf(configFile), cause);
        }
    }

    public void enable() {
        ENABLED.set(true);
    }

    public void disable() {
        ENABLED.set(false);
    }

    private boolean isEnabled() {
        return Boolean.TRUE.equals(ENABLED.get());
    }

    public <T> T runWithDisabled(Supplier<T> execution) {
        if (!this.isEnabled()) {
            return execution.get();
        }
        try {
            this.disable();
            T t = execution.get();
            return t;
        }
        finally {
            this.enable();
        }
    }

    public void saveDryRunProperties() throws FileNotFoundException, IOException {
        Path path = Environment.getHomePath().orElseThrow().resolve("lib").resolve("dryRun.properties");
        Properties properties = Picocli.getNonPersistedBuildTimeOptions();
        try (FileOutputStream fos = new FileOutputStream(path.toFile());){
            properties.store(fos, null);
        }
    }

    public void useDryRunProperties() {
        Path path = Environment.getHomePath().orElseThrow().resolve("lib").resolve("dryRun.properties");
        if (Files.exists(path, new LinkOption[0])) {
            Properties properties = new Properties();
            try (FileInputStream fis = new FileInputStream(path.toFile());){
                properties.load(fis);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Map config = this.getConfigValueProperties();
            config.clear();
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> config.put((String)k, new ConfigValue.ConfigValueBuilder().withName((String)k).withValue((String)v).withRawValue((String)v).withConfigSourceName(this.getName()).withConfigSourceOrdinal(this.getOrdinal()).build())));
        }
    }
}

