/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.eviction.impl.PassivationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.globalstate.LocalConfigurationStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.util.DependencyGraph;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class VolatileLocalConfigurationStorage
implements LocalConfigurationStorage {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    protected EmbeddedCacheManager cacheManager;
    protected ParserRegistry parserRegistry;
    protected ConfigurationManager configurationManager;
    protected BlockingManager blockingManager;

    @Override
    public void initialize(EmbeddedCacheManager cacheManager, ConfigurationManager configurationManager, BlockingManager blockingManager) {
        this.configurationManager = configurationManager;
        this.cacheManager = cacheManager;
        this.parserRegistry = new ParserRegistry();
        this.blockingManager = blockingManager;
    }

    @Override
    public void validateFlags(EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        if (!flags.contains(CacheContainerAdmin.AdminFlag.VOLATILE)) {
            throw Log.CONFIG.globalStateDisabled();
        }
    }

    @Override
    public CompletionStage<Void> createTemplate(String name, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        Configuration existing = SecurityActions.getCacheConfiguration(this.cacheManager, name);
        if (existing == null) {
            SecurityActions.defineConfiguration(this.cacheManager, name, configuration);
            log.debugf("Defined template '%s' on '%s' using %s", name, this.cacheManager.getAddress(), (Object)configuration);
        } else {
            if (!existing.matches(configuration)) {
                throw Log.CONFIG.incompatibleClusterConfiguration(name, configuration, existing);
            }
            log.debugf("%s already has a template %s with configuration %s", this.cacheManager.getAddress(), name, (Object)configuration);
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> createCache(String name, String template, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        Configuration existing = SecurityActions.getCacheConfiguration(this.cacheManager, name);
        if (existing == null) {
            SecurityActions.defineConfiguration(this.cacheManager, name, configuration);
            log.debugf("Defined cache '%s' on '%s' using %s", name, this.cacheManager.getAddress(), (Object)configuration);
        } else {
            if (!existing.matches(configuration)) {
                throw Log.CONFIG.incompatibleClusterConfiguration(name, configuration, existing);
            }
            if (!existing.equals((Object)configuration)) {
                return this.updateConfiguration(name, configuration, flags);
            }
            log.debugf("%s already has a cache %s with configuration %s", this.cacheManager.getAddress(), name, (Object)configuration);
        }
        return this.blockingManager.supplyBlocking(() -> {
            try {
                SecurityActions.getCache(this.cacheManager, name);
            }
            catch (CacheException cacheException) {
                log.cannotObtainFailedCache(name, cacheException);
            }
            return null;
        }, name).toCompletableFuture();
    }

    @Override
    public CompletionStage<Void> validateConfigurationUpdate(String name, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        Configuration existing = SecurityActions.getCacheConfiguration(this.cacheManager, name);
        if (existing != null) {
            existing.validateUpdate(name, configuration);
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> updateConfiguration(String name, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        Configuration existing = SecurityActions.getCacheConfiguration(this.cacheManager, name);
        if (existing == null) {
            throw Log.CONFIG.noSuchCacheConfiguration(name);
        }
        existing.update(name, configuration);
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> removeCache(String name, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        return this.blockingManager.supplyBlocking(() -> {
            this.removeCacheSync(name, flags);
            return null;
        }, name).toCompletableFuture();
    }

    protected void removeCacheSync(String name, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        log.debugf("Remove cache %s", name);
        GlobalComponentRegistry globalComponentRegistry = SecurityActions.getGlobalComponentRegistry(this.cacheManager);
        ComponentRegistry cacheComponentRegistry = globalComponentRegistry.getNamedComponentRegistry(name);
        if (cacheComponentRegistry != null) {
            cacheComponentRegistry.getComponent(PersistenceManager.class).setClearOnStop(true);
            cacheComponentRegistry.getComponent(PassivationManager.class).skipPassivationOnStop(true);
            Cache cache = this.cacheManager.getCache(name, false);
            if (cache != null) {
                SecurityActions.stopCache(cache);
            }
        }
        globalComponentRegistry.removeCache(name);
        globalComponentRegistry.getComponent(ConfigurationManager.class).removeConfiguration(name);
        globalComponentRegistry.getComponent(DependencyGraph.class, "org.infinispan.CacheDependencyGraph").remove(name);
    }

    @Override
    public CompletionStage<Void> removeTemplate(String name, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        this.removeTemplateSync(name, flags);
        return CompletableFutures.completedNull();
    }

    protected void removeTemplateSync(String name, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        log.debugf("Remove template %s", name);
        GlobalComponentRegistry globalComponentRegistry = SecurityActions.getGlobalComponentRegistry(this.cacheManager);
        globalComponentRegistry.getComponent(ConfigurationManager.class).removeConfiguration(name);
    }

    @Override
    public Map<String, Configuration> loadAllCaches() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Configuration> loadAllTemplates() {
        return Collections.emptyMap();
    }
}

